/**
 * Copyright syunki ( http://wonderfl.net/user/syunki )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/gfxy
 */

// forked from yanbaka's HANABI
// 色々参考にさせて頂いてます
// 爆発させてみました。
package
{
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.display.BlendMode;
	import flash.display.PixelSnapping;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.TimerEvent;
	import flash.filters.BlurFilter;
	import flash.geom.ColorTransform;
	import flash.geom.Matrix;
	import flash.geom.Point;
	import flash.geom.Rectangle;
	import flash.utils.Timer;
	[SWF(width = "465", height = "465", backgroundColor = "0x000000", frameRate = "30")]
	
	public class Hanabi extends Sprite
	{
		private const WIDTH:Number = 465;
		private const HEIGH:Number = 465;
		
		private var _particles:Array;
		private var _canvas:BitmapData;
		private var _glow:BitmapData;
		private var _rect:Rectangle;
		private var cTra:ColorTransform;
		private var timer:Timer;
		
		private var sa:Number;
		
		
		public function Hanabi()
		{
			init();
		}
		
		private function init():void
		{
			_particles = [];
			_canvas = new BitmapData(WIDTH, HEIGH, false, 0x0);
			addChild(new Bitmap(_canvas)) as Bitmap;
			
			_glow = new BitmapData(WIDTH/4, HEIGH/4, false, 0x0);
			var bm:Bitmap = addChild(new Bitmap(_glow, PixelSnapping.NEVER, true)) as Bitmap;
			bm.scaleX = bm.scaleY = 4;
			bm.blendMode = BlendMode.ADD;
			
			_rect = new Rectangle(0, 0, WIDTH, HEIGH);
			cTra = new ColorTransform(.9, .8, .8, 1.0);
			
			this.stage.addEventListener(Event.ENTER_FRAME, enterframeHandler);
			
			timer = new Timer(100);
			timer.addEventListener(TimerEvent.TIMER, resetFunc);
			timer.start();
		}
		
		private function resetFunc(e:TimerEvent):void
		{
			(cTra.greenMultiplier > 0.85)? cTra.greenMultiplier = 0.8 : cTra.greenMultiplier += 0.01;
			
			hanabi();
		}
		
		private function hanabi():void 
		{
			var i:int = 200;
			while (i--) {
                                sa = Math.random() * Math.PI * 2;
                                createFragment();
                            }
		}
		
		private function createFragment():void {
			var p:Particle = new Particle();
			p.a = sa;
			p.r = 0;
			var radius:Number = Math.sqrt(Math.random())*25;
			var angle:Number = Math.random()*(Math.PI)*2;
			p.vr = Math.cos(angle) * radius;
			_particles.push(p);
		}
		
		private function enterframeHandler(e:Event):void
		{
			update();
		}
		
		private function update():void {
			_canvas.lock();
			_canvas.applyFilter(_canvas, _rect, new Point(), new BlurFilter(1, 1));
			_canvas.colorTransform(_rect, cTra);
			var i:int = _particles.length;
			while (i--) {
				var p:Particle = _particles[i];
				p.vr *= 0.9;
				p.r += p.vr;

                                     var x:int = WIDTH / 2 + p.r * Math.cos(p.a);
                                     var y:int = HEIGH / 2 + p.r * Math.sin(p.a);

				_canvas.setPixel32(x, y, p.c);
				if ((x > stage.stageWidth || x < 0) || (y < 0 || y > stage.stageHeight) || p.vr < .01)
				{
					this._particles.splice(i, 1);
				}
			}
			_canvas.unlock();
			_glow.draw(_canvas, new Matrix(0.25, 0, 0, 0.25));
		}
	}
}

class Particle
{
	public var a:Number;
	public var r:Number;
	public var vr:Number;
	public var c:uint;
	
	public function Particle()
	{
		this.a = 0;
		this.r = 0;
		this.vr = 0;
		this.c = 0xFFFFFFFF;
	}
}

