/**
 * Copyright GaraGalla ( http://wonderfl.net/user/GaraGalla )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/gfmv
 */

package

{

    import alternativ5.engine3d.controllers.*;

    import alternativ5.engine3d.core.*;

    import alternativ5.engine3d.display.*;

    import alternativ5.engine3d.materials.*;

    import alternativ5.engine3d.primitives.*;

    import alternativ5.types.*;

    import alternativ5.utils.*;

    

    import flash.net.*;

    import flash.display.*;

    import flash.events.*;

    import flash.geom.*;



    [SWF(frameRate="30")]

    

    public class Main extends Sprite

    {

        private const COL_NUM:int = 20;

        private const ROW_NUM:int = 20;

        

        private const CELL_WIDTH:Number = 1000;

        private const CELL_HEIGHT:Number = 1000;

        private const WALL_WIDTH:Number = 10;

        private const FLOOR_HEIGHT:Number = 10;

        

        //cell

        //0: null

        //1: floor

        //2: block

        //4: elv

        

        private const CELL_FLOOR:uint = 1;

        private const CELL_BLOCK:uint = 2;

        

        

        

        private const CELL_ARR:Array = 

            [

                [1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],

                [1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],

                [1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],

                [1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],

                [1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],

                [1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],

                [1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],

                [1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],

                [1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],

                [1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],

                [1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],

                [1,1,1,1,1,1,1,1,1,1,0,1,1,1,1,1,1,1,1,1],

                [1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],

                [1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],

                [1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],

                [1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],

                [1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],

                [1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],

                [1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],

                [1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1]

            ];

        

        

        //walls

        //0: null

        //1: wall

        //2: door

        //4: hidden door

        

        private const WALL_WALL:uint = 1;

        private const WALL_DOOR:uint = 2;

        private const WALL_HIDDEN_DOOR:uint = 4;

        private const NEWS_X:Array = [0, 1, 0, -1];

        private const NEWS_Y:Array = [-1, 0, 1, 0];

        private const NEWS_ROT:Array = [90, 0, -90, 180];

        

        

        //[north, east, south, west]

        private const WALL_ARR:Array = 

        [



[

[1,2,1,1,1,1,1,1,1,1,0,1,1,1,1,1,1,1,1,1],

[1,1,2,1,2,1,0,0,0,1,0,0,4,4,1,1,0,0,4,4],

[2,1,2,0,1,1,0,0,0,0,0,0,1,1,1,4,1,1,0,0],

[1,1,1,0,1,1,1,1,2,0,0,0,0,0,1,1,1,1,1,1],

[0,0,0,2,0,0,0,0,0,1,0,0,0,0,0,1,1,2,0,0],

[0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,1,1,4,4],

[1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,1,1,1,1],

[1,2,1,0,1,0,1,1,0,0,1,0,0,0,0,0,2,2,0,0],

[0,0,0,0,0,0,0,0,2,0,0,0,0,0,0,0,0,0,4,4],

[1,1,1,1,1,2,1,1,1,0,0,0,0,0,0,0,1,0,1,2],

[1,1,1,1,1,1,1,1,1,0,0,2,1,2,1,2,1,2,1,1],

[1,1,1,1,1,1,1,1,1,0,1,1,1,1,1,1,1,1,1,1],

[0,1,1,0,1,1,0,1,1,1,0,0,1,1,1,1,0,1,1,1],

[0,0,0,0,0,1,2,1,0,0,0,0,4,1,1,0,0,0,1,0],

[0,0,0,0,0,0,0,0,0,0,0,0,4,1,2,2,0,0,0,0],

[0,0,0,0,0,1,1,1,0,0,0,0,4,1,0,0,0,0,0,0],

[0,0,1,2,1,0,0,0,0,0,0,0,4,1,0,0,0,0,0,0],

[0,0,0,0,0,0,1,1,1,0,0,0,4,1,1,2,1,0,0,0],

[0,0,1,1,1,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0],

[0,1,1,1,1,1,1,2,1,0,0,1,1,1,1,1,1,1,1,1]

],

[

[0,1,1,0,1,0,0,0,1,2,1,2,0,2,0,2,0,1,1,1],

[0,4,0,0,0,2,0,0,1,0,1,1,1,1,0,1,0,1,0,1],

[1,1,1,1,0,1,0,0,1,0,1,1,1,2,0,2,0,2,0,1],

[0,0,1,1,0,0,1,1,1,1,1,1,1,1,0,1,0,1,0,1],

[0,0,2,2,0,0,1,1,1,0,1,1,1,1,1,2,0,2,0,1],

[0,0,1,1,0,0,1,1,1,0,1,1,1,1,1,1,0,1,1,1],

[0,0,0,1,1,1,0,1,1,0,1,1,1,1,1,1,0,2,0,1],

[0,0,1,0,2,2,0,1,1,0,1,1,1,1,1,1,1,1,0,1],

[0,0,1,0,1,1,0,1,1,0,1,1,1,1,1,1,1,1,1,1],

[0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,2,1,0,1],

[0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,4],

[0,0,0,0,0,0,0,0,2,1,1,0,0,0,0,0,0,0,0,1],

[1,0,1,1,0,1,1,0,1,0,1,1,4,1,0,1,1,0,0,1],

[1,0,1,1,1,0,0,1,1,0,1,1,1,4,1,1,1,1,1,1],

[1,0,1,1,1,0,0,1,1,0,1,1,1,2,0,1,1,1,1,1],

[1,0,1,1,0,0,0,0,1,0,1,1,1,2,0,1,1,1,1,1],

[1,1,0,0,1,0,0,0,1,0,1,1,1,2,0,1,1,1,1,1],

[1,1,0,0,1,1,0,0,1,0,1,1,1,1,1,2,0,1,1,1],

[1,0,0,0,0,1,0,0,1,0,1,0,0,0,0,0,0,0,1,1],

[0,0,0,0,0,0,0,0,1,0,1,0,0,0,0,0,0,0,0,1]

],

[

[1,1,2,1,2,1,0,0,0,1,0,0,4,4,1,1,0,0,4,4],

[2,1,2,0,1,1,0,0,0,0,0,0,1,1,1,4,1,1,0,0],

[1,1,1,0,1,1,1,1,4,0,0,0,0,0,1,1,1,1,1,1],

[0,0,0,2,0,0,0,0,0,1,0,0,0,0,0,1,1,2,0,0],

[0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,1,1,4,4],

[1,1,1,0,1,1,1,0,0,0,0,0,0,0,0,0,1,1,1,1],

[1,2,1,0,1,0,1,1,0,0,1,0,0,0,0,0,2,2,0,0],

[0,0,0,0,0,0,0,0,2,0,0,0,0,0,0,0,0,0,4,4],

[1,1,1,1,1,2,1,1,1,0,0,0,0,0,0,0,1,0,1,1],

[1,1,1,1,1,1,1,1,1,0,0,2,1,2,1,2,1,2,1,1],

[1,1,1,1,1,1,1,1,1,0,1,1,1,1,1,1,1,1,1,1],

[0,1,1,0,1,1,0,1,1,1,0,0,1,1,1,1,0,1,1,1],

[0,0,0,0,0,1,2,1,0,0,0,0,1,4,1,0,0,0,1,0],

[0,0,0,0,0,0,0,0,0,0,0,0,1,1,2,2,0,0,0,0],

[0,0,0,0,0,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0],

[0,0,1,2,1,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0],

[0,0,0,0,0,0,1,1,1,0,0,0,1,1,2,2,1,0,0,0],

[0,0,1,1,1,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0],

[0,1,1,1,1,2,1,2,1,0,0,1,1,1,1,1,1,1,1,2],

[1,1,1,1,1,1,1,1,1,1,0,1,1,1,1,1,1,1,1,1]

],

[

[1,0,1,1,1,1,1,0,0,1,2,1,2,0,2,0,2,0,1,1],

[1,0,4,0,0,0,2,0,0,1,0,1,1,1,1,0,1,0,1,0],

[1,2,1,1,0,0,1,0,0,1,0,1,2,1,2,0,2,0,2,0],

[1,0,0,1,1,0,0,0,1,1,1,1,1,1,2,0,1,0,1,0],

[1,0,0,2,2,0,0,1,1,1,0,1,1,1,1,1,2,0,2,0],

[1,0,0,1,1,0,0,1,1,1,0,1,1,1,1,1,0,0,1,1],

[1,1,0,0,1,1,1,0,1,1,0,1,1,1,1,1,2,0,2,0],

[1,0,0,1,0,2,2,0,1,1,0,1,1,1,1,1,1,1,1,0],

[1,0,0,1,0,1,1,0,1,1,0,1,1,1,1,1,1,1,1,1],

[1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0],

[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0],

[1,0,0,0,0,0,0,0,0,2,1,1,0,0,0,0,0,0,0,0],

[1,1,0,1,1,0,1,1,0,1,0,1,1,1,2,0,1,1,0,0],

[1,1,0,1,1,1,0,0,1,1,0,1,1,1,1,1,1,1,1,1],

[1,1,0,1,1,1,0,0,1,1,0,1,1,1,2,0,1,1,1,1],

[1,1,0,1,1,0,0,0,0,1,0,1,1,1,2,0,0,1,1,1],

[1,1,1,0,0,1,0,0,0,1,0,1,1,1,2,0,1,1,1,1],

[1,1,1,0,0,1,1,0,0,1,0,1,1,4,4,4,2,0,1,1],

[1,1,0,0,0,0,1,0,0,1,0,1,0,0,0,0,0,0,0,1],

[1,0,0,0,0,0,0,0,0,1,0,2,0,0,0,0,0,0,0,0]

]



        ];



        

        

        private var scene:Scene3D;

        private var view:View;

        private var camera:Camera3D;

        

        // The camera controller

        private var controller:WalkController;

        

        public function Main()

        {

            stage.scaleMode = StageScaleMode.NO_SCALE;

            stage.align = StageAlign.TOP_LEFT;

            

            // Creating scene

            scene = new Scene3D();

            scene.root = new Object3D();

            

            // create box

                for (var r:int = 0; r < CELL_ARR.length; r++ )

                {

                    for (var c:int = 0; c < CELL_ARR[r].length; c++ )

                    {

                        var flg:uint; 

                        var box:Box;

                        

                        flg = CELL_ARR[r][c];

                        if (flg & CELL_FLOOR) 

                        {

                            box = Box(scene.root.addChild(new Box(CELL_WIDTH, CELL_WIDTH, FLOOR_HEIGHT)));

                            box.cloneMaterialToAllSurfaces(new DevMaterial(0,0x994422));

                            box.x = CELL_WIDTH * (c );

                            box.y = -CELL_WIDTH * (r - ROW_NUM + 1);

                            box.z =  - CELL_HEIGHT / 2;

                        }

                        



                        //north,east,south,west, each direction walls

                        for(var news:uint = 0; news < 4; news++)

                        {

                        

                        

                    

                            flg = WALL_ARR[news][r][c];

                            if (flg & WALL_WALL)

                            {

                                box = Box(scene.root.addChild(new Box(WALL_WIDTH, CELL_WIDTH, CELL_HEIGHT)));

                                box.cloneMaterialToAllSurfaces(new DevMaterial(0,0x999999));

                            }

                            else if(flg & WALL_DOOR || flg & WALL_HIDDEN_DOOR)

                            {

                                box = Box(scene.root.addChild(new Box(WALL_WIDTH, CELL_WIDTH, 400)));

                                box.cloneMaterialToAllSurfaces(new DevMaterial(0,0x990000));

                                box.z = CELL_HEIGHT / 2 - 200;

                            }

                            else

                            {

                                continue;

                            }

                            box.rotationZ = MathUtils.toRadian(NEWS_ROT[news]);

                            box.x = CELL_WIDTH * c + NEWS_X[news] * (CELL_WIDTH /2 - WALL_WIDTH / 2);

                            box.y = -(CELL_WIDTH * (r - ROW_NUM + 1) +  NEWS_Y[news] * (CELL_WIDTH /2 - WALL_WIDTH / 2));

                            



                        }

                    }

                }

/*

            var plane:Plane = Plane(scene.root.addChild(new Plane(CELL_WIDTH * COL_NUM, CELL_WIDTH * ROW_NUM)));

            plane.cloneMaterialToAllSurfaces(new FillMaterial(0x221100));

            

            plane.z = 5000;//CELL_HEIGHT / 2;

            plane.rotationX = 0 * Math.PI / 180;

*/

            

            // Adding camera and view

            camera = new Camera3D();

            camera.rotationX = MathUtils.toRadian(-90)

//            camera.rotationZ = MathUtils.toRadian(120)





            scene.root.addChild(camera);



            view = new View();

            addChild(view);

            view.camera = camera;

            

            // 徒歩のコントローラーを作成

            controller = new WalkController(stage);

            

            // キーボード操作を可能にする機能

            controller.setDefaultBindings();

            // キーボードショートカットの整理

            controller.bindKey(KeyboardUtils.UP, ObjectController.ACTION_FORWARD);

            controller.bindKey(KeyboardUtils.DOWN, ObjectController.ACTION_BACK);

            controller.bindKey(KeyboardUtils.LEFT, ObjectController.ACTION_LEFT);

            controller.bindKey(KeyboardUtils.RIGHT, ObjectController.ACTION_RIGHT);

            

            // WalkControllerの対象を設定

            controller.object = camera;

            // 障害物の衝突設定

            controller.checkCollisions = true;

            // 徒歩の速度

            controller.speed = 2000;

            // ジャンプ(スペースでジャンプできます)の速度

            controller.jumpSpeed = 3750;

            // 重力の速度

            controller.gravity = 1200;

            // 視点(制御点)の高さ

            controller.objectZPosition = 2;

            

            // FPS display launch

            FPS.init(stage);

            

            stage.addEventListener(Event.RESIZE, onResize);

            stage.addEventListener(Event.ENTER_FRAME, onEnterFrame);

            onResize(null);

        }

        

        private function onEnterFrame(e:Event):void

        {

            // interface

            controller.processInput();

            

            // Scene calculating

            scene.calculate();

        }

        

        /**

         * Resize Handler

         */

        private function onResize(e:Event):void

        {

            view.width = stage.stageWidth;

            view.height = stage.stageHeight;

            

            // BackGround Color

            var bgMatrix:Matrix = new Matrix();

            bgMatrix.rotate(90 * Math.PI / 180);

            graphics.clear()

            graphics.beginGradientFill("linear", [0xFFFFFF, 0x001122], [100, 100], [0, 255], bgMatrix);

            graphics.drawRect(0, 0, stage.stageWidth, stage.stageHeight);

        }

        

    }

}