/**
 * Copyright tepe ( http://wonderfl.net/user/tepe )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/gf8S
 */

package {
    import flash.display.Sprite;
    import flash.system.*;
    import flash.text.*;
    public class FlashTest extends Sprite {
        public function FlashTest() {
            var s:Sprite = new Sprite();
            
            addChild(s);
            s.tabChildren = false;//タブ入力に対応するためにtab移動を無効にする必要がある。            
            var editer:TextEditer = new TextEditer();
            editer.width = 400;
            editer.height = 400;
            editer.border = true;
            s.addChild(editer);
            //IME.conversionMode = "JAPANESE_HIRAGANA";
            //IME.conversionMode = "ALPHANUMERIC_FULL";
            //IME.conversionMode =　"KOREAN";
            //editer.text = IME.conversionMode;
            
            var newFormat:TextFormat = new TextFormat();
             //適用するフォーマットの設定
            //newFormat.size = 20;//フォントサイズ
            //newFormat.font = "Arial";//フォント変更
            newFormat.color = 0xff0000;//フォントカラー
            //newFormat.italic = true;//フォントタイプ
            //フォーマット適用範囲を指定
            //editer.text = "aaaabbccddaaaa";
            //editer.setTextFormat(newFormat, 1, 2);// テキストフォーマットの設定(フォント設定, 適用開始位置, 適用終了位置)

               
            
            
        }

    }
}



////////////////////////////////////////////////////////////////////////
//  TextEditer class
////////////////////////////////////////////////////////////////////////


    import flash.text.*;
    import flash.ui.*;
    import flash.events.*;
    import flash.net.*;
    import flash.system.*;
    class TextEditer extends TextField {
        private var file:FileReference;
        private var prevText:Object;
        private var nextText:Object;
        private var so:SharedObject;
        
        public function TextEditer():void {
            //System.useCodePage = true;//UNICODE以外のテキストファイルをロードする場合 true
            this.type = "input";//入力可能
            //this.tabEnabled = true;
            this.selectable = false;
            this.addEventListener(KeyboardEvent.KEY_DOWN, onKey); 
            addEventListener(MouseEvent.CLICK, onFocus);    
            addEventListener(MouseEvent.MOUSE_WHEEL,onWheel);
            
            //コンテキストメニュー@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@            
            var menu1:ContextMenuItem = new ContextMenuItem("ファイルを開く");
            menu1.addEventListener(ContextMenuEvent.MENU_ITEM_SELECT, function():void {
                //txt.appendText("menu");
                load();
            });
            var menu2:ContextMenuItem = new ContextMenuItem("ファイルを保存");
            menu2.addEventListener(ContextMenuEvent.MENU_ITEM_SELECT, function():void {
                save();
            });

            contextMenu = new ContextMenu();
            contextMenu.hideBuiltInItems();
            contextMenu.customItems = [menu1,menu2];
            //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
            loadSO();
  
        }
        
        private function onWheel(e:MouseEvent):void{
            e.stopPropagation();
        }
        
        
        //編集内容をバックアップ
        private function loadSO():void{
            var now:Date = new Date();
            try{
                so = SharedObject.getLocal("text");
                if(so.data.lastTime != null){//ロード
                    if(so.data.lastTime + 24*60*60*1000 > now.valueOf()){
                        this.text = so.data.text;
                    }
                    
                }
            }catch(e:Error){
                this.text = "loadSO : SharedObject Error";
            }
        }
        private function saveSO():void{
            var now:Date = new Date();
            try{
                var flushStatus:String = so.flush();
                if (flushStatus == SharedObjectFlushStatus.FLUSHED){
                    
                    so.data.text = this.text;
                    so.data.lastTime = now.valueOf();
                }
            }catch(e:Error){
                this.text = "saveSO : SharedObject Error";
            }
        }

        
        //改行コードの統一 (CR+LF or CR) → LF
        private function unifyLineFeedCode(str:String):String {
            var CR:String = String.fromCharCode(13);
            var LF:String = String.fromCharCode(10);
            str = str.split(CR+LF).join(LF);
            str = str.split(CR).join(LF);
            return str;
        }
        
        //セーブ
        public function save():void {
            var fileRef:FileReference = new FileReference();
            fileRef.save(this.text, this.name);
        }
        
        //ファイルロード
        public function load():void {//ファイル選択　①
            file = new FileReference();
            file.addEventListener(Event.COMPLETE, onLoaded);
            file.addEventListener(Event.SELECT, onSelect);
            file.browse();
        }
        private function onSelect(e:Event):void{//ロード開始　②
            file.load();
        }   
        private function onLoaded(e:Event):void {//ロード完了　③
            this.name = file.name;   
            var byte:int = file.data.length;
            var byte2:uint;
            
            //txt.text = String(file.data);
            this.text = unifyLineFeedCode(file.data.toString());//改行コード統一
            file.removeEventListener(Event.COMPLETE, onLoaded);
            file.removeEventListener(Event.SELECT, onSelect);      
        }

        
        //編集モード終了
        private function outFocus(e:FocusEvent):void {
            this.selectable = false;
            removeEventListener(FocusEvent.FOCUS_OUT, outFocus);
            removeEventListener(MouseEvent.MOUSE_DOWN, dragCansel);
            addEventListener(MouseEvent.MOUSE_DOWN, onFocus);
            //this.appendText(" Out ");
        }
        
        //編集モード開始
        private function onFocus(e:MouseEvent):void {
            this.selectable = true;
            addEventListener(FocusEvent.FOCUS_OUT, outFocus);
            removeEventListener(MouseEvent.MOUSE_DOWN, onFocus);
            addEventListener(MouseEvent.MOUSE_DOWN, dragCansel);
            //this.appendText(" In ");
            //e.stopPropagation();
        }
        
        private function dragCansel(e:MouseEvent):void {
            e.stopPropagation();
        }
        
        //キー入力
        private function onKey(e:KeyboardEvent):void {
            var sw:Boolean;
            var str1:String;
            var str2:String;
            
            
            //　エンターキーの状態
            if (e.keyCode == 13) sw = true;
            else if (e.keyCode == 108) sw = true;
            else sw = false;
            
            //キャレット位置に改行文字を挿入
            if(sw == true){
                
                saveSO();
                
                str1 = this.text.substring(0, this.caretIndex);
                str2 = this.text.substring(this.caretIndex, this.length);
                this.text = str1;
                this.appendText("\n");//キャレット位置で改行
                
                //インデント構造（タブ＆スペースの構成）を調べる
                var indent:int=0;
                var prevReturn:int = this.text.lastIndexOf('\r', this.caretIndex-1);//前回の改行位置
                //一つ前の改行直後に続くタブコードの数=インデント深度
                for (var j:int = prevReturn+1; j < this.caretIndex; j++) {
                    if (this.text.charAt(j) == '\t' || this.text.charAt(j) == ' ' ) indent++;
                    else break;
                }
                //上の行のインデントに従う
                var indentStr:String = this.text.slice(prevReturn + 1, prevReturn + 1 + indent);
                this.appendText(indentStr);//インデント
                this.text += str2;//結合
                
                //キャレット位置をインクリメント
                this.setSelection(this.caretIndex +indent + 1, this.caretIndex +indent + 1);
                return;
            }
            //tab
            if (e.keyCode == 9) {
                str1 = this.text.substring(0, this.caretIndex);
                str2 = this.text.substring(this.caretIndex, this.length);
                this.text = str1 + '\t' + str2;
                //キャレット位置をインクリメント
                this.setSelection(this.caretIndex + 1, this.caretIndex + 1);                
                return;
            }
            

        }

    }