/**
 * Copyright kotobuki ( http://wonderfl.net/user/kotobuki )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/geSC
 */

package {
  import flash.display.Sprite;
  import flash.events.Event;
  import flash.events.TimerEvent;
  import flash.text.TextField;
  import flash.utils.Timer;
  import flash.utils.getTimer;

  import funnel.*;
  import funnel.ui.*;

  [SWF(backgroundColor="0xCCCCCC")]

  public class DetectMovementByMotionSensor extends Sprite {
    // Arduino
    private var arduino:Arduino;

    // センサに接続したピン
    private var sensorPin:Pin;

    // LED
    private var led:LED;

    // 最後にアクティブだった時刻からの経過時間を表示するテキストフィールド
    private var textField:TextField;

    // タイムアウトを管理するためのタイマ
    private var timeoutTimer:Timer;

    // 最後にアクティブだった時刻
    private var lastActive:int = 0;

    // センサの状態を確認するためのシグナルスコープ
    private var signalScope:SignalScope;

    public function DetectMovementByMotionSensor() {
      // センサとLEDに接続したピンのモードをセット
      var config:Configuration = Arduino.FIRMATA;
      config.setDigitalPinMode(2, IN);
      config.setDigitalPinMode(13, OUT);
      arduino = new Arduino(config);

      // センサに接続したピンにイベントリスナをセット
      sensorPin = arduino.digitalPin(2);
      sensorPin.addEventListener(PinEvent.RISING_EDGE, 
                                 onActivate);
      sensorPin.addEventListener(PinEvent.FALLING_EDGE, 
                                 onDeactivate);

      // LEDのインスタンスを生成
      led = new LED(arduino.digitalPin(13));

      // センサの状態を表示するためのスコープを生成して追加
      signalScope = new SignalScope(10, 10, 200, 
                                    "Motion Sensor");
      addChild(signalScope);

      // 最後にアクティブだった時刻からの経過時間を表示するテキストフィールド
      textField = new TextField();
      textField.x = 15;
      textField.text = "Hello!";
      addChild(textField);

      // タイムアウトを管理するためのタイマを生成してイベントリスナをセット
      timeoutTimer = new Timer(15000, 1);
      timeoutTimer.addEventListener(TimerEvent.TIMER_COMPLETE, 
                                    onTimeout);

      // 毎フレームごとにシグナルスコープを更新するためのイベントリスナをセット
      addEventListener(Event.ENTER_FRAME, onEnterFrame);
    }

    // 毎フレームごとに以下を実行
    private function onEnterFrame(e:Event):void {
      // センサに接続したピンの状態を更新
      signalScope.update(sensorPin);

      // 最後にアクティブだった時刻からの経過時間を表示
      var elapsedTime:int = getTimer() - lastActive;
      textField.text = "Elapsed: " + elapsedTime + "ms";
    }

    // センサがアクティブ化したら
    private function onActivate(e:PinEvent):void {
      // LEDを点灯し
      led.on();

      // もしタイムアウト管理用のタイマが動作中であれば停止する
      if (timeoutTimer.running) {
        timeoutTimer.stop();
      }
    }

    // センサが非アクティブ化したら
    private function onDeactivate(e:PinEvent):void {
      // 最後にアクティブだった時刻として現在の時刻をセットし
      lastActive = getTimer();

      // タイムアウト管理用のタイマをリセットしてスタート
      timeoutTimer.reset();
      timeoutTimer.start();
    }

    // タイムアウトが発生したら
    private function onTimeout(e:TimerEvent):void {
      // LEDを消灯
      led.off();
    }
  }
}
