/**
 * Copyright Makiyivka ( http://wonderfl.net/user/Makiyivka )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/gdid
 */

/*******************************************************************************
 * PushButton Engine
 * Copyright (C) 2009 PushButton Labs, LLC
 * For more information see http://www.pushbuttonengine.com
 * 
 * This file is licensed under the terms of the MIT license, which is included
 * in the License.html file at the root directory of this SDK.
 ******************************************************************************/

package
{
    import com.pblabs.engine.PBE;
    import com.pblabs.engine.core.*;
    import com.pblabs.engine.entity.*;
    import com.pblabs.rendering2D.*;
    import com.pblabs.rendering2D.ui.*;
    
    import flash.display.Sprite;
    import flash.geom.Point;
    
    [SWF(width="460", height="460", frameRate="60")]
    public class Lesson4 extends Sprite
    {
        public function Lesson4()
        {
            // Start up PBE
            PBE.startup(this);
            
            // Set up a simple scene entity
            createScene();
            
            // Create a simple avatar entity
            createHero();
        }
        
        private function createScene():void 
        {
            var sceneView:SceneView = new SceneView();                        // Make the SceneView
            sceneView.width = 460;
            sceneView.height = 460;
            
            PBE.initializeScene(sceneView);                                   // This is just a helper function that will set up a basic scene for us
        }
        
        private function createHero():void
        {
            var hero:IEntity = allocateEntity();                              // Allocate an entity for our hero avatar
            
            var spatial:SimpleSpatialComponent = new SimpleSpatialComponent();// Create our spatial component
            
            spatial.position = new Point(0,0);                                // Set our hero's spatial position as 0,0
            spatial.size = new Point(50,50);                                  // Set our hero's size as 50,50
            spatial.spatialManager = PBE.spatialManager;

            hero.addComponent( spatial, "Spatial" );                          // Add our spatial component to the Hero entity with the name "Spatial"
            
            var render:SimpleShapeRenderer = new SimpleShapeRenderer();       // Create a renderer to display our object
            render.fillColor = 0x0000FF0;
            render.isCircle = true;
            render.radius = 25;
            render.lineSize = 2;
            render.lineColor = 0x000000;
            render.scene = PBE.scene;                                         // Set which scene this renderer belongs to
            
            // Point the render component to this entity's Spatial component for position information
            render.positionProperty = new PropertyReference("@Spatial.position");
            // Point the render component to this entity's Spatial component for rotation information
            render.rotationProperty = new PropertyReference("@Spatial.rotation");
            
            hero.addComponent( render, "Render" );                            // Add our render component to the Hero entity with the name "Render"
            
            
            // Create an instance of our hero controller component
            var controller:HeroControllerComponent = new HeroControllerComponent();
            // Point the controller component to this entity's Spatial component for position information
            controller.positionReference = new PropertyReference("@Spatial.position");
            
            // Add the demo controller component to the Hero entity with the name "Controller"
            hero.addComponent( controller, "Controller" );
            
            hero.initialize("Hero");                                          // Register the entity with PBE under the name "Hero"         
        }
    }
}

/*===========================================================================
HeroControllerComponent (keyboard input)
===========================================================================*/

import com.pblabs.engine.PBE;
import com.pblabs.engine.core.InputKey;
import com.pblabs.engine.components.TickedComponent;
import com.pblabs.engine.entity.PropertyReference;

import flash.geom.Point;

// Make a ticked component so that it can update itself every frame with onTick() 
class HeroControllerComponent extends TickedComponent
{
    // Keep a property reference to our entity's position.
    public var positionReference:PropertyReference;
    
    // onTick() is called every frame
    public override function onTick(tickRate:Number):void
    {
        //Get references for our spatial position
        var position:Point = owner.getProperty(positionReference);
        
        //If the Right Arrow key is down...
        if (PBE.isKeyDown(InputKey.RIGHT)) {
            //...then move our hero 15 pixels to the right.
            position.x += 15;
        }
        //If the Left Arrow key is down...
        if (PBE.isKeyDown(InputKey.LEFT)) {
            //...then move our hero 15 pixels to the left
            position.x -= 15;
        }
        
        //Add some boundary conditions
        if (position.x > 230) {
            //Set our position to the right wall edge
            position.x = 230
        }else if (position.x < -230) {
            //Set our position to the left wall edge
            position.x = -230
        }
        
        // Send our manipulated spatial variables back to the spatial manager
        owner.setProperty(positionReference, position);
    }
}

