/**
 * Copyright zob ( http://wonderfl.net/user/zob )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/gdfu
 */

package  {
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.events.KeyboardEvent;
    import flash.utils.*;
    import flash.ui.Keyboard;
    import flash.geom.ColorTransform;
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Loader;
    import flash.net.URLRequest;
    import flash.geom.Point;
    import flash.geom.Rectangle;
    import flash.system.LoaderContext;
    import com.bit101.components.PushButton;
    import flash.system.Capabilities;
    
    public class mouse_music extends Sprite {
        public static var GRAPHIC_URL:String ="http://assets.wonderfl.net/images/related_images/e/e3/e3a5/e3a50ba5410a56d24de979b5095568da9ea6b73f";
        private var loader:Loader;
        private var mouse_tracers:Array = new Array();
        private var soundBank:SoundBank = new SoundBank();
        private var buttonBank:ButtonBank;
        private var counter:int = 10;
        private var bmpd:BitmapData;
        private var cursor_bmpd:BitmapData;
        private var mouse_bmpd:BitmapData;
        private var current_mt:M;
        private var mouseDown:Boolean = false;
        private var ct:ColorTransform =  new ColorTransform(1,1,1,0.6);

        public function mouse_music() {
            soundBank.addEventListener("loadComplete", loadGraphic);
        }
        
        private function loadGraphic(e:Event = null):void
        {
            loader = new Loader();
            loader.contentLoaderInfo.addEventListener(Event.COMPLETE, init);
            loader.load(new URLRequest(GRAPHIC_URL), new LoaderContext(true));
        }
        
        private function init(e:Event = null):void
        {
            cursor_bmpd = Bitmap(loader.content).bitmapData;
            var os:String = flash.system.Capabilities.os.substr(0, 3);
            if (os == "Mac") {
              mouse_bmpd = new BitmapData(11, 17, true, 0x0);
                mouse_bmpd.copyPixels(cursor_bmpd, new Rectangle(13,0,11,17), new Point());
            } else {
                mouse_bmpd = new BitmapData(12, 21, true, 0x0);
                mouse_bmpd.copyPixels(cursor_bmpd, new Rectangle(0,0,12,21), new Point());
            }
            
            var panel:Sprite = new Sprite();
            bmpd = new BitmapData(stage.stageWidth, stage.stageHeight, true, 0x0);
            buttonBank = new ButtonBank(soundBank, stage.stageWidth, stage.stageHeight);
            mouse_tracers.push(new M(0, mouse_bmpd, buttonBank, mouseX, mouseY));
            current_mt = mouse_tracers[0];
            current_mt.x = -9999;
            addChild(buttonBank);
            addChild(panel);
            addChild(new Bitmap(bmpd));
            addChild(current_mt);
            new PushButton(panel, stage.stageWidth/2 - 40, stage.stageHeight - 21, "+ mouse", halt).setSize(80, 16);
            stage.addEventListener(Event.ENTER_FRAME, processing);
            stage.addEventListener(MouseEvent.MOUSE_DOWN, onmouseDown);
            stage.addEventListener(KeyboardEvent.KEY_DOWN, onkeyDown);
        }
        
        private function processing(e:Event):void
        {
            update();
            paint();
        }
        
        private function update():void
        {
            current_mt.record(mouseX, mouseY, mouseDown);
            var i:int = 0;
            
            for(i = 0; i < mouse_tracers.length-1; i++)
            {
                if(mouse_tracers[i].id != -1)
                {
                    
                    mouse_tracers[i].animate();
                }
            }
            mouseDown = false;
        }
        
        private function paint():void
        {
            /*
            bmpd.unlock();
            //bmpd.fillRect(bmpd.rect, 0x0);
            bmpd.colorTransform(bmpd.rect, ct);
            var i:int = 0;
            
            for(i = 0; i < mouse_tracers.length-1; i++)
            {
                if(mouse_tracers[i].current)
                {
                    
                    bmpd.copyPixels(mouse_bmpd, mouse_bmpd.rect, new Point(mouse_tracers[i].x, mouse_tracers[i].y));
                }
            }
            bmpd.lock();
            /**/
        }
        
        private function onmouseDown(e:MouseEvent):void
        {
            mouseDown = true;
            addChild(new Star(mouseX, mouseY, 0x0));
        }
        
        private function onkeyDown(e:KeyboardEvent):void
        {
            if(e.keyCode == Keyboard.SPACE)
            {
                if(current_mt.last_clicked)
                {
                    current_mt.halt();
                    mouse_tracers.push(new M(mouse_tracers.length, mouse_bmpd, buttonBank, mouseX, mouseY));
                    current_mt = mouse_tracers[mouse_tracers.length-1];
                    current_mt.x = -9999;
                    addChild(current_mt);
                }
            }
        }
        
        private function halt(...arg):void
        {
            if(current_mt.last_clicked)
            {
                current_mt.halt();
                mouse_tracers.push(new M(mouse_tracers.length, mouse_bmpd, buttonBank, mouseX, mouseY));
                current_mt = mouse_tracers[mouse_tracers.length-1];
                current_mt.x = -9999;
                addChild(current_mt);
            }
        }
    }
    
}
import flash.geom.Point;
import flash.display.Bitmap;
import flash.display.BitmapData;
import flash.text.TextField;
import flash.text.TextFormat;

class M extends MovieClip
{
    private var d:Array = new Array();
    public var current:Dot;
    public var last_clicked:int;
    private var buttonBank:ButtonBank;
    public var id:int = -1;
    private var count:int = 0;
    
    public function M(id:int, bd:BitmapData, b:ButtonBank, px:Number, py:Number)
    {
        addChild(new Bitmap(bd));
        var t:TextField = new TextField();
        t.text = "No. "+(id+1);
        var tf:TextFormat = new TextFormat();
        tf.font = "Arial";
        tf.size = 8;
        t.autoSize = "left";
        t.selectable = false;
        t.setTextFormat(tf);
        t.x = bd.width; t.y = bd.height;
        addChild(t);
        buttonBank = b;
        push(px, py);
    }
    
    public function record(px:Number, py:Number, clicked:Boolean = false):void
    {
        if(clicked)
        {
            current.c = clicked;
            last_clicked = d.length;
            push(px, py);
        }
        if(px == current.x && py == current.y)
        {
            current.t++;
        } else {
            push(px, py);
        }
    }
    
    private function push(px:Number, py:Number, pc:Boolean = false):void
    {
        d.push(new Dot(px, py, pc));
        current = d[d.length-1];
    }
    
    public function halt():void
    {
        d.splice(last_clicked, d.length - last_clicked);
        next();
        //addEventListener(Event.ENTER_FRAME, animate);
    }
    
    public function animate(e:Event = null):void
    {
        x = current.x;
        y = current.y;
        
        if(--count<=0)
        {
            if(current.c) buttonBank.mouseDown(x, y);
            next();
        }
    }
    
    private function next():void
    {
        if(++id==d.length) id = 0;
        current = d[id];
        count = current.t;
    }
}

class Dot
{
    public var x:Number = 0;
    public var y:Number = 0;
    public var t:int = 0;
    public var c:Boolean = false;
    
    public function Dot(px:Number = 0, py:Number = 0, pc:Boolean = false, pt:int = 0)
    {
        x = px; y = py; c = pc; t = pt;
    }
}

import flash.display.MovieClip;
import flash.utils.*;
import flash.events.Event;
import flash.events.MouseEvent;
import frocessing.color.ColorHSV;

class ButtonBank extends MovieClip
{
    public var buttons:Array = new Array();
    private var color:ColorHSV = new ColorHSV(0);
    private var bmpd:BitmapData;
    private var offsetX:Number = 120;
    private var offsetY:Number = 30;
    
    public function ButtonBank(s:SoundBank, w:Number, h:Number)
    {
        bmpd = new BitmapData(w,h,false,0xFFFFFF);
        addChild(new Bitmap(bmpd));
        for(var i:int = 0; i<s.sounds.length; i++)
        {
            color.h = i*36;
            buttons.push(new Button(s.sounds[i],i,color.value));
            buttons[i].x = offsetX + int(i%5)*50;
            buttons[i].y = offsetY + int(i/5)*50;
            addChild(buttons[i]);
        }
    }
    
    public function mouseDown(px:Number, py:Number):void
    {
        for(var i:int = 0; i<buttons.length; i++)
        {
            if(buttons[i].clicked(px, py))
            {
                star(px, py, buttons[i].color);
                return;
            }
        }
        star(px, py, 0x000000);
    }
    
    private function star(px:Number, py:Number, color:Number):void
    {
        addChild(new Star(px, py, color));
    }
}

class Button extends MovieClip
{
    private var id:int = 0;
    public var color:uint = 0x0;
    private var sound:Sound;
    
    public function Button(s:Sound, i:int, c:uint = 0x0)
    {
        sound = s;
        id = i;
        color = c;
        with(graphics)
        {
            lineStyle(0.1, 0xDDDDDD);
            beginFill(c);
            drawRect(0,0,30,30);
            endFill();
        }
        addEventListener(MouseEvent.MOUSE_DOWN, onmouseDown);
    }
    
    public function clicked(px:Number, py:Number):Boolean
    {
        if(hitTestPoint(px, py))
        {
            sound.play(0,1);
            return true;
        }
        return false;
    }
    
    private function onmouseDown(e:MouseEvent):void
    {
        sound.play(0,1);
    }
}

class Star extends MovieClip
{
    public function Star(px:Number, py:Number, color:uint)
    {
        x = px;
        y = py;
        with(graphics)
        {
            lineStyle(0.1, color);
            var rad:Number = Math.PI*2/5;
            var rand:Number = Math.random() * Math.PI*2;
            var j:int = 0;
            for(var i:int = 0; i < 5; i++)
            {
                j = (i+1)%5;
                moveTo(Math.cos(i*rad + rand)*10, Math.sin(i*rad + rand)*10);
                lineTo(Math.cos(i*rad+rad/2 + rand)*5, Math.sin(i*rad+rad/2 + rand)*5);
                lineTo(Math.cos(j*rad + rand)*10, Math.sin(j*rad + rand)*10);
            }
        }
        addEventListener(Event.ENTER_FRAME, processing);
    }
    
    private function processing(e:Event):void
    {
        alpha-=0.1; scaleX += 0.1; scaleY += 0.1; rotationZ += 6;
        if(alpha<=0) dead();
    }
    
    private function dead():void
    {
        removeEventListener(Event.ENTER_FRAME, processing);
        parent.removeChild(this);
    }
}


import flash.events.EventDispatcher;
import flash.media.Sound;
import flash.system.LoaderContext;
import flash.net.URLRequest;

class SoundBank extends EventDispatcher
{
    private var prefix:String = "http://assets.wonderfl.net/sounds/event/jam/";
    public var urls:Array = ["drop1.mp3","drop2.mp3","drop3.mp3","drop4.mp3","drop5.mp3","drop6.mp3","drop7.mp3","drop8.mp3","drop9.mp3","drop10.mp3"];
    public var sounds:Array = new Array();
    
    public function SoundBank()
    {
        loadIt();
    }
    
    private function loadIt():void
    {
        var s:Sound = new Sound();
        sounds.push(s);
        s.addEventListener(Event.COMPLETE, soundComplete);
        s.load(new URLRequest(prefix + urls[0]));
    }
    
    private function soundComplete(e:Event):void
    {
        urls.splice(0,1);
        if(urls.length>0)
        {
            loadIt();
        } else {dispatchEvent(new Event("loadComplete"))}
    }
    
    public function play(p:int):void
    {
        sounds[p].play(0,1);
    }
}