/**
 * Copyright romatica ( http://wonderfl.net/user/romatica )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/gdbi
 */

/**
 * AccessTimeCheckTest
 * 前回のアクセスから何分経過したか確認する。.
 *
 * 「サイトにアクセスしたときに、〇〇分以内なら、トップアニメーションスキップさせたい！」みたいな要望ってよくあるとおもうんです。
 * そんなときにサクっと使えるサンプルコードです。
 *
 * @author itoz ( http://www.romatica.com/ )
 */
package 
{
    import com.bit101.components.Label;
    import com.bit101.components.PushButton;

    import flash.display.GradientType;
    import flash.display.SpreadMethod;
    import flash.display.Sprite;
    import flash.display.StageAlign;
    import flash.display.StageScaleMode;
    import flash.events.MouseEvent;
    import flash.geom.Matrix;
    import flash.text.TextField;
    import flash.text.TextFieldAutoSize;
    
    public class AccessTimeCheckTest extends Sprite
    {
        private var _ID : String = "wonderfl.net/user/romatica";//任意のID
        private var _tf : TextField;
        private var _btn : PushButton;
        private var _title : Label;
        
        public function AccessTimeCheckTest()
        {
            setBG();
            stage.scaleMode=StageScaleMode.NO_SCALE;
            stage.align=StageAlign.TOP_LEFT;
            
            // -----------------------------------------------------------------
            _title =  new Label(this,0,0,"AccessTimeCheck");
            _title.transform.matrix = new Matrix(2,0,0,2,0,0);
            
            // -----------------------------------------------------------------
            _tf = addChild(new TextField( )) as TextField;
            _tf.autoSize=TextFieldAutoSize.LEFT;
            
            // -----------------------------------------------------------------
            var result:String;
            //前回からのアクセス時間を取得
            var elapseMinutes:Number = AccessTimeCheck.check(_ID);
            if(elapseMinutes==-1){
                result = "初めてのアクセスです";
            }else{
                result = "前回のアクセスから [ "+elapseMinutes+" ] 分経過しています";
            }
            _tf.text = result;
            
            // -----------------------------------------------------------------
            _btn = new PushButton(this,0,50,"",onClearShardObject)
            _btn.label="CLEAR";
            _btn.width = 100;
            
            // -----------------------------------------------------------------
            setPosition();
            
        }

    
        private function onClearShardObject(e:MouseEvent):void
        {
            AccessTimeCheck.clear(_ID);
            _tf.text ="アクセス時間記録をクリアしました。再読込して下さい";
            setPosition();
        }
        
        private function setBG() : void
        {
            var gradType:String = GradientType.LINEAR;
            var gradColors:Array = [  0xcccccc,0xffffff  ];
            var gradAlphas:Array = [ 1, 1 ];
            var gradRadios:Array = [ 100, 255 ];
            var gradMrx:Matrix = new Matrix( );
            gradMrx.createGradientBox( 465,  465 , Math.PI/2, 0,0);
            var gradSpread:String = SpreadMethod.PAD;
            var bg : Sprite = addChild( new Sprite() ) as Sprite;
             bg.graphics.beginGradientFill( gradType , gradColors ,  gradAlphas , gradRadios , gradMrx ,gradSpread);
             bg.graphics.drawRect( 0 , 0, 465, 465 );
        }
        
        private function setPosition():void{
            var scx:int = (stage.stageWidth/2);
            var scy:int = (stage.stageHeight/2);
            _title.x = scx -_title.width*_title.scaleX/2;
            _title.y =scy - 150;
            _tf.height = 15;
            _tf.x = scx-(_tf.width/2);
            _tf.y = scy-50;
            _btn.x = scx-(_btn.width/2);
            _btn.y = scy+50;
        }
    }
}
import flash.net.SharedObject;
    
class AccessTimeCheck
    {
        public function AccessTimeCheck():void{}
        
        // **********************************************************************
        /**
         * @param     id         ShardObjectを判別するID
         * @return    Number     前回アクセスから何分経過したか
         */
        public static function check(id:String):Number
        {
            var minutes : Number;
            var so:SharedObject = SharedObject.getLocal( id );
            if (so.data.savedValue == undefined) {
                minutes = -1;
            } else {
                var nowDate : Date = new Date();
                var nowTime : Number = nowDate.getTime();
                var preTime : Number = so.data["accessTime"];
                var diffTime : Number = (nowTime - preTime) / 1000 / 60;
                minutes = diffTime;
            }
            so.data.savedValue = id;
            var now : Date = new Date();
            so.data["accessTime"] = now.getTime();
            return minutes;
        }
        // **********************************************************************
        /**
         * @param     id         消去したいShardObjectを判別するID
         */
        public static function clear(id:String):void
        {
            var so:SharedObject  = SharedObject.getLocal( id );
            if (so.data.savedValue != undefined)
                 delete so.data.savedValue;
        }
}