/**
 * Copyright smallflowergame ( http://wonderfl.net/user/smallflowergame )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/gcnu
 */

// forked from cpu_t's 点の動き方
// 白はマウスの周りを回る
// 赤は白を追いかける
// 青は赤を追いかける
// 
// 赤も青も速度は一定
// 赤は目標との座標の差で速度を変える
// 青は目標への方向を見て、進行する角度を変える
// 
package {
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.filters.BlurFilter;
    import flash.geom.ColorTransform;
    import flash.geom.Point;
    public class FlashTest extends Sprite
    {
        private var bmpdata:BitmapData;
        private var lastMousePos:Object;
        private var filter:BlurFilter;
        private var colorTrans:ColorTransform;
        public function FlashTest()
        {
            bmpdata = new BitmapData(stage.stageWidth, stage.stageHeight, false, 0x000000);
            addChild(new Bitmap(bmpdata));
            lastMousePos = { x:0, y:0 };
            filter = new BlurFilter();
            colorTrans = new ColorTransform(.98, .98, .98);
            
            rPos = new Point(0, stage.stageHeight * .5);
            bPos = new Point(stage.stageWidth, stage.stageHeight * .5);
            
            addEventListener(Event.ENTER_FRAME, enterFrameHandler);
        }
        
        private var count:Number = 0;
        private var rPos:Point;
        private var rVec:Point = new Point();
        private var bPos:Point;
        private var bAngle:Number = Math.PI;
        private function enterFrameHandler(e:Event):void 
        {
            bmpdata.lock();
            bmpdata.applyFilter(bmpdata, bmpdata.rect, bmpdata.rect.topLeft, filter);
            bmpdata.colorTransform(bmpdata.rect, colorTrans);
            
            count++;
            var targetPos:Point = new Point(
                mouseX + 60 * Math.cos(count * 10 % 360 * Math.PI / 180),
                mouseY + 60 * Math.sin(count * 12 % 360 * Math.PI / 180)
            );
            
            var v:Point = targetPos.subtract(rPos);
            if (v.length > 10) v.normalize(10);
            rVec.x *= .9;
            rVec.y *= .9;
            rVec = rVec.add(v);
            rVec.normalize(30);
            drawLine(bmpdata, 3, 0xFF0000, rPos, rPos.add(rVec));
            rPos = rPos.add(rVec);
            
            v = rPos.subtract(bPos);
            var da:Number = (Math.atan2(v.y, v.x) - bAngle) % (Math.PI * 2);
            if (da < -Math.PI) da += Math.PI * 2;
            if (da > Math.PI) da -= Math.PI * 2;
            var maxangle:Number = 20 * Math.PI / 180;
            if (da != 0 && Math.abs(da) > maxangle) da = da / Math.abs(da) * maxangle;
            bAngle += da;
            v = bPos.clone();
            bPos.x += Math.cos(bAngle) * 40;
            bPos.y += Math.sin(bAngle) * 40;
            drawLine(bmpdata, 3, 0x0000FF, v, bPos);
            
            drawLine(bmpdata, 3, 0xFFFFFF, lastMousePos, targetPos );
            
            lastMousePos.x = targetPos.x;
            lastMousePos.y = targetPos.y;
            bmpdata.unlock();
        }
        
        private function drawLine(bitmapData:BitmapData, thickness:Number, color:uint, startPos:Object, endPos:Object):void
        {
            if (thickness == 0) return;
            var dx:Number, dy:Number;
            var x:Number = endPos.x - startPos.x;
            var y:Number = endPos.y - startPos.y;
            var m:Number = (y == 0 || Math.abs(x / y) >= 1) ? x : y;
            if (m == 0)
            {
                for (dy = -thickness * .5; dy <= thickness * .5; dy++)
                {
                    for (dx = -thickness * .5; dx <= thickness * .5; dx++)
                    {
                        bitmapData.setPixel(startPos.x + dx, startPos.y + dy, color);
                    }
                }
                return;
            }
            for (var i:Number = 0; i / m <= 1; i += (m == 0 ? 0 : (m / Math.abs(m))))
            {
                var tx:Number = startPos.x + x / m * i;
                var ty:Number = startPos.y + y / m * i;
                if (thickness == 1 || thickness < 0)
                {
                    bitmapData.setPixel(tx, ty, color);
                }
                else
                {
                    for (dy = -thickness * .5; dy <= thickness * .5; dy++)
                    {
                        for (dx = -thickness * .5; dx <= thickness * .5; dx++)
                        {
                            bitmapData.setPixel(tx + dx, ty + dy, color);
                        }
                    }
                }
            }
        }
    }
}