/**
 * Copyright sinketu ( http://wonderfl.net/user/sinketu )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/gcnK
 */

package 
{
    import caurina.transitions.*;
    import caurina.transitions.properties.*;
    import flash.display.*;
    import flash.events.*;
    import flash.text.*;
    import flash.utils.*;
    import net.hires.debug.*;
    
    /**
     * ...
     * @author michiro
     * 
     */
    [SWF(backgroundColor = "0x0", frameRate = "30", width = "465", height = "465")]
    public class Main extends Sprite 
    {
        private var myTextField:TextField;
        private var setString:String = "";
        private var arraytext/*String*/:Array = [];
        private var setStringArray/*:String*/:Array = ["こんにちは、いらっしゃい!","こんばんは、ようこそ!","もうなにもでないわよ","こんな時間に、何？","もうわたし眠いんだけど"];
        private var timerHolderA/*Timer*/:Array = [];
        private var timerHolderB/*Timer*/:Array = [];

        /**
         * コンストラクタ
         */
        public function Main()
        {
            if (stage) init();
            else addEventListener(Event.ADDED_TO_STAGE, init);
        }
        
        /**
         * @param    e
         */
        private function init(e:Event = null):void 
        {
            ColorShortcuts.init();
            DisplayShortcuts.init();
            
            stage.addEventListener(MouseEvent.CLICK, xClick);
            removeEventListener(Event.ADDED_TO_STAGE, init);
            //addChild(new Stats());
            myTextField = textPropertySet(400, 40,false,0xDDFFFF,false,false);
            textFormatProperty(myTextField, 40,0xDDFFFF,"Verdana",TextFormatAlign.LEFT,1);
            myTextField.x = 10;
            myTextField.y = 100;
            addChild(myTextField);
            
            setAnimation();
        }
        
        /**
         * アニメーション開始
         */
        private function setAnimation():void
        {
            arraytext = [];
            setString = setStringArray[Math.floor(Math.random() * setStringArray.length)];
            for (var i:uint = 0; i < setString.length; i++) {
                arraytext[i] = "";
            }
            //時間とともに動くモーションタイポ
            createAnimation();
            myTextField.x = Math.random() * 300-100;
            myTextField.y = Math.random() * 400;
            Tweener.removeAllTweens();
            Tweener.addTween(myTextField, { _scale:Math.random() * 2 + 0.5,_brightness:-2.55, time:0});
            Tweener.addTween(myTextField, {_brightness:0,time:2,transition:"linear"});
            Tweener.addTween(myTextField, {x:(myTextField.x)-100*myTextField.scaleX, time:5,transition:"linear"});
            Tweener.addTween(myTextField, {_brightness:-2.55, delay:3, time:2,transition:"linear",onComplete:resetAnimation});
        }
        
        /**
         * 
         * クリックしたら、全部中断して再開する
         *  
         * @param    e
         *
         * */
        private function xClick(e:MouseEvent):void 
        {
            resetAnimation();
        }
        
        /**
         * リセット
         * なんかメモリリークしてるっぽい
         */
        private function resetAnimation():void
        {
            //timerを全部とめる。
            for (var i:uint = 0; i < timerHolderA.length; i++ ) {
                timerHolderA[i].stop();
                timerHolderA[i].removeEventListener(TimerEvent.TIMER, xTimer);
                timerHolderA[i] = null;
            }
            timerHolderA = [];
            
            for (i = 0; i < timerHolderB.length; i++ ) {
                timerHolderB[i].stop();
                timerHolderB[i].removeEventListener(TimerEvent.TIMER, xRand);
                timerHolderB[i].removeEventListener(TimerEvent.TIMER_COMPLETE,xFinish);
                timerHolderB[i] = null;
            }
            timerHolderB = [];
            setAnimation();
        }
        
        /**
         * 各文字ごとに 40+i*2 の時間差を発生させて、後ろの文字ほど遅らせてスタート。
         */
        private function createAnimation():void
        {
            for (var i:uint = 0; i < setString.length ;i++ ){
                var myTimer:Timer = new Timer((40+i*2)*i,1);
                myTimer.addEventListener(TimerEvent.TIMER, xTimer(i));
                myTimer.start();
                timerHolderA.push(myTimer);
            }
        }
        
        /**
         * 各文字ごとの文字の変更繰り返し
         * 
         * @param    num
         * @return
         */
        private function xTimer(num:Number):Function
        {
            return function(e:TimerEvent):void 
            {
                var myTimer:Timer = new Timer(30, 20);
                myTimer.addEventListener(TimerEvent.TIMER, xRand(num));
                myTimer.addEventListener(TimerEvent.TIMER_COMPLETE,xFinish(num));
                myTimer.start();
                timerHolderB.push(myTimer);
            }
        }
        
        /**
         * xTimerの終了時に正しい文字をあてる。
         * 
         * @param    num
         * @return
         */
        private function xFinish(num:Number):Function
        {
            return function(e:TimerEvent):void 
            {
                trace(num);
                arraytext[num] = setString.charAt(num);
                setText();
                trace(arraytext);
            }
        }
        
        /**
         * 適当な文字を発生させる。
         * 
         * @param    num
         * @return
         */
        private function xRand(num:Number):Function
        {
            return function(e:TimerEvent):void 
            {
                var rand:uint = Math.floor(Math.random() * 94+33);
                var char:String = String.fromCharCode(rand);
                arraytext[num] = char;
                setText();
                trace(num,arraytext);
            }
        }
        
        /**
         * 作った文字を、指定の場所に割り当てる。
         */
        private function setText():void
        {
            myTextField.text = "";
            for (var i:uint = 0; i < arraytext.length; i++ ) {
                myTextField.appendText(arraytext[i]);
            }
        }
        
        /**
         * クラス化するほどでもないメソッド１
         * 
         * @param    w
         * @param    h
         * @param    txttype
         * @param    txtColr
         * @param    b
         * @param    thick
         * @param    sharp
         * @param    auto
         * @param    multi
         * @param    wrap
         * @param    embed
         * @return
         */
        private function textPropertySet(w:Number = 200, h:Number = 40, select:Boolean = false , txtColr:uint = 0x0, multi:Boolean = true, wrap:Boolean = true, auto:String = TextFieldAutoSize.LEFT, txttype:String = TextFieldType.DYNAMIC, b:Boolean = false, thick:Number = 1, sharp:Number = 1, embed:Boolean = false ):TextField {
            var txt:TextField=new TextField;
            txt.width = w;
            txt.height = h;
            txt.selectable = select;
            txt.type= txttype;
            txt.textColor = txtColr;
            txt.thickness = thick;//（埋め込みフォント時のみ動作）
            txt.sharpness = sharp;//（埋め込みフォント時のみ動作）
            txt.border = b;
            txt.autoSize = auto;
            txt.multiline = multi;
            txt.wordWrap = wrap;
            txt.embedFonts = embed;//（埋め込みフォント時のみ動作）
            return txt;
            
        }
        
        /**
         * クラス化するほどでもないメソッド２
         * 
         * @param    txt
         * @param    size
         * @param    color
         * @param    font
         * @param    format
         * @param    space
         * @param    lead
         * @param    bold
         * @param    kerning
         */
        private function textFormatProperty(txt:TextField, size:Number = 10,color:uint = 0x0,  font:String = "Verdana", format:String = TextFormatAlign.LEFT, space:Number = 0, lead:Number = 0, bold:Boolean = false, kerning:Boolean = false ):void
        {
            var myTextFormat:TextFormat = new TextFormat();
            myTextFormat.size = size;
            myTextFormat.font = font;
            myTextFormat.align = format; // 整列
            myTextFormat.color = color;// 文字の色
            myTextFormat.letterSpacing = space;// 文字間スペースの量(単位:ピクセル)
            myTextFormat.leading = lead;// 行間の垂直の行送り
            myTextFormat.bold = bold;// 太字にするか？
            myTextFormat.kerning = kerning;// カーニングが有効か？（埋め込みフォント時のみ動作）
            
            txt.defaultTextFormat = myTextFormat; 
        }
    }
}