/**
 * Copyright kihon ( http://wonderfl.net/user/kihon )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/gcff
 */

package
{
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import Box2D.Dynamics.b2World;
	import Box2D.Dynamics.b2DebugDraw;
	import Box2D.Collision.b2AABB;
	import Box2D.Common.Math.b2Vec2;
	import Box2D.Dynamics.b2Body;
 
	[SWF(backgroundColor="0x414647")]
	public class Main extends Sprite
	{
		private var world:b2World;
		private var scale:Number = 10;
		private var wall:Array = [];
		private var blocks:/*b2Body*/Array = [];
 
		public function Main()
		{
			var worldAABB:b2AABB = new b2AABB();
			worldAABB.lowerBound.Set(-100, -100);
			worldAABB.upperBound.Set(stage.stageWidth + 100, stage.stageHeight + 100);
 
			var gravity:b2Vec2 = new b2Vec2(0, -5);
			world = new b2World(worldAABB, gravity, true);
 
			var draw:b2DebugDraw = new b2DebugDraw();
			draw.m_sprite = this;
			draw.m_drawScale = scale;
			draw.m_drawFlags = b2DebugDraw.e_shapeBit;
			world.SetDebugDraw(draw);
 
			Shape.world = world;
			Shape.scale = scale;
			wall[0] = Shape.create( { shape:Shape.RECT, x:0, y:0, width:232, height:300 } );
			wall[1] = Shape.create( { shape:Shape.RECT, x:233, y:0, width:232, height:300 } );
 
			for (var y:int = 0; y < 3; y++)
			{
				for (var x:int = 0; x < 10; x++)
				{
					blocks.push(Shape.create( { shape:Shape.RECT, x:50 * x, y:50 * y + 300, width:50, height:50, density:10, restitution:Math.random() * 0.9 + 0.1} ));
				}
			}
 
			addEventListener(Event.ENTER_FRAME, onEnterFrame);
		}
		private function onEnterFrame(event:Event):void 
		{
			Shape.addVec2(wall[0], -1, 0);
			Shape.addVec2(wall[1],  1, 0);
 
			for (var i:int = 0; i < blocks.length; i++)
			{
				var body:b2Body = blocks[i];
				if (body.GetPosition().y <= -50 / scale)
				{
					world.DestroyBody(body);
					blocks.splice(i--, 1);
				}
			}
 
			world.Step(1 / stage.frameRate, 10);
		}
	}
}
 
import Box2D.Collision.Shapes.b2CircleDef;
import Box2D.Collision.Shapes.b2PolygonDef;
import Box2D.Collision.Shapes.b2ShapeDef;
import Box2D.Common.Math.b2Vec2;
import Box2D.Dynamics.b2Body;
import Box2D.Dynamics.b2BodyDef;
import Box2D.Dynamics.b2World;
 
class Shape
{
	public static const CIRCLE:int = 0;
	public static const RECT:int = 1;
 
	public static var world:b2World;
	public static var scale:Number;
 
	public static function addVec2(body:b2Body, x:Number, y:Number):void
	{
		body.SetXForm(new b2Vec2(body.GetPosition().x + x / scale, body.GetPosition().y + y / scale), body.GetAngle());
	}
 
	public static function setVec2(body:b2Body, x:Number, y:Number):void
	{
		body.SetXForm(new b2Vec2(x / scale, y / scale), body.GetAngle());
	}
 
	public static function addAngle(body:b2Body, rotate:Number):void
	{
		body.SetXForm(body.GetPosition(), body.GetAngle() + rotate * Math.PI / 180);
	}
 
	public static function setAngle(body:b2Body, rotate:Number):void
	{
		body.SetXForm(body.GetPosition(), rotate * Math.PI / 180);
	}
 
	public static function create(params:Object):b2Body
	{
		var def:b2BodyDef = new b2BodyDef();
		if (params.angle) def.angle = params.angle * Math.PI / 180;
 
		var shape:b2ShapeDef;
		if (params.shape == Shape.RECT)
		{
			def.position.Set((params.x + params.width / 2) / scale, (params.y + params.height / 2) / scale);
			shape = new b2PolygonDef();
			b2PolygonDef(shape).SetAsBox(params.width / 2 / scale, params.height / 2 / scale);
		}
		else if (params.shape == Shape.CIRCLE)
		{
			def.position.Set(params.x / scale, params.y / scale);
			shape = new b2CircleDef();
			b2CircleDef(shape).radius = params.radius / scale;
		}
 
		shape.density = params.density;
		shape.restitution = params.restitution;
 
		var body:b2Body = world.CreateBody(def);
		body.CreateShape(shape);
 
		if (shape.density > 0) body.SetMassFromShapes();
 
		return body;
	}
}
