/**
 * Copyright osamX ( http://wonderfl.net/user/osamX )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/gcW4
 */

// forked from clockmaker's [Progression4] LoaderList, SerialList, ParallelList
/**
 * Progression4を利用した外部画像読み込み
 * LoaderList, SerialList, ParallelListの比較
 * 
 * SerialListは直列で、コマンド単位でのみ進捗を表示可能
 * LoaderListは直列で、画像読み込みに応じた進捗を表示可能
 * ParallelListは並列のため読み込みは高速、ただし進捗表示は不可
 */
package {
	import flash.display.Loader;
    import flash.events.*;
    import flash.net.*;
    import flash.system.Security;
    import flash.utils.*;
    import jp.progression.casts.*;
    import com.bit101.components.*
    import jp.progression.commands.lists.*;
    import jp.progression.commands.net.*;
    
    public class Main extends CastDocument {
        
        private var progress:ProgressBar;
        private var label:Label;
        
        override protected function atReady():void  {
            Security.loadPolicyFile("http://farm3.static.flickr.com/crossdomain.xml");
            Security.loadPolicyFile("http://farm4.static.flickr.com/crossdomain.xml");
            new PushButton(this, 10, 10, "SerialList", startSerialList);
            new PushButton(this, 120, 10, "LoaderList", startLoaderList);
            new PushButton(this, 230, 10, "ParanelList", startParallesList);
			new PushButton(this, 340, 10, "Loader", startLoader);
            progress = new ProgressBar(this, 10, 50);
            label = new Label(this, 10, 70);
        }
        
        private function startSerialList(e:Event = null):void {
            var list:SerialList = new SerialList();
            for (var i:int = 0; i < IMG_FILES.length; i++) {
                list.addCommand( new LoadBitmapData(new URLRequest(IMG_FILES[i] + "?" + Math.random() * 10000), {cacheAsResource:false}));
            }
            list.onPosition = function():void {
                progress.value = list.position / list.numCommands;
                label.text = list.position + "/" +  list.numCommands + " with SerialList";
            }
            var oldTimer:int = getTimer();
            list.onComplete = function():void {
                label.text = "Load Time : " + Math.round(getTimer() - oldTimer) / 1000 + "sec with SerialList";
            }
            list.execute();
        }
        
        private function startLoaderList(e:Event = null):void{
            var list:LoaderList = new LoaderList();
            for (var i:int = 0; i < IMG_FILES.length; i++) {
                list.addCommand( new LoadBitmapData(new URLRequest(IMG_FILES[i] + "?" + Math.random() * 10000), {cacheAsResource:false}));
            }
            list.onProgress = function():void {
                progress.value = list.percent / 100;
                label.text = Math.round(list.percent) + "% with LoaderList";
            }
            var oldTimer:int = getTimer();
            list.onComplete = function():void {
                label.text = "Load Time : " + Math.round(getTimer() - oldTimer) / 1000 + "sec with LoaderList";
            }
            list.execute();
        }
        
        private function startParallesList(e:Event = null):void {
            
            var list:ParallelList = new ParallelList();
            for (var i:int = 0; i < IMG_FILES.length; i++) {
                list.addCommand( new LoadBitmapData(new URLRequest(IMG_FILES[i] + "?" + Math.random() * 10000), {cacheAsResource:false}));
            }
            label.text = "NOW LOADING with ParallelList";
            var oldTimer:int = getTimer();
            list.onComplete = function():void {
                label.text = "Load Time : " + Math.round(getTimer() - oldTimer) / 1000 + "sec with ParallelList";
            }
            list.execute();
        }
		
		private function startLoader(e:Event = null):void {
			var loaded:uint = 0;
			var oldTimer:int;
			addEventListener(Event.ENTER_FRAME, function(e:Event):void {
				progress.value = loaded / IMG_FILES.length;
				label.text = loaded + "/" +  IMG_FILES.length + " with Loader";
				if (loaded < IMG_FILES.length) return;
				label.text = "Load Time : " + Math.round(getTimer() - oldTimer) / 1000 + "sec with Loader";
				removeEventListener(Event.ENTER_FRAME, arguments.callee);
			});
			oldTimer = getTimer();
			for (var i:int = 0; i < IMG_FILES.length; i++) {
                var loader:Loader = new Loader();
				loader.contentLoaderInfo.addEventListener(Event.COMPLETE, function(e:Event):void { loaded++; } );
				loader.load(new URLRequest(IMG_FILES[i] + "?" + Math.random() * 10000));
            }
        }
        
        private static const IMG_FILES:Array = [
            "http://farm3.static.flickr.com/2544/3999799072_29522c4ded_m.jpg",
            "http://farm3.static.flickr.com/2544/3999799072_29522c4ded_m.jpg",
            "http://farm4.static.flickr.com/3449/3934552946_ed75627ca0_m.jpg",
            "http://farm3.static.flickr.com/2613/3933770677_78c6ed5c99_m.jpg",
            "http://farm4.static.flickr.com/3517/3895722585_4d93197e9c_m.jpg",
            "http://farm4.static.flickr.com/3453/3895722481_45e3876949_m.jpg",
            "http://farm3.static.flickr.com/2429/3895722271_c7c84aabaa_m.jpg",
            "http://farm4.static.flickr.com/3166/3895722107_f2844287a9_m.jpg",
            "http://farm3.static.flickr.com/2597/3896502906_05c3fb0cf4_m.jpg",
            "http://farm3.static.flickr.com/2576/3896502792_302d7f69bb_m.jpg",
            "http://farm3.static.flickr.com/2599/3896502698_3665363fbc_m.jpg",
            "http://farm3.static.flickr.com/2675/3896502600_1d6a0b5560_m.jpg",
            "http://farm3.static.flickr.com/2621/3895721313_d3fa43ef1b_m.jpg",
            "http://farm3.static.flickr.com/2675/3896502600_1d6a0b5560_m.jpg",
            "http://farm3.static.flickr.com/2621/3895721313_d3fa43ef1b_m.jpg",
            "http://farm4.static.flickr.com/3504/3895721203_763407faae_m.jpg",
            "http://farm4.static.flickr.com/3212/2968492121_f4a04bd9e2_m.jpg",
            "http://farm4.static.flickr.com/3212/2968492121_f4a04bd9e2_m.jpg",
            "http://farm4.static.flickr.com/3169/2968491791_b025518408_m.jpg",
            "http://farm4.static.flickr.com/3018/2969334992_b90e941833_m.jpg",
            "http://farm4.static.flickr.com/3168/2969334782_affd51601e_m.jpg",
            "http://farm4.static.flickr.com/3284/2968491271_625ed0912b_m.jpg",
            ];
    }
}