/**
 * Copyright TmskSt ( http://wonderfl.net/user/TmskSt )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/gbed
 */

package {
    import flash.automation.KeyboardAutomationAction;
    import flash.display.*;
    import flash.events.*;
    import flash.filters.*;
    import flash.geom.*;
    import flash.net.*;
    import flash.system.*;
    import flash.ui.Keyboard;
    import org.libspark.betweenas3.*;
    import org.libspark.betweenas3.easing.*;
    import org.libspark.betweenas3.events.*;
    import org.libspark.betweenas3.tweens.*;
    
    // [SR : AS50]
    // HOLD -> SHIFT KEY
    
    public class Main extends Sprite {
        
        private var base:Sprite = new Sprite;
        private var dot:Shape = new Shape;
        private var edge:Shape = new Shape;
        private var fo:Sprite = new Sprite;
        private var msk:Shape = new Shape;
        private var retDot:Shape = new Shape;
        private var sight:Shape = new Shape;
        
        private var rotate:Number = 0;
        private var pt:Point = new Point;
        private var loader:Loader = new Loader;
        private var degree:Number = 0;
        
        private var recoil:ITween = BetweenAS3.tween(null, {});
        
        private static const RECOIL_RANGE_MIN_RADIUS_WIDTH:int = 10;
        private static const RECOIL_RANGE_MIN_RADIUS_HEIGHT:int = 50;
        private static const RECOIL_RANGE_RADIUS_WIDTH:int = 10;
        private static const RECOIL_RANGE_RADIUS_HEIGHT:int = 50;
        
        private static const RECOIL_THRESHOLD_X:Number = .5;
        private static const RECOIL_THRESHOLD_Y:Number = 1;
        
        private static const RECOIL_CURVE_THRESHOLD_X:int = .5;
        private static const RECOIL_CURVE_THRESHOLD_Y:int = .5;
        private static const RECOIL_CURVE_RANGE:int = 25;
        
        public function Main():void {
            this.addEventListener(Event.ADDED, init);
        }
        
        private function init(e:Event = null):void {
            this.removeEventListener(Event.ADDED, init);
            
            loader.load(new URLRequest("http://assets.wonderfl.net/images/related_images/3/35/35c2/35c2ea9f0b44ebde51b055163e3da4836e51d22c"), new LoaderContext(true));
            loader.contentLoaderInfo.addEventListener(Event.COMPLETE, loaded);
        }
        
        private function loaded(e:Event):void {
            this.addChild(loader.content);
            
            fo.graphics.beginFill(0);
            fo.graphics.drawRect(0, 0, 465, 465);
            fo.graphics.endFill();
            
            fo.blendMode = BlendMode.LAYER;
            this.addChild(fo);
            
            base.x = base.y = 465 / 2;
            fo.addChild(base);
            
            msk.graphics.beginFill(1);
            msk.graphics.drawCircle(0, 0, 100);
            msk.graphics.endFill();
            msk.blendMode = BlendMode.ERASE;
            base.addChild(msk);
            
            dot.graphics.lineStyle(3, 0x0);
            
            dot.graphics.moveTo(0, -100);
            dot.graphics.lineTo(0, -20);
            
            dot.graphics.lineStyle(2, 0x0);
            dot.graphics.moveTo(20, 0);
            dot.graphics.lineTo(100, 0);
            
            dot.graphics.moveTo(-100, 0);
            dot.graphics.lineTo(-20, 0);
            
            dot.graphics.lineStyle(1, 0x0);
            dot.graphics.moveTo(-20, 0);
            dot.graphics.lineTo(20, 0);
            
            dot.graphics.moveTo(0, -20);
            dot.graphics.lineTo(0, 100);
            
            const s:int = 3;
            for (var i:int = 0; i < 35; i++) {
                var k:int = (i % 5) ? 2 : 3;
                dot.graphics.moveTo( -k, i * s);
                dot.graphics.lineTo(k, i * s);
                
                if (i<7){
                    dot.graphics.moveTo( -k, i * -s);
                    dot.graphics.lineTo(k, i * -s);
                    
                    dot.graphics.moveTo(i * -s, -k);
                    dot.graphics.lineTo(i * -s, k);
                    dot.graphics.moveTo(i * s, -k);
                    dot.graphics.lineTo(i * s, k);
                }
            }
            
            dot.graphics.moveTo(-35, 51);
            dot.graphics.lineTo(25, 51);
            
            dot.graphics.moveTo(-30+1-5, 36);
            dot.graphics.lineTo(-20-1-5, 36);
            
            dot.graphics.moveTo(-20+1-5, 41);
            dot.graphics.lineTo(-10-1-5, 41);
            
            dot.graphics.moveTo(-10+1-5, 45);
            dot.graphics.lineTo(0-1-5, 45);
            
            dot.graphics.moveTo(0+1+5, 47);
            dot.graphics.lineTo(10-1+5, 47);
            dot.graphics.moveTo(10+1+5, 48);
            dot.graphics.lineTo(20-1+5, 48);
            
            base.addChild(msk);
            base.addChild(dot);
            base.addChild(edge);
            
            edge.graphics.lineStyle(3);
            edge.graphics.drawCircle(0, 0, 100);
            edge.filters = [new BlurFilter(9, 9)];
            
            //retDot.graphics.beginFill(0xFF0000);
            //retDot.graphics.drawCircle(0, 0, 1);
            //retDot.graphics.endFill();
            //retDot.visible = false;
            this.addChild(retDot);
            
            //sight.graphics.beginFill(0xFF00FF);
            //sight.graphics.drawCircle(0, 0, 3);
            //sight.graphics.endFill();
            this.addChild(sight);
            
            stage.addEventListener(MouseEvent.CLICK, fire);
            this.addEventListener(Event.ENTER_FRAME, enterFrame);
            
            stage.addEventListener(KeyboardEvent.KEY_DOWN, onKeyDown);
            stage.addEventListener(KeyboardEvent.KEY_UP, onKeyUp);
        }
        
        private function onKeyDown(e:KeyboardEvent):void {
            if (e.keyCode == Keyboard.SHIFT) hold = true;
        }
        
        private function onKeyUp(e:KeyboardEvent):void {
            if (e.keyCode == Keyboard.SHIFT) hmW = HM_WD, hmH = HM_HD, hold = false;
        }
        
        private var hold:Boolean = false;
        private const FRM:int = 30;
        private const HM_WD:int = 100;
        private const HM_HD:int = 30;
        
        private const HM_WH:int = 10;
        private const HM_HH:int = 5;
        
        private var hmW:Number = HM_WD;
        private var hmH:Number = HM_HD;
        
        private function enterFrame(e:Event):void {
            
            if (hold) {
                if(hmW > HM_WH) {
                    hmW -= (hmW - HM_WH)/FRM;
                }
                if (hmH > HM_HH){
                    hmH -= (hmH - HM_HH)/FRM;
                }
            }
            
            pt.x += (mouseX - base.x) / 10;
            pt.y += (mouseY - base.y) / 10;
            
            var radian:Number = Math.PI / 180 * this.degree;
            sight.x = pt.x + hmW * Math.cos(radian);
            sight.y = pt.y + hmH * Math.sin(radian + radian);
            this.degree += 2;
            
            base.x = sight.x;
            base.y = sight.y;
        }
        
        private function fire(e:MouseEvent):void {
            
            stage.removeEventListener(MouseEvent.CLICK, fire);
            this.removeEventListener(Event.ENTER_FRAME, enterFrame);
            recoil.stop();
            
            const DX:int = Math.random() > RECOIL_THRESHOLD_X ? 1 : -1;
            const RW:Number = Math.random() * RECOIL_RANGE_RADIUS_WIDTH + RECOIL_RANGE_MIN_RADIUS_WIDTH;
            const CPX:Number = Math.random() * RECOIL_CURVE_RANGE * (Math.random() > RECOIL_CURVE_THRESHOLD_X ? 1 : -1);
            
            const DY:int = (Math.random() > RECOIL_THRESHOLD_Y) ? 1 : -1;
            const RH:Number = Math.random() * RECOIL_RANGE_RADIUS_HEIGHT + RECOIL_RANGE_MIN_RADIUS_HEIGHT;
            const CPY:Number = Math.random() * RECOIL_CURVE_RANGE * (Math.random() > RECOIL_CURVE_THRESHOLD_Y ? 1 : -1);
            
            var p:Point = new Point(RW * DX, RH * DY);
            var c:Point = new Point(((p.x + base.x) / 2 + base.x / 2) + CPX, ((p.y + base.y) / 2 + base.y / 2) + CPY);
            
            retDot.x = c.x, retDot.y = c.y;
            
            var t:ITween = BetweenAS3.bezierTo(base, {$x: p.x, $y: p.y}, {$x: c.x, $y: c.y}, .1);
            var r:ITween = BetweenAS3.to(base, {$x: p.x * -1, $y: p.y * -1}, .35, Back.easeOut);
            
            recoil = BetweenAS3.serial(t, r);
            recoil.addEventListener(TweenEvent.COMPLETE, recoilComplete);
            recoil.stopOnComplete = false;
            recoil.play();
        }
        
        private function recoilComplete(e:TweenEvent):void {
            recoil.stop();
            
            stage.addEventListener(MouseEvent.CLICK, fire);
            this.addEventListener(Event.ENTER_FRAME, enterFrame);
        }
    }
}