/**
 * Copyright saharan ( http://wonderfl.net/user/saharan )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/gbdg
 */

// forked from ProjectNya's チョーク (4)
////////////////////////////////////////////////////////////////////////////////
// チョーク (4)
////////////////////////////////////////////////////////////////////////////////

package {
    import flash.geom.ColorTransform;
    import flash.geom.Matrix;
    import flash.geom.Rectangle;

    import flash.display.Sprite;
    import flash.display.StageScaleMode;
    import flash.display.StageAlign;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.display.BitmapData;
    import flash.display.Bitmap;
    import flash.geom.Point;
    import flash.display.BlendMode;

    [SWF(backgroundColor="#005500", width="465", height="465", frameRate="60")]

    public class Main extends Sprite {
        private var bitmap:Bitmap;
        private var bitmapData:BitmapData;
        private var canvas:Sprite;
        private var seed:uint;
        private var px:Number = 0;
        private var py:Number = 0;
        private var clearBtn:Btn;
        private var whiteBtn:Btn;
        private var pinkBtn:Btn;
        private var greenBtn:Btn;
        private var blueBtn:Btn;
        private var fill:BitmapData;
        private var color:ColorTransform;

        public function Main() {
            //Wonderfl.capture_delay(1);
            init();
        }

        private function init():void {
            graphics.beginFill(0x005500);
            graphics.drawRect(0, 0, 465, 435);
            graphics.endFill();
            graphics.beginFill(0x996633);
            graphics.drawRect(0, 435, 465, 30);
            graphics.endFill();
            color = new ColorTransform(1, 1, 1, 1);
            //
            clearBtn = new Btn();
            addChild(clearBtn);
            clearBtn.x = 420;
            clearBtn.y = 450;
            clearBtn.init({label: "clear"});
            clearBtn.addEventListener(MouseEvent.CLICK, clear, false, 0, true);
            //
            whiteBtn = new Btn();
            addChild(whiteBtn);
            whiteBtn.x = 40;
            whiteBtn.y = 450;
            whiteBtn.init({label: "white"});
            whiteBtn.addEventListener(MouseEvent.CLICK, white, false, 0, true);
            //
            pinkBtn = new Btn();
            addChild(pinkBtn);
            pinkBtn.x = 120;
            pinkBtn.y = 450;
            pinkBtn.init({label: "pink"});
            pinkBtn.addEventListener(MouseEvent.CLICK, pink, false, 0, true);
            //
            greenBtn = new Btn();
            addChild(greenBtn);
            greenBtn.x = 200;
            greenBtn.y = 450;
            greenBtn.init({label: "green"});
            greenBtn.addEventListener(MouseEvent.CLICK, green, false, 0, true);
            //
            blueBtn = new Btn();
            addChild(blueBtn);
            blueBtn.x = 280;
            blueBtn.y = 450;
            blueBtn.init({label: "blue"});
            blueBtn.addEventListener(MouseEvent.CLICK, blue, false, 0, true);
            //
            bitmapData = new BitmapData(465, 435, true, 0x00000000);
            bitmap = new Bitmap(bitmapData);
            addChild(bitmap);
            bitmap.blendMode = BlendMode.ADD;
            canvas = new Sprite();
            seed = uint(Math.random()*10000);
            fill = new BitmapData(465, 435);
            fill.perlinNoise(3, 3, 1, seed, false, true, 8, true);
            //
            stage.addEventListener(MouseEvent.MOUSE_DOWN, press, false, 0, true);
        }
        
        private function press(evt:Event):void {
            stage.removeEventListener(MouseEvent.MOUSE_DOWN, press);
            stage.addEventListener(MouseEvent.MOUSE_UP, release, false, 0, true);
            px = stage.mouseX;
            py = stage.mouseY;
            addEventListener(Event.ENTER_FRAME, update, false, 0, true);
        }
        
        private function release(evt:Event):void {
            stage.removeEventListener(MouseEvent.MOUSE_UP, release);
            stage.addEventListener(MouseEvent.MOUSE_DOWN, press, false, 0, true);
            removeEventListener(Event.ENTER_FRAME, update);
            canvas.graphics.clear();
        }
        
        private function update(evt:Event):void {
            var tx:Number = stage.mouseX;
            var ty:Number = stage.mouseY;
            canvas.graphics.clear();
            canvas.graphics.lineStyle(8);
            canvas.graphics.lineBitmapStyle(fill);
            canvas.graphics.moveTo(px, py);
            canvas.graphics.lineTo(tx, ty);
            px = tx;
            py = ty;
            bitmapData.lock();
            bitmapData.draw(canvas, null, color);
            bitmapData.draw(canvas, null, color);
            bitmapData.unlock();
        }

        private function clear(evt:MouseEvent):void {
            bitmapData.lock();
            bitmapData.fillRect(bitmapData.rect, 0x00000000);
            bitmapData.unlock();
        }

        private function white(evt:MouseEvent):void {
            color = new ColorTransform(0.9, 0.9, 0.9, 1);
        }

        private function pink(evt:MouseEvent):void {
            color = new ColorTransform(1, 0.5, 0.7, 1);
        }

        private function green(evt:MouseEvent):void {
            color = new ColorTransform(0.5, 1, 0.5, 1);
        }

        private function blue(evt:MouseEvent):void {
            color = new ColorTransform(0.5, 0.5, 1, 1);
        }
        
    }

}


//////////////////////////////////////////////////
// Btnクラス
//////////////////////////////////////////////////

import flash.display.Sprite;
import flash.display.Shape;
import flash.text.TextField;
import flash.text.TextFieldType;
import flash.text.AntiAliasType;
import flash.text.TextFormat;
import flash.text.TextFormatAlign;
import flash.filters.GlowFilter;
import flash.events.MouseEvent;

class Btn extends Sprite {
    public var id:uint;
    private var shade:Shape;
    private var bottom:Shape;
    private var light:Shape;
    private var base:Shape;
    private var txt:TextField;
    private var label:String = "";
    private static var fontType:String = "_ゴシック";
    private var _width:uint = 60;
    private static var _height:uint = 20;
    private static var corner:uint = 5;
    private var type:uint = 1;
    private static var bColor:uint = 0xFFFFFF;
    private static var sColor:uint = 0x000000;
    private static var upColor:uint = 0x666666;
    private static var overColor:uint = 0x333333;
    private static var offColor:uint = 0x999999;
    private static var gColor:uint = 0x0099FF;
    private var blueGlow:GlowFilter;
    private var shadeGlow:GlowFilter;
    private var _clicked:Boolean = false;
    private var _enabled:Boolean = true;

    public function Btn() {
    }

    public function init(option:Object):void {
        if (option.id != undefined) id = option.id;
        if (option.label != undefined) label = option.label;
        if (option.width != undefined) _width = option.width;
        if (option.type != undefined) type = option.type;
        draw();
    }
    private function draw():void {
        switch (type) {
        case 1 :
            bColor = 0xFFFFFF;
            sColor = 0x000000;
            upColor = 0x666666;
            overColor = 0x333333;
            offColor = 0x999999;
            break;
        case 2 :
            bColor = 0x000000;
            sColor = 0xFFFFFF;
            upColor = 0x666666;
            overColor = 0x999999;
            offColor = 0x333333;
            break;
        }
        blueGlow = new GlowFilter(gColor, 0.6, 5, 5, 2, 3, false, true);
        shadeGlow = new GlowFilter(sColor, 0.3, 4, 4, 2, 3, false, true);
        shade = new Shape();
        bottom = new Shape();
        light = new Shape();
        base = new Shape();
        txt = new TextField();
        addChild(shade);
        addChild(bottom);
        addChild(light);
        addChild(base);
        addChild(txt);
        createBase(shade, _width, _height, corner, sColor);
        shade.filters = [shadeGlow];
        createBase(bottom, _width, _height, corner, sColor, 0.3);
        createBase(light, _width, _height, corner, gColor);
        light.filters = [blueGlow];
        createBase(base, _width, _height, corner, bColor);
        txt.x = -_width*0.5;
        txt.y = -_height*0.5;
        txt.width = _width;
        txt.height = _height - 1;
        txt.type = TextFieldType.DYNAMIC;
        txt.selectable = false;
        //txt.embedFonts = true;
        //txt.antiAliasType = AntiAliasType.ADVANCED;
        var tf:TextFormat = new TextFormat();
        tf.font = fontType;
        tf.size = 12;
        tf.align = TextFormatAlign.CENTER;
        txt.defaultTextFormat = tf;
        txt.text = label;
        enabled = true;
        mouseChildren = false;
    }
    private function rollOver(evt:MouseEvent):void {
        _over();
    }
    private function rollOut(evt:MouseEvent):void {
        _up();
    }
    private function press(evt:MouseEvent):void {
        _down();
    }
    private function release(evt:MouseEvent):void {
        _up();
    }
    private function click(evt:MouseEvent):void {
    }
    private function _up():void {
        txt.y = -_height*0.5;
        txt.textColor = upColor;
        base.y = -1;
        light.visible = false;
        light.y = -1;
    }
    private function _over():void {
        txt.y = -_height*0.5;
        txt.textColor = overColor;
        base.y = -1;
        light.visible = true;
        light.y = -1;
    }
    private function _down():void {
        txt.y = -_height*0.5 + 1;
        txt.textColor = overColor;
        base.y = 0;
        light.visible = true;
        light.y = 0;
    }
    private function _off():void {
        txt.y = -_height*0.5 + 1;
        txt.textColor = offColor;
        base.y = 0;
        light.visible = false;
        light.y = 0;
    }
    public function get clicked():Boolean {
        return _clicked;
    }
    public function set clicked(param:Boolean):void {
        _clicked = param;
        enabled = !_clicked;
        if (_clicked) {
            _down();
        } else {
            _up();
        }
    }
    public function get enabled():Boolean {
        return _enabled;
    }
    public function set enabled(param:Boolean):void {
        _enabled = param;
        buttonMode = _enabled;
        mouseEnabled = _enabled;
        useHandCursor = _enabled;
        if (_enabled) {
            _up();
            addEventListener(MouseEvent.MOUSE_OVER, rollOver, false, 0, true);
            addEventListener(MouseEvent.MOUSE_OUT, rollOut, false, 0, true);
            addEventListener(MouseEvent.MOUSE_DOWN, press, false, 0, true);
            addEventListener(MouseEvent.MOUSE_UP, release, false, 0, true);
            addEventListener(MouseEvent.CLICK, click, false, 0, true);
        } else {
            _off();
            removeEventListener(MouseEvent.MOUSE_OVER, rollOver);
            removeEventListener(MouseEvent.MOUSE_OUT, rollOut);
            removeEventListener(MouseEvent.MOUSE_DOWN, press);
            removeEventListener(MouseEvent.MOUSE_UP, release);
            removeEventListener(MouseEvent.CLICK, click);
        }
    }
    private function createBase(target:Shape, w:uint, h:uint, c:uint, color:uint, alpha:Number = 1):void {
        target.graphics.beginFill(color, alpha);
        target.graphics.drawRoundRect(-w*0.5, -h*0.5, w, h, c*2);
        target.graphics.endFill();
    }

}
