/**
 * Copyright tkinjo ( http://wonderfl.net/user/tkinjo )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/gbEY
 */

// forked from tkinjo's forked from: TextBlock Sample
// forked from tkinjo's TextBlock Sample
package { 
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.geom.Matrix;
    import flash.geom.Rectangle;
    import flash.text.engine.ElementFormat;
    import flash.text.engine.FontDescription;
    import flash.text.engine.TextBlock;
    import flash.text.engine.TextLine;
    import flash.text.engine.TextElement;
    import flash.display.Sprite;
    import flash.display.Stage;
    import org.libspark.betweenas3.BetweenAS3;
    import org.libspark.betweenas3.core.easing.BackEaseOut;
    
    [SWF(width="465", height="465", backgroundColor="0xffffff", frameRate="60")] 
    
    /**
     * ...
     * @author tkinjo
     */
    public class Sample21 extends Sprite {
        
        private const SAMPLE_TEXT:String = "吾輩（わがはい）は猫である。名前はまだ無い。\nどこで生れたかとんと見当（けんとう）がつかぬ。何でも薄暗いじめじめした所でニャーニャー泣いていた事だけは記憶している。吾輩はここで始めて人間というものを見た。しかもあとで聞くとそれは書生という人間中で一番獰悪（どうあく）な種族であったそうだ。この書生というのは時々我々を捕（つかま）えて煮（に）て食うという話である。しかしその当時は何という考もなかったから別段恐しいとも思わなかった。ただ彼の掌（てのひら）に載せられてスーと持ち上げられた時何だかフワフワした感じがあったばかりである。掌の上で少し落ちついて書生の顔を見たのがいわゆる人間というものの見始（みはじめ）であろう。この時妙なものだと思った感じが今でも残っている。第一毛をもって装飾されべきはずの顔がつるつるしてまるで薬缶（やかん）だ。その後（ご）猫にもだいぶ逢（あ）ったがこんな片輪（かたわ）には一度も出会（でく）わした事がない。のみならず顔の真中があまりに突起している。そうしてその穴の中から時々ぷうぷうと煙（けむり）を吹く。どうも咽（む）せぽくて実に弱った。これが人間の飲む煙草（たばこ）というものである事はようやくこの頃知った。\nこの書生の掌の裏（うち）でしばらくはよい心持に坐っておったが、しばらくすると非常な速力で運転し始めた。書生が動くのか自分だけが動くのか分らないが無暗（むやみ）に眼が廻る。胸が悪くなる。到底（とうてい）助からないと思っていると、どさりと音がして眼から火が出た。それまでは記憶しているがあとは何の事やらいくら考え出そうとしても分らない。"
        private const FONT_FAMILY:String = '"ヒラギノ角ゴ Pro W3","Hiragino Kaku Gothic Pro","メイリオ",Meiryo,Osaka,"ＭＳ Ｐゴシック","MS PGothic",sans-serif';
        
        public function Sample21():void {
            
            var textBlock:TextBlock = new TextBlock();
            textBlock.content = new TextElement( SAMPLE_TEXT, new ElementFormat( new FontDescription( getFont( FONT_FAMILY ) ) ) );
            
            var container:Sprite = new Sprite();
            addChild(container);
            
            var textLine:TextLine = null;
            
            var i:uint = 0;
            
            var matrix:Matrix = new Matrix();
            var delay:Number = 0;
            
            while ( textLine = textBlock.createTextLine( textLine, stage.stageWidth ) ) {
                
                for ( var j:uint = 0; j < textLine.atomCount; j++ ) {
                    
                    var atomBound:Rectangle = textLine.getAtomBounds( j );
                    var bitmapData:BitmapData = new BitmapData( atomBound.width, atomBound.height, true, 0 );
                    
                    matrix.identity();
                    matrix.translate( -atomBound.x, -atomBound.y );
                    bitmapData.draw( textLine, matrix );
                    
                    var charBitmap:Bitmap = new Bitmap( bitmapData );
                    container.addChild( charBitmap );
                    charBitmap.x = atomBound.x;
                    
                    var charBitmapY:Number = atomBound.height * i;
                    BetweenAS3.delay( BetweenAS3.tween( charBitmap, { y:charBitmapY, alpha:1 }, { y:charBitmapY + atomBound.height, alpha:0 }, 0.5, new BackEaseOut() ), delay += 0.05 ).play();
                }
                
                i++;
            }
        }
    }
}


import flash.text.Font;

function getFont( fontFamily:String ):String {
    
    var enumerateFonts:Array = Font.enumerateFonts( true );
    var fonts:Array = fontFamily.replace( /"/g, "" ).split( "," );
    for each ( var fontName:String in fonts ) {
        
        for each( var font:Font in enumerateFonts ) {
            
            if ( fontName == font.fontName )
                return fontName;
        }
    }
    
    return "";
}