/**
 * Copyright actionscriptbible ( http://wonderfl.net/user/actionscriptbible )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/gZ0j
 */

package {
  import com.actionscriptbible.Example;
  
  public class ch11ex2 extends Example {
    protected const ORIGINAL_MOVIE_LIST:XML = 
      <list>
        <listName>My favorite movies</listName>
        <movie id="123">
          <title>Titus</title>
          <year>1999</year>
          <director>Julie Taymor</director>
        </movie>
        <movie id="456">
          <title>Rushmore</title>
          <year>1998</year>
          <director>Wes Anderson</director>
        </movie>
        <movie id="789">
          <title>Annie Hall</title>
          <year>1977</year>
          <director>Woody Allen</director>
        </movie>
      </list>;
      
    public function ch11ex2() {
      
      var movieList:XML = ORIGINAL_MOVIE_LIST.copy();
      
      // QUERYING XML ----------------------------
  
      trace(movieList.listName); //My favorite movies
      trace(movieList.child("listName")); //My favorite movies
      
      trace(movieList.movie.length()); //3
      trace(movieList.*.length()); //4, includes <listName> node
      
      trace(movieList.child("*").length()); //4
      trace(movieList.children().length()); //4
      
      trace(movieList.movie[1].title); //Rushmore
      movieList.movie[3] = <movie id="012"><title>Spaceballs</title></movie>;
      trace(movieList.movie.length()); //4
      
      //reset the list since we added spaceballs
      movieList = ORIGINAL_MOVIE_LIST.copy();
      
      trace(movieList.children()[0]); //My favorite movies
      trace(movieList.child(0)); //My favorite movies
      
      var movie:XML = movieList.movie[0]; //get Titus node
      movie = (movie.parent()).children()[movie.childIndex() + 1];
      //get whatever's next
      trace(movie.title); //Rushmore
      
      trace(movieList.movie[0].@id); // Displays: 123
      movieList.movie[0].@id = 8675309;
      
      //reset it again
      movieList = ORIGINAL_MOVIE_LIST.copy();
      
      var movie:XML =
        <movie id="000" rating="*****">
          <title>The Big Lebowski</title>
          <year>1998</year>
          <director>The Coen Brothers</director>
        </movie>;
      trace(movie.@*.toXMLString());
      //000
      //*****
      trace(movieList.movie.@id); //123456789
      
      var speech:XML = 
      <div id="speech">
        Hear ye, hear ye!
        <hr/>
        All ye base art belongeth to me!
      </div >
      trace(speech.text());
  
      trace(movieList..director);
      trace(movieList..@*);
      trace(movieList.descendants("year").text()); //199919981977
      
      var title:XMLList = movieList.movie[1].title;
      var director:XMLList = title.parent().director;
      trace(title + " directed by " + director);
      //Rushmore directed by Wes Anderson
      
      var rushmore:XML = movieList.movie.(title.text() == "Rushmore")[0];
      trace(rushmore.title + " directed by " + rushmore.director);
      //Rushmore directed by Wes Anderson
      
      var classics:XMLList = movieList.movie.(parseFloat(year) < 1990).title;
      trace(classics); //Annie Hall
      var idSort:XMLList = movieList.movie.(parseInt(@id) > 400).title;
      trace(idSort);
      //<title>Rushmore</title>
      //<title>Annie Hall</title>
      
      var julies:XMLList = movieList.movie.(director.indexOf("Julie") != -1).title;
      trace(julies); //Titus
  
      // MODIFYING XML ----------------------------
      
      movieList = ORIGINAL_MOVIE_LIST.copy();
      
      var anotherMovie:XML =
      <movie id="222">
        <title>Tron</title>
        <year>1982</year>
        <director>Steven Lisberger</director>
      </movie>;
      
      
      var fruits:XMLList = <plum/> + <peach/> + <strawberry/>;
      trace(fruits.toXMLString()); /*<plum/>
      <peach/>
      <strawberry/> */
      
      var movies:XMLList = movieList.movie;
      movies += anotherMovie;
      trace(movies.title.text()); //TitusRushmoreAnnie HallTron
      
      trace(movies.title.text()); //TitusRushmoreAnnie HallTron
      //the XMLList has the new movie...
      trace(movieList.movie.title.text()); //TitusRushmoreAnnie Hall
      //but the original XML is unmodified
      
      movies[0].@newAttribute = "testing"; //modify a node in the list
      trace(movieList.movie[0]); //<movie id="123" newAttribute="testing">...
      //it changes the original node
      
      movieList = ORIGINAL_MOVIE_LIST.copy(); //let's try again
      
      movieList.movie += anotherMovie;
      //providing the context in the LHS of the assignment...
      trace(movieList.movie.title.text()); //TitusRushmoreAnnie HallTron
      //adds the node to the correct context, not just a temporary XMLList variable
      
      var annieHall:XML = movieList.movie.(title.text() == "Annie Hall")[0];
      annieHall.* += <genre/>;
      annieHall.genre = "Comedy";
      trace(annieHall);
      //<movie id="789">
      //  <title>Annie Hall</title>
      //  <year>1977</year>
      //  <director>Woody Allen</director>
      //  <genre>Comedy</genre>
      //</movie>
            
      annieHall.actor += <actor>Diane Keaton</actor>;
      annieHall.actor.@role = "Annie Hall";
      trace(movieList.movie[2]);
      
      
      
      var fruitsList:XML = <fruits>{fruits}</fruits>; //yes you can inline XMLLists!
      trace(fruitsList);
      var peachNode:XML = fruitsList.peach[0];
      fruitsList.insertChildAfter(peachNode, <banana/>);
      trace(fruitsList); //orange you glad i didn't say banana?
      
      var textList:XML = <string/>;
      textList.appendChild("hello");
      textList.appendChild(" world");
      trace(textList); //hello world
      textList.insertChildAfter(textList.child(0), " there");
      trace(textList); //hello there world
      textList.insertChildBefore(textList.child(2), " beautiful");
      trace(textList); //hello there beautiful world
      trace(typeof textList.insertChildAfter("hello", "HEY!")); //undefined

      // REMOVING XML -------------------
      movieList = ORIGINAL_MOVIE_LIST.copy();
      delete movieList.movie[2];
      trace(movieList);
      movieList = ORIGINAL_MOVIE_LIST.copy();
      trace("--");
      delete movieList.movie.director;
      delete movieList.movie.year;
      trace(movieList);
      movieList = ORIGINAL_MOVIE_LIST.copy();
      trace("--");
      
      delete anotherMovie.@*;
      trace(anotherMovie); //<movie>... the id is gone.
      anotherMovie.@id = 222; //let's add the id attribute back.

      // DUPLICATING XML ---------------------
      
      var template:XML = <person><name><first /><last /></name></person>;
      var me:XML = template;
      me.name.first = "Roger";
      me.name.last = "Braunstein";
      var someoneElse:XML = template;
      trace(someoneElse); //oops, we've modified the template instead:
      //<person>
      //  <name>
      //    <first>Roger</first>
      //    <last>Braunstein</last>
      //  </name>
      //</person>
      
      var template:XML = <person><name><first /><last /></name></person>;
      var me:XML = template.copy();
      me.name.first = "Roger";
      me.name.last = "Braunstein";
      var mario:XML = template.copy();
      mario.name.first = "Mario";
      mario.name.last = "Bros";
      trace(template); //all good, keep the copies coming!
      //<person>
      //  <name>
      //    <first/>
      //    <last/>
      //  </name>
      //</person>
      
      // STRING CONVERSION ---------------------
      var dialog:String = "Lorem ipsum dolor sit amet";
      var xmlString:String = "<dialog>" + dialog + "</dialog>";
      var xml:XML = XML(xmlString);
      trace(xml.text()); //Lorem ipsum dolor sit amet
      
      var meal:XML = 
        <meal>
          <name>Dinner</name>
          <course number="1">
              <item>Salad</item>
          </course>
          <course number="2">
             <item>Potatoes</item>
              <item temperature="Medium Rare">Steak</item>
          </course>
       </meal>;
      trace(meal.name); //Dinner
      trace(meal.course[0]); //<course number="1">
                             //  <item>Salad</item>
                             //</course>
      trace(meal.course[1].item[0].toXMLString()); //<item>Potatoes</items>
      trace(meal.course[1].item[1].toString()); //Steak
      trace(meal.course[1].item[1].@temperature.toXMLString()); //Medium Rare
      trace(meal..item.toString());
      //<item>Salad</item>
      //<item>Potatoes</item>
      //<item temperature="Medium Rare">Steak</item>
      
      var example:XML = <stooges>
                           <moe /><curly><larry>   
          </larry>
                                 </curly>
                 </stooges>;
      XML.prettyPrinting = false;
      trace(example); 
      //<stooges><moe/><curly><larry/></curly></stooges>
      
      XML.prettyPrinting = true;
      trace(example); 
      //<stooges>
      //  <moe/>
      //  <curly>
      //    <larry/>
      //  </curly>
      //</stooges>
      
      XML.prettyIndent = 0;
      trace(example);
      XML.prettyIndent = 8;
      trace(example);
      
      // NODE METAINFORMATION --------------------
      XML.ignoreComments = false;
      XML.ignoreProcessingInstructions = false;
      var xhtml:XML =
        <html>
          <head />
          <body id="main">
            Welcome!
            <!-- Start PHP -->
            <?php echo("hello world") ?>
            <!-- End PHP -->
          </body>
        </html>;
      var node:XML;
      trace(xhtml.body.nodeKind()); //element
      trace(xhtml.body.@id.nodeKind()); //attribute
      
      node = xhtml.body.text()[0];
      trace(node.nodeKind(), node.toXMLString()); //text Welcome!
      
      node = xhtml.body.comments()[0];
      trace(node.nodeKind(), node.toXMLString()); //comment <!-- Start PHP -->
      
      node = xhtml.body.processingInstructions()[0]
      trace(node.nodeKind(), node.toXMLString());
      //processing-instruction <?php echo("hello world") ?>
      
      
      var contentTest:XML =
      <test>
          <a />
          <b>Lorem Ipsum</b>
          <c>
            <d />
          </c>
        </test>;
      trace(contentTest.a.hasSimpleContent());  //true
      trace(contentTest.b.hasSimpleContent());  //true
      trace(contentTest.c.hasSimpleContent());  //false
      trace(contentTest.d.hasComplexContent()); //false
    }
  }
}