/**
 * Copyright mfc314159 ( http://wonderfl.net/user/mfc314159 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/gYts
 */

package {
    import flash.display.*;
    import flash.events.*;
    import flash.filters.*;
    import flash.geom.*;
  
    import org.papervision3d.render.BasicRenderEngine;
    import org.papervision3d.scenes.Scene3D;
    import org.papervision3d.view.Viewport3D;
    import org.papervision3d.cameras.Camera3D;
    import org.papervision3d.core.effects.*;
    import org.papervision3d.core.effects.utils.*;
    import org.papervision3d.view.layer.*;
    import org.papervision3d.objects.*;
    import org.papervision3d.view.*;
    import org.papervision3d.objects.primitives.*;
    import org.papervision3d.materials.ColorMaterial;
    import org.papervision3d.lights.PointLight3D;
    import org.papervision3d.materials.shadematerials.FlatShadeMaterial;
    import org.papervision3d.materials.shaders.FlatShader;
    import org.papervision3d.materials.shaders.ShadedMaterial;
	

    public class Mainsouth extends Sprite {
        private const piE:Number = Math.PI / 180;
		
	private var viewport:Viewport3D;        
	private var scene:Scene3D;        
	private var renderer:BasicRenderEngine;        
	private var camera:Camera3D;
		
	private var cx:int = stage.stageWidth *  .5;
	private var cy:int = stage.stageHeight * .5;
	private var newX:Number;
	private var newY:Number;
		
	private var shooting:Boolean = false;
	private var count:int;
	private var pwr:Number = 0.00;
		
        private var baseSphere:Sphere;
	private var subSpheres:Array = [];
	private var sphere:DisplayObject3D;
	private var baseSize:int = 500;
	private var baseSegs:int = 8;
		
	private var subSize:int = 50;
	private var subSegs:int = 7;
        
	private var rings:Array = [];
		
	private var vs:Array = [];
        private var vc:int;
	private var i:int = 0;
		
	private var light:PointLight3D;
	private var angle:Number = 0;
		
        public function Mainsouth() {

		viewport = new Viewport3D();
		viewport.opaqueBackground = 0x000000;
		viewport.viewportWidth = 1000; 
		viewport.viewportHeight = 700;
		viewport.x = ( this.stage.stageWidth - viewport.viewportWidth ) / 2; 
		viewport.y = ( this.stage.stageHeight - viewport.viewportHeight ) / 2;
		addChild(viewport);
		scene = new Scene3D();
		camera = new Camera3D();
		renderer = new BasicRenderEngine();  
		//ligting
	      	light = new PointLight3D(true);
		light.x = 50;
		light.y = 1000;
		light.z = 0;
		//scene.addChild(light);
			
		generateSpheres();
			
		addEventListener(Event.ENTER_FRAME, loop);
        }
	private function generateSpheres():void {
		//--whole sha-bang
	        sphere = new DisplayObject3D();
	        //--build Sphere to get vertice from
	        baseSphere = new Sphere(null, baseSize, baseSegs, baseSegs);
                //--Get vertice info
			vs = baseSphere.geometry.vertices;
                vc = vs.length;
	 	i = 0; // --SETUP RINGS--
                while(i < baseSegs+1) {
			rings[i] = new Array(); //everything rings
			rings[i][0] = new DisplayObject3D(); //ring container
			rings[i][100] = Number(Math.random() * 0xFFFFFF); //ring color
			//ring[i][10]] = whatever material
			//rings[i][101] = new WireframeMaterial(rings[i][100], 1, .1);
			//rings[i][101] = new ColorMaterial(rings[i][100], 1, false);
			rings[i][101] = new FlatShadeMaterial(light, rings[i][100], 0x000000, 100);
		
			
			//ring yaw speed
			rings[i][102] = .33 + Number(baseSegs - (Math.random() * (2 * baseSegs)));
			rings[i][102] *= .45;
			i++;
	        }
	        i = 0;// --SETUP subSPHERES--
	        while(i < vc) {
        		//find ring index from y 
	    		var idx = int(.5 * (baseSegs + (baseSegs * (vs[i].y / baseSize))));
			//build sphere with ring props						
			subSpheres[i] = new Sphere(rings[idx][101], subSize, subSegs, subSegs-1);
			//add to ring
			rings[idx][0].addChild(subSpheres[i]);
			//set sphere to vertix postion
			subSpheres[i].x = vs[i].x;
			subSpheres[i].y = vs[i].y;
			subSpheres[i].z = vs[i].z;
			
			i++;
		}
	        i = 0;// --ADD RINGS TO SPHERE--
	        while(i < baseSegs+1) {
			sphere.addChild(rings[i][0]);
			i++;
	        }
		scene.addChild(sphere); //Sphere to set
		sphere.z = -125;// a little down.. thank you.
	}
		
	private function loop(e:Event):void {
		i = 0;//
		/*while(i < vc) {
			subSpheres[i].pitch(.75);
			i++;
		}*/
			
		i = 0;
		while(i < baseSegs+1) {
			rings[i][0].yaw(rings[i][102]);
			rings[i][0].pitch(i*.11);
			i++;
		}
		sphere.roll(1);
		renderer.renderScene(scene, camera, viewport);
    	}
		
    }
}
