/**
 * Copyright TmskSt ( http://wonderfl.net/user/TmskSt )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/gYWE
 */

package {
    import com.bit101.components.HUISlider;
    import flash.display.Shape;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
    
    public class RangeTest extends Sprite {
        
        private const M_M:int = 100;
        private const P_S:int = 100;
        
        private var _V_G:HUISlider;
        private var _V_N:HUISlider;
        private var _V_P:HUISlider;
        private var _V_K:HUISlider;
        
        private var _$_MARKER_CURSOR:Shape = new Shape;
        private var _$_MARKER_BLT:Shape = new Shape;
        
        public function RangeTest() {
            
            this.graphics.lineStyle(1, 0x52B6DC, .5);
            
            _V_G = new HUISlider(this, 5, 5, "G", handler);
            _V_N = new HUISlider(this, 5, 20, "N", handler);
            _V_P = new HUISlider(this, 5, 35, "P", handler);
            _V_K = new HUISlider(this, 5, 50, "K", handler);
            _V_G.value = 50;
            _V_N.value = 50;
            _V_P.setSliderParams(0, 3, .5);
            _V_K.setSliderParams(0, 300, 150);
            
            
            handler(null);
            
            
        }
        
        private function handler(e:Event):void {
            
            this.graphics.clear();
            this.graphics.lineStyle(1, 0);
            
            const G:int = int(_V_G.value);
            const N:int = int(_V_N.value);
            const P:Number = Number(_V_P.value);
            const K:Number = int(_V_K.value);
            
            var i:int = 0, k:int = 0;
            while (++i < G) {
                with (graphics) {
                    moveTo(465 + 465 * P, K);
                    lineTo((i % 2 != 0) ? (k++) * N : k * -N, 465);
                }
            }
            
            i = 0, k = 0;
            while (++i < G) {
                with (graphics) {
                    moveTo( - 465 * P, K);
                    lineTo(465 + ((i % 2 != 0) ? (k++) * N : k * -N), 465);
                }
            }
        }
    }

}