/**
 * Copyright cpu_t ( http://wonderfl.net/user/cpu_t )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/gYVj
 */

package
{
    import flash.display.Sprite;
	import flash.events.Event;
	import flash.filters.BlurFilter;
    public class FlashTest extends Sprite
	{
		private var particles:Array;
		private var blurs:Array;
        public function FlashTest()
		{
			particles = new Array();
			blurs = new Array();
			blurs.push(new BlurFilter(2, 2), new BlurFilter(4, 4), new BlurFilter(8, 8), new BlurFilter(12, 12));
			this.graphics.beginFill(0);
			this.graphics.drawRect(0, 0, stage.stageWidth, stage.stageHeight);
            addEventListener(Event.ENTER_FRAME, loop);
        }
		
		private function loop(e:Event):void 
		{
			var hue:Number;
			var color:uint;
			
			for (var k:int = 0; k < 3; k++)
			{
				hue = Math.random() * 360;
				color = 0;
				if (hue <= 60)
				{
					color = 0xFF0000 + (int)(hue / 60 * 0xFF) * 0x000100;
				}
				else if (hue <= 120)
				{
					color = 0x00FF00 + (int)(0xFF - (hue % 60) / 60 * 0xFF) * 0x010000;
				}
				else if (hue <= 180)
				{
					color = 0x00FF00 + (int)((hue % 60) / 60 * 0xFF) * 0x000001;
				}
				else if (hue <= 240)
				{
					color = 0x0000FF + (int)(0xFF - (hue % 60) / 60 * 0xFF) * 0x000100;
				}
				else if (hue <= 300)
				{
					color = 0x0000FF + (int)((hue % 60) / 60 * 0xFF) * 0x010000;
				}
				else
				{
					color = 0xFF0000 + (int)(0xFF - (hue % 60) / 60 * 0xFF) * 0x000001;
				}
				
				var sp:Sprite = new Sprite();
				sp.graphics.beginFill(color);
				sp.graphics.drawCircle(0, 0, Math.random() * 10 + 10);
				sp.graphics.drawCircle(0, 0, Math.random() * 10 + 9);
				sp.graphics.drawCircle(0, 0, Math.random() * 10 + 8);
				sp.graphics.drawCircle(0, 0, Math.random() * 10 + 5);
				sp.x = hue / 360 * stage.stageWidth;
				sp.y = stage.stageHeight + 20;
				sp.filters = [blurs[Math.floor(Math.random() * 4)]];
				addChild(sp);
				
				particles.push( { sprite:sp, v: -Math.random() * 15 - 10 } );
			}
			
			for (var i:int = 0; i < particles.length; i++)
			{
				sp = particles[i].sprite;
				sp.y += particles[i].v;
				if (sp.y >= stage.stageHeight + 30)
				{
					particles.splice(i--, 1);
					removeChild(sp);
				}
				else
				{
					particles[i].v += .5;
				}
			}
		}
    }
}