/**
 * Copyright romatica ( http://wonderfl.net/user/romatica )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/gXiN
 */

/**
 * copyright (c) 2012 www.romatica.com
 * @author itoz
 * @since 2012/09/22 1:00:34
 * 
 * Away3D PerlinNoiz Tunnel
 */

 package 
 {
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import away3d.containers.View3D;

    import flash.display.StageAlign;
    import flash.display.StageScaleMode;
    import flash.events.Event;
    import flash.geom.Vector3D;
    import flash.utils.getTimer;

    [SWF(backgroundColor="#000000", frameRate="60", width="465", height="465")]
    /**
     * Away3D PerlinNoiz Tunnel
     */
    public class Wonderfl_perlinNoizTunnel extends View3D
    {
        private static const MAX_DISTANCE : int = 2048;
        private static const LOOK : Vector3D = new Vector3D(0, 0, MAX_DISTANCE);
        private var _tunnel : TunnelPerlinNoize;
        private var _capture : Bitmap;

        public function Wonderfl_perlinNoizTunnel()
        {
            super();
            if (stage) _initialize(null);
            else addEventListener(Event.ADDED_TO_STAGE, _initialize);
        }

        private function _initialize(event : Event) : void
        {
            removeEventListener(Event.ADDED_TO_STAGE, _initialize);

            // ★wonderfl capture
            Wonderfl.disable_capture();
           // _capture = addChild(new Bitmap(new BitmapData(465, 465, false, 0x000000))) as Bitmap ;
            
            stage.scaleMode = StageScaleMode.NO_SCALE;
            stage.align = StageAlign.TOP_LEFT;
            backgroundColor = 0x0;
            antiAlias = 4;
            createObject();
            addEventListener(Event.ENTER_FRAME, onUpdate);
        }

        private function createObject() : void
        {
            _tunnel = scene.addChild(new TunnelPerlinNoize(MAX_DISTANCE)) as TunnelPerlinNoize;
        }

        private function onUpdate(event : Event) : void
        {
            if (_tunnel) _tunnel.update();
            
            var t : Number = getTimer();
            camera.x = Math.sin(t / 1024) * 256;
            camera.y = Math.cos(t / 768) * 256;
            camera.z = -10;
            camera.lookAt(LOOK);

            render();
            
           // wonderfl capture
           if(_capture) renderer.queueSnapshot(_capture.bitmapData);
            
        }
    }
}

//--------------------------------------------------------------------------
//
//  tunnel
//
//--------------------------------------------------------------------------
import away3d.containers.ObjectContainer3D;
import away3d.entities.Mesh;
import away3d.primitives.ConeGeometry;

import flash.geom.Matrix3D;

import away3d.materials.methods.FogMethod;
import away3d.textures.BitmapTexture;
import away3d.materials.TextureMaterial;

import flash.geom.Point;
import flash.display.BitmapData;

class TunnelPerlinNoize extends ObjectContainer3D
{
    private static const NUM_OCTAVES : int = 2;
    private var bitmapData : BitmapData;
    private var offsets : Array;
    private var speeds : Array;
    private var textureMaterial : TextureMaterial;
    private var cone : Mesh;
    private var _maxDistance : int;
    private var seed : Number = Math.random() * 1000;

    public function TunnelPerlinNoize(maxDistance : int = 2048)
    {
        super();
        _maxDistance = maxDistance || 2048;
        // ----------------------------------
        // create objects
        // ----------------------------------
        bitmapData = new BitmapData(512, 256, false);
        offsets = [];
        speeds = [];
        for (var i : int = 0;i < NUM_OCTAVES;i++) {
            offsets[i] = new Point(0, 0);
            speeds[i] = new Point(0, -8 * i);
        }

        // ----------------------------------
        // texture check
        // ----------------------------------
        // var testBitmap : Bitmap =   addChild(new Bitmap(bitmapData)) as Bitmap;

        // ----------------------------------
        // texture
        // ----------------------------------
        var h : int = _maxDistance * 1.2 ;
        textureMaterial = new TextureMaterial(new BitmapTexture(bitmapData));
        textureMaterial.bothSides = true;
        textureMaterial.alphaBlending = true;
        textureMaterial.addMethod(new FogMethod(_maxDistance * 0.7, _maxDistance, 0x0));

        // ----------------------------------
        // mesh
        // ----------------------------------
        var mat3d : Matrix3D = new Matrix3D();
        mat3d.appendTranslation(0, h >> 1, 0);
        var geo : ConeGeometry = new ConeGeometry(512, h, 16, 16, true);
        geo.applyTransformation(mat3d);
        cone = addChild(new Mesh(geo, textureMaterial)) as Mesh;
        cone.rotationX = 90;
    }

    public function update() : void
    {
        var i : int;
        for (i = 0;i < NUM_OCTAVES;i++) {
            var offset : Point = offsets[i] as Point;
            var speed : Point = speeds[i] as Point;
            offset.x += speed.x;
            offset.y += speed.y;
        }

        if (bitmapData) bitmapData.perlinNoise(128, 256, NUM_OCTAVES, seed, true, false, 7, false, offsets);
        if (cone) {
            cone.rotationZ++;
            var mat : TextureMaterial = cone.material as TextureMaterial;
            if (mat) mat.texture = new BitmapTexture(bitmapData);
        }
    }
}

 