/**
 * Copyright masanori417 ( http://wonderfl.net/user/masanori417 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/gXFU
 */

// forked from fumix's forked from: てらこ23で発表したものの説明２
// forked from y_tti's てらこ23で発表したものの説明２
/*
マトリックスを使って台形な変形
４点のポイントを用意して、その位置を元に変形。
台形といっても三角形が２つ合体させてます。
だらだら長いソースになってしまったけど、
_draw
_getTransformMatrix
の部分が重要なんで、他は無視無視無視無視無視無視無視無視！！

格子状にしたら面白いんじゃないかとやってみた。
分割した矩形の１個目の描画部分が良く分からず・・・。
わざわざ、bitmapDataを別に用意して、矩形にコピーしてそれを変形させて_canvasに再描画しているが
２個目の分割した矩形はそんなことをせず、直接_canvasに変形させて描画しても問題ない。
１個目は直接変形させて描画すると、順番がめちゃめちゃになる。
テスト用画像を使ってみるとよく分かる。
出来そうで出来ないのが悔しい
*/
package
{
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Loader;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.geom.Matrix;
    import flash.geom.Point;
    import flash.net.URLRequest;
    import flash.system.LoaderContext;
    
    import net.hires.debug.Stats;
    
    [SWF(width = "465", height = "465", frameRate = "30", backgroundColor = "0x000000")]
    public class box extends Sprite
    {
        private var _container:Sprite;
        private var _canvas:Sprite;
        private var _bmd:BitmapData;
        private var _stageW:Number = 465;
        private var _stageH:Number = 465;
        private var _w:Number;
        private var _cP0:CirclePoint;
        private var _cP1:CirclePoint;
        private var _cP2:CirclePoint;
        private var _cP3:CirclePoint;      
        private var _matrixArray:Array;

        //格子のどこに画像が描画されているかを見るためのテスト用画像
        //private const IMAGE_URL:String = "http://www.planet-ape.net/wonderfl/base.jpg";        
        
        private const IMAGE_URL:String = "http://www.planet-ape.net/wonderfl/kuri.jpg";        
        
        public function box()
        {
            if (stage) init();
            else addEventListener(Event.ADDED_TO_STAGE, init);
        }
        
        private function init(e:Event = null):void 
        {
            removeEventListener(Event.ADDED_TO_STAGE, init);
            //画像の読み込み
            var req:URLRequest = new URLRequest(IMAGE_URL);
            var loader:Loader = new Loader();
            loader.contentLoaderInfo.addEventListener(Event.COMPLETE, loadComplete);    
            loader.load( req, new LoaderContext(true));
            // take a capture after 10 sec
            //Wonderfl.capture_delay( 120 );
        }
        
        //画像読み込み後の処理
        private function loadComplete(e:Event):void 
        {
            e.target.removeEventListener(Event.COMPLETE, loadComplete);
        
            //取得した画像を切り取って_bmdに入れる
            _bmd = new BitmapData (350, 350, true, 0xFFFFFF);
            _bmd.draw (e.target.loader.content.bitmapData);
            
            //キャンバスを用意してコンテナに入れる(重要じゃないので無視無視)
            _canvas = new Sprite();
            _container = new Sprite();
            _container.addChild(_canvas);
            addChild(_container);
            _container.x = (_stageW - _bmd.width)/2;
            _container.y = (_stageH - _bmd.height)/2;
            
            //画像の大きさに合わせ、ポイントを5ｘ5の格子に配置する(配列に入れる）
            //CirclePointのコンストラクタの中で初期状態のポイント位置を保持してます。（initPoint）
            //その初期ポイントと、マウスドラッグで移動したポイントを比較してるのが、_drawの中。
            _w = _bmd.width / 10;

            _matrixArray = new Array ();
            //x軸とy軸の2重ループ(配列に入れる
            for (var j:int = 0; j <= _bmd.width; j += _w) {
                for (var i:int = 0; i <= _bmd.height; i += _w) {
                    var cp:CirclePoint = new CirclePoint (i, j);
                    trace ('cp'+i+':' + cp.initPoint);
                    _matrixArray.push (cp);
                    //ポイントのドラッグとかの設定
                    //※ドラッグした時に_drawを呼び出してます。
                    cp.addEventListener(MouseEvent.MOUSE_DOWN , _cPMouseDownHandler );
                    _container.addChild (cp);
                }
            }
            _draw();
            
            //速度とかメモリとかチェック(重要じゃないので無視無視)
            addChild(new Stats());
        }
        
        private function _draw():void {
            /**
             * ポイントの番号は↓な感じ。
             *   0--------1
             *   ----------
             *   ----------
             *   2--------3
             */            
            //マトリックスを適応
            _canvas.graphics.clear();

            //配列のループ
            for (var k:String in _matrixArray) {
                //
                if (int(k) > 113) break;
                if ((int (k) + 1) % 11 == 0) continue;
                //初期状態のポイント取得
                _cP0 = _matrixArray[int (k)];
                _cP1 = _matrixArray[int (k) + 1];
                _cP2 = _matrixArray[int (k) + 11];
                _cP3 = _matrixArray[int (k) + 12];
                
                var aP0:Point = _cP0.initPoint;
                var aP1:Point = _cP1.initPoint;
                var aP2:Point = _cP2.initPoint;
                var aP3:Point = _cP3.initPoint;

                //初期状態のポイントよりマトリックス取得
                var initMatrix1:Matrix = _getTransformMatrix( aP0 , aP1 , aP3 );
                var initMatrix2:Matrix = _getTransformMatrix( aP3 , aP2 , aP1 );
                //変更状態のポイント取得
                var bP0:Point = new Point(_cP0.x , _cP0.y );
                var bP1:Point = new Point(_cP1.x , _cP1.y );
                var bP2:Point = new Point(_cP2.x , _cP2.y );
                var bP3:Point = new Point (_cP3.x , _cP3.y );
                //変更状態のポイントよりマトリックス取得
                var editMatrix1:Matrix = _getTransformMatrix( bP0 , bP1 , bP2 );
                var editMatrix2:Matrix = _getTransformMatrix( bP3 , bP2 , bP1 );                
                //初期状態と変更状態のマトリックスを合体
                var newMatrix1:Matrix = initMatrix1.clone();
                newMatrix1.concat(editMatrix1);
                var newMatrix2:Matrix = initMatrix2.clone();
                newMatrix2.concat(editMatrix2);
                
                //（無理やり）分割した１個目の描写のロジック
                //２個目はわざわざ、別のbitmapDataを用意しなくても直接描画できる。
                //１個目は別のbitmapDataを用意ないと順番がめちゃくちゃになる。
                var matBmd:BitmapData = new BitmapData (35, 35, true);
                var mat:Matrix = new Matrix ();
                mat.tx = - aP0.x;
                mat.ty = - aP0.y;
                matBmd.draw (_bmd, mat);

                //分割した１個目を描画
                _canvas.graphics.lineStyle(1 , 0x00FF00);
                _canvas.graphics.beginBitmapFill(matBmd , newMatrix1 );
                _canvas.graphics.moveTo(bP0.x , bP0.y );
                _canvas.graphics.lineTo(bP1.x , bP1.y );
                _canvas.graphics.lineTo(bP2.x , bP2.y );
                _canvas.graphics.endFill ();
                
                //分割した２個目を描画
                _canvas.graphics.lineStyle(1 , 0x00FF00);
                _canvas.graphics.beginBitmapFill(_bmd , newMatrix2 );
                _canvas.graphics.moveTo(bP3.x , bP3.y );
                _canvas.graphics.lineTo(bP1.x , bP1.y );
                _canvas.graphics.lineTo(bP2.x , bP2.y );
                _canvas.graphics.endFill();
            }            
        }
        
        
        private function _getTransformMatrix($pt0:Point, $pt1:Point, $pt2:Point):Matrix
        {
            /*
            http://www.adobe.com/jp/devnet/flash/articles/matrix_class.html
            a: 水平方向の伸縮率 = 変換後の幅/もとの幅
            b: 垂直方向の傾斜率 = 垂直方向の傾斜/もとの幅
            c: 水平方向の傾斜率 = 水平方向の傾斜/もとの高さ
            d: 垂直方向の伸縮率 = 変換後の高さ/もとの高さ
            tx: 水平方向の移動ピクセル数
            ty: 垂直方向の移動ピクセル数
            */
            var w:Number = _w;
            var h:Number = _w;
            var mat:Matrix = new Matrix();
            mat.a = ($pt1.x - $pt0.x) / w;
            mat.b = ($pt1.y - $pt0.y) / w;
            mat.c = ($pt2.x - $pt0.x) / h;
            mat.d = ($pt2.y - $pt0.y) / h;
            mat.tx = $pt0.x;
            mat.ty = $pt0.y;
            return mat;
        }
        
        //こっからマウスのドラッグとかの設定（無視無視）
        private function _cPMouseDownHandler(e:MouseEvent):void {
            CirclePoint(e.target).startDrag();
            CirclePoint(e.target).addEventListener(MouseEvent.MOUSE_MOVE , _cPMouseMoveHandler );
            stage.addEventListener(MouseEvent.MOUSE_UP , _cPMouseUpHandler );
        }
        
        private function _cPMouseUpHandler(e:MouseEvent):void {
            CirclePoint(e.target).stopDrag();
            CirclePoint(e.target).removeEventListener(MouseEvent.MOUSE_MOVE , _cPMouseMoveHandler );
            stage.removeEventListener(MouseEvent.MOUSE_UP , _cPMouseUpHandler );
        }
        
        private function _cPMouseMoveHandler(e:MouseEvent):void {
            _draw();
        }
        
        

    }
}


import flash.display.Bitmap;
import flash.display.Shape;
import flash.display.BitmapData;
import flash.display.Sprite;
import flash.geom.Point;

/**
 * 赤い点を書いてる。
 * それと初期状態のポイントをinitPointに保持してる。
 */
class CirclePoint extends Sprite {
    public var initPoint:Point;
    public function CirclePoint($x:Number , $y:Number) {
        this.x = $x;
        this.y = $y;
        this.initPoint = new Point( $x , $y );
        this.graphics.beginFill(0xFF0000,1);
        this.graphics.drawCircle(0,0,5);
        this.graphics.endFill();
        this.buttonMode = true;
    }
}

/**
 * このTestImageクラスは画像の代わりに無理矢理、
 * BitmapDataを作成してるだけなので無視無視無視無視無視。
 */
class TestImage extends Bitmap {
    private var _w:Number = 200;
    private var _h:Number = 200;
    public function TestImage():void {
        var s:Shape = new Shape();
        s.graphics.beginFill(0xCCCCCC , 1 );
        s.graphics.drawRect(0,0,_w,_h);
        s.graphics.beginFill(0xFCFCFC , 1 );
        s.graphics.drawRoundRect(30 , 30 , 30 , 10 , 20 ,20);
        s.graphics.drawRoundRect(140 , 30 , 30 , 10 , 20 ,20);
        s.graphics.drawCircle(50,70,10);
        s.graphics.drawCircle(150,70,10);
        s.graphics.drawCircle(75,120,5);
        s.graphics.drawCircle(125,120,5);
        s.graphics.drawRoundRect(40 , 170 , 120 , 10 , 20 ,20);
        s.graphics.endFill();
        
        var bmd:BitmapData = new BitmapData(_w,_h);
        bmd.draw(s);
        this.bitmapData = bmd;
    }
}