/**
 * Copyright h_sakurai ( http://wonderfl.net/user/h_sakurai )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/gWpF
 */

// forked from h_sakurai's forked from: Altanativa3D 7.5 test
// forked from 9re's Altanativa3D 7.5 test
package {
    import alternativ7.engine3d.materials.FillMaterial;
    import alternativ7.engine3d.primitives.Box;
    import alternativ7.engine3d.core.Sorting;
    import flash.geom.Vector3D;
    import flash.display.Sprite;

    [SWF(width = 465, height = 465, frameRate = 60)]
    public class SimpleDemo extends Sprite {
        public function SimpleDemo() {
            // テンプレートを作成します
            var template:BasicTemplate = new BasicTemplate(stage);
            addChild(template);

            var box:Box = new Box(200, 200, 200, 3, 3, 3);
            // Box
            var material:FillMaterial = new FillMaterial(0xff8800);
            box.setMaterialToAllFaces(material);
            box.sorting = Sorting.DYNAMIC_BSP;
            box.rotationX = 10;

            template.scene.addChild(box);
            // Event.ENTER_FRAME 時に実行されるレンダリングのイベントです。
            // レンダリング前に実行したい処理を記述します。
            template.onPreRender = function():void {
                // 立方体を回転させます (角度はラジアン)
                //box.rotationY += 1 * Math.PI / 180;
            
                // マウスがステージの高さ何%の位置にあるか算出
                var rateY:Number = mouseY / stage.stageHeight;
                
                // カメラの高さの座標を調整
                // イージングの公式 対象の値 += (目標値 - 現在の値) * 減速率
                //template.camera.y += ( - 1000 * rateY - template.camera.y) * 0.1;
                
                // カメラの座標を中央に向かせる
                template.cameraController.lookAt(new Vector3D());
            }

        }

    }
}


/**
 * BasicTemplate for Alternativa3D
 * Alternativa3Dを扱いやすくするためのテンプレートです
 * @author Yasu
 */
import alternativ7.engine3d.controllers.SimpleObjectController;
import alternativ7.engine3d.core.Camera3D;
import alternativ7.engine3d.core.Object3D;
import alternativ7.engine3d.containers.ConflictContainer;
import alternativ7.engine3d.core.View;
import flash.display.Stage;
import flash.display.Sprite;
import flash.display.StageAlign;
import flash.display.StageQuality;
import flash.display.StageScaleMode;
import flash.events.Event;

    
class BasicTemplate extends Sprite{
    /**
     * シーンインスタンスです。
     */
    public var scene:ConflictContainer;

    public var camera:Camera3D;
    public var cameraController:SimpleObjectController;
        public function BasicTemplate(stage:Stage) {
        // Camera
        camera = new Camera3D();
        camera.view = new View(480, 480);
        addChild(camera.view);
        camera.z = -400;

        // Camera controller
        cameraController = new SimpleObjectController(stage, camera, 200, 3);
        
        // Root object
        scene = new ConflictContainer();
        scene.resolveByAABB = true;
        scene.resolveByOOBB = true;

        // Adding
        scene.addChild(camera);

        
        addEventListener(Event.ENTER_FRAME, onRenderTick);
    }
    /**
     * Event.ENTER_FRAME 時に実行されるレンダリングのイベントです。
     * レンダリング前に実行したい処理を記述します。
     */
    private var _onPreRender:Function = function():void{};
    public function get onPreRender():Function { return _onPreRender; }
    public function set onPreRender(value:Function):void {
        _onPreRender = value;
    }
    
    public function onRenderTick(e:Event = null):void {
        _onPreRender();
        cameraController.update();
        camera.render();
    }
}
