/**
 * Copyright yama3 ( http://wonderfl.net/user/yama3 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/gVrm
 */

package {
	import flash.display.Sprite;
	import flash.text.TextField;
	import flash.text.TextFieldType;
	import flash.text.TextFieldAutoSize;
	import flash.text.TextFormat;
	import flash.events.FocusEvent;
	import flash.events.KeyboardEvent;
	
	public class MyTextField extends Sprite {
		public var fld:TextField;
		public var alterFld:TextField;
		public var minChars:uint = 8;
		public function MyTextField() {
			var tf:TextFormat = new TextFormat();
			tf.font = "_typewriter";
			tf.size = 14;
			fld = new TextField();
			fld.type = TextFieldType.INPUT;
			fld.defaultTextFormat = tf;
			fld.restrict = "0-9a-zA-Z";
			fld.maxChars = 16;
			fld.displayAsPassword = true;
			fld.x = 100;
			fld.y = 50;
			fld.width = 160;
			fld.height = 24;
			fld.border = true;
			addChild(fld);
			
			fld.addEventListener(FocusEvent.FOCUS_IN, focusInHandler);
			fld.addEventListener(FocusEvent.FOCUS_OUT, focusOutHandler);
			fld.addEventListener(KeyboardEvent.KEY_DOWN, keyDownHandler);
			
			alterFld = new TextField();
			alterFld.selectable = false;
			alterFld.background = true;
			alterFld.backgroundColor = 0xFAD163;
			alterFld.defaultTextFormat = tf;
			alterFld.autoSize = TextFieldAutoSize.LEFT;
			alterFld.text = "半角英数で" + minChars + "～" + fld.maxChars + "文字を入力してください。";
			alterFld.x = fld.x;
			alterFld.y = fld.y + fld.height + 2;
			alterFld.visible = false;
			addChild(alterFld);
		}
		public function focusInHandler(event:FocusEvent):void {
			alterFld.visible = false;
		}
		public function focusOutHandler(event:FocusEvent):void {
			if (fld.text.length < minChars) {
				alterFld.visible = true;
			}
		}
		public function keyDownHandler(event:KeyboardEvent):void {
			if (event.charCode == 13) {
				if (fld.text.length < minChars) {
					alterFld.visible = true;
				}
			} else {
				alterFld.visible = false;
			}
		}
	}
}