/**
 * Copyright yabuchany ( http://wonderfl.net/user/yabuchany )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/gVXo
 */

package {
	import frocessing.display.*;
	
	[SWF(width="465", height="465", frameRate="60")]
	public class TailClock extends F5MovieClip2DBmp {
		private var inc:Number = 0;
		
		public function TailClock() {
			super();
		}
		
		public function setup():void {
			//colorMode(HSB, 100);
			stroke(255,204);
			smooth();
			background(0);
		}
		public function draw():void {
			var s:Number=second();
			var m:Number=minute() + 3 / 60.0;
			var h:Number=hour() % 12 + m / 60.0;
			//stroke(h,m,s);
			background(0);
			inc +=0.01;
			var angle:Number = sin(inc)/10.0+sin(inc*1.2)/20.0;
			tail(width/4,h,angle*h);
			tail(width/2,m,angle*m);
			tail(width/4*3,s,angle*s);
			
		}
		public function tail(x:int,units:int,angle:Number):void {
			pushMatrix();
			translate(x,height);
			for(var i:int=units;i>0;i--){
				strokeWeight(1);
				line(0,0,0,-8);
				translate(0,-8);
				rotate(angle);
			}
			popMatrix();
		}
	}
}