/**
 * Copyright mousepancyo ( http://wonderfl.net/user/mousepancyo )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/gVOE
 */

/*
Load Imageボタンでローカルの画像を読み込んで、
画像の上に表示される赤いポイントを移動して画像を変形。
Save Imageボタンでローカルに保存します。
*/

package  {
    import flash.display.Sprite;
    import flash.display.Shape;
    import flash.display.BitmapData;
    import flash.display.Bitmap;
    import flash.events.Event;
    import flash.events.ProgressEvent;
    import flash.events.IOErrorEvent;
    import flash.display.Loader;
    import flash.net.URLRequest;
    import flash.net.FileReference;
    import flash.net.FileFilter;
    import flash.display.LoaderInfo;
    import flash.events.MouseEvent;
    import flash.utils.ByteArray;
    import flash.geom.Matrix
    import com.adobe.images.PNGEncoder;
    import com.bit101.components.*;
    import com.adobe.images.JPGEncoder;
    
    [SWF(width=465, height=465, backgroundColor=0, frameRate=30)]
    
    public class Main extends Sprite{
        private static const W:Number = 465
        private static const H:Number = 465
        //
        private var _vertices:Vector.<Number>;
        private var _indices:Vector.<int>;
        private var _uvData:Vector.<Number>;
        private var _pX:Vector.<Number>;
        private var _pY:Vector.<Number>;
        private var _dotList:Vector.<Dot>
        private var _bmd:BitmapData
        private var _saveBmd:BitmapData
        private var _shape:Shape;
        
        private var _loader:Loader
        private var _req:URLRequest
        private var _xLen:int = 8   
        private var _yLen:int = 6
        
        private var _fr:FileReference = new FileReference()
        
        private var _loadBtn:PushButton
        private var _saveBtn:PushButton

        public function Main() {
            addChild(new Base(0, W , H))
            _loadBtn = new PushButton(this, 130, 425, "Load Image", btnClick);
            _saveBtn = new PushButton(this, 260, 425, "Save Image", btnClick);
        }
        
        private function init():void{
            if(_shape != null){
                removeChild(_shape)
                _shape = null
            }
            if(_dotList != null){
                for(var i:int=0; i < _dotList.length; i++){
                    removeChild(_dotList[i])
                }
            }
            //
            _vertices = new Vector.<Number>()
            _indices = new Vector.<int>()
            _uvData = new Vector.<Number>()
            _pX = new Vector.<Number>()
            _pY = new Vector.<Number>()
            _dotList = new Vector.<Dot>()
        }
        
        private function btnClick(e:MouseEvent):void{
            switch(e.target){
                case _loadBtn:
                    fileBrowse()
                    break;
                case _saveBtn:
                    if(_shape != null){
                        createTriangles(_vertices, _indices, _uvData, false)
                        _saveBmd.draw(_shape)
                        fileSave(_saveBmd)
                    }
                    break;
            }
        }
        
        //LOAD
        private function fileBrowse():void{
            var imagesFilter:FileFilter = new FileFilter("Images", "*.jpg;*.gif;*.png");
            _fr.browse([imagesFilter])
            _fr.addEventListener(Event.SELECT, fileLoad)
        }
        private function fileLoad(e:Event):void{
            _fr.removeEventListener(Event.SELECT, fileLoad)
            //
            _fr.load()
            _fr.addEventListener(Event.OPEN, open)
            _fr.addEventListener(ProgressEvent.PROGRESS, progress)
            _fr.addEventListener(Event.COMPLETE, complete)
            _fr.addEventListener(IOErrorEvent.IO_ERROR, ioError)
            //
            function open(e:Event):void{
                //
            }
            function progress(e:ProgressEvent):void{
                //
            }
            function complete(e:Event):void{
                removedEventListener()
                addImage()
            }
            function ioError(e:IOErrorEvent):void{
                removedEventListener()
            }
            //
            function removedEventListener():void{
                _fr.removeEventListener(Event.OPEN, open)
                _fr.removeEventListener(ProgressEvent.PROGRESS, progress)
                _fr.removeEventListener(Event.COMPLETE, complete)
                _fr.removeEventListener(IOErrorEvent.IO_ERROR, ioError)
            }
        }
        
        private function addImage():void{
            var loader:Loader = new Loader();
            loader.loadBytes(_fr.data)
            loader.contentLoaderInfo.addEventListener(Event.INIT, init);
            //
            function init(e:Event):void{
                var r:Number = loader.width / loader.height;
                //
                if(r >= 1){
                    var m:Number = W / loader.width
                    _bmd = new BitmapData(W, H / r , true, 0)
                }else{
                    m = H / loader.height
                    _bmd = new BitmapData(W * r, H , true, 0)
                }
                _saveBmd = _bmd.clone()
                _bmd.draw(loader.content, new Matrix(m, 0, 0, m))
                //
                setUp()
            }
        }
        
        //SET UP
        private function setUp():void {
            init()
            _shape = new Shape()
            addChild(_shape)
            _shape.x = W / 2 - _bmd.width / 2
            _shape.y = H / 2 - _bmd.height / 2
            //
            setChildIndex(_loadBtn, numChildren-1)
            setChildIndex(_saveBtn, numChildren-1)
            //
            for (var i:int=0; i < _xLen; i++){
                for (var j:int=0; j < _xLen; j++){
                    _uvData.push(j / (_xLen-1), i / (_yLen-1));
                    _vertices.push(_bmd.width * j / (_xLen-1), _bmd.height * i / (_yLen-1));
                    _pX.push(_bmd.width * j / (_xLen-1) + W / 2 - _bmd.width / 2);
                    _pY.push(_bmd.height * i / (_yLen-1) + H / 2 - _bmd.height / 2);

                    if (i != (_yLen - 1) && j != (_xLen - 1)){
                        _indices.push(_xLen * i + j, _xLen * i + j + 1, _xLen * (i + 1) + j);
                        _indices.push(_xLen * i + j + 1, _xLen * (i + 1) + j, _xLen * (i + 1) + j + 1);
                    }
                }
            }
            //
            for (i=0; i < _xLen * _yLen; i++){
                var dot:Dot = new Dot()
                dot.x = _pX[i]
                dot.y = _pY[i]
                addChild(dot)
                _dotList.push(dot)
                _dotList[i].addEventListener(MouseEvent.MOUSE_DOWN, dragStart)
                _dotList[i].addEventListener(MouseEvent.MOUSE_UP, dragStop)
            }
            //
            createTriangles(_vertices, _indices, _uvData)    
        }
        
        private function dragStart(e:MouseEvent):void{
            e.target.clicked = true
            addEventListener(Event.ENTER_FRAME, update);
        }
        private function dragStop(e:MouseEvent):void{
            e.target.clicked = false
            removeEventListener(Event.ENTER_FRAME, update);
        }
        
        private function update(e:Event):void{
            for (var i:int=0; i < _dotList.length; i++){
                if(_dotList[i].clicked == true){
                    _dotList[i].x = mouseX
                    _dotList[i].y = mouseY
                }
            }
            //
            var nX:int= 0
            var nY:int= 0
            for (i=0; i < _vertices.length; i++){
                if(i%2 != 1){
                    if(nX<_dotList.length){
                        _vertices[i] = _dotList[nX].x - (W / 2 - _bmd.width / 2)
                        nX++
                    }
                }else{
                    if(nY<_dotList.length){
                        _vertices[i] = _dotList[nY].y - (H / 2 - _bmd.height / 2)
                        nY++
                    }
                }
                
            }
            createTriangles(_vertices, _indices, _uvData)    
        }
        
        private function createTriangles(ver:Vector.<Number>, ind:Vector.<int>, uv:Vector.<Number> ,line:Boolean = true, cull:String = "none"):void{
            _shape.graphics.clear();
            if(line == true) _shape.graphics.lineStyle(1, 0xFFFFFF, 0.5)
            _shape.graphics.beginBitmapFill(_bmd, null, true, true)
            _shape.graphics.drawTriangles(ver, ind, uv, cull)
            _shape.graphics.endFill()
        }
        
        //SAVE
        private function fileSave($bmd:BitmapData):void {
            var jpgEnc:JPGEncoder = new JPGEncoder(85)
            var jpg:ByteArray = jpgEnc.encode($bmd);
            _fr.addEventListener(Event.OPEN, open);
            _fr.addEventListener(ProgressEvent.PROGRESS, progress);
            _fr.addEventListener(Event.COMPLETE, complete);
            _fr.addEventListener(Event.CANCEL, cancel);
            _fr.addEventListener(Event.SELECT, select);
            _fr.addEventListener(IOErrorEvent.IO_ERROR, ioError);
            var date:Date = new Date  ;
            _fr.save(jpg, "export_image_" + date.getTime() + ".jpg");
            //
            function open(e:Event):void{
                //
            }
            function progress(e:ProgressEvent):void{
                //
            }
            function complete(e:Event):void{
                removedEventListener()
                createTriangles(_vertices, _indices, _uvData)
            }
            function cancel(e:Event):void{
                removedEventListener()
                createTriangles(_vertices, _indices, _uvData)
            }
            function select(e:Event):void{
                //
            }
            function ioError(e:IOErrorEvent):void{
                removedEventListener()
                createTriangles(_vertices, _indices, _uvData)
            }
            //
            function removedEventListener():void{
                _fr.removeEventListener(Event.OPEN, open)
                _fr.removeEventListener(ProgressEvent.PROGRESS, progress)
                _fr.removeEventListener(Event.COMPLETE, complete)
                _fr.removeEventListener(Event.CANCEL, cancel);
                _fr.removeEventListener(Event.SELECT, select);
                _fr.removeEventListener(IOErrorEvent.IO_ERROR, ioError)
            }
        }
    }
}


import flash.display.Sprite;
import flash.display.Shape;

class Dot extends Sprite{
    
    public var clicked:Boolean
    
    public function Dot(){
        var shape:Shape = new Shape()
        addChild(shape)
        shape.graphics.beginFill(0xFF0000, 0.5)
        shape.graphics.drawCircle(0,0,5)
        shape.graphics.endFill()
    }
}


//class Base
import flash.display.Sprite
import flash.display.Shape;
class Base extends Sprite{
    public function Base(color:int,w:int,h:int):void{
        var shape:Shape = new Shape()
        addChild(shape)
        shape.graphics.beginFill(color, 1)
        shape.graphics.drawRect(0,0,w,h)
        shape.graphics.endFill()
    }
}