/**
 * Copyright yd_niku ( http://wonderfl.net/user/yd_niku )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/gUCJ
 */

// forked from 9re's Wonderfl Tank Game Tank Sample 1
// forked from mash's ForwardMovingTank
package 
{
	// ai0
	import Box2D.Common.Math.b2Vec2;
	
	import flash.display.Bitmap;
	import flash.display.Loader;
	import flash.display.Sprite;
	import flash.display.BitmapData;
	import flash.events.Event;
	import flash.events.KeyboardEvent;
	import flash.events.TimerEvent;
	import flash.geom.ColorTransform;
	import flash.geom.Matrix;
	import flash.geom.Point;
	import flash.geom.Rectangle;
	import flash.net.URLRequest;
	import flash.system.Security;
	import flash.utils.setTimeout;
	import flash.utils.Timer;
	
	import net.wonderfl.game.infinity_tank.core.UserActionHandler;
	import net.wonderfl.game.infinity_tank.model.*;
	import net.wonderfl.game.infinity_tank.tank.TankBase;
	import net.wonderfl.utils.SequentialLoader;
	/**
	 * @author 9re
	 */
	public class Tank extends TankBase
	{
		private var _spTank:Sprite;
		private var _spBattery:Sprite;
		private var _ctfm:ColorTransform;
		private var _images:Vector.<Bitmap>;
		private var _gun:Bitmap;
		private var _arr:Array = [];
		private var _i:int = -1;
		private var _j:int = 0;
		private var _arrCommands:Array = [Command.FIRE, Command.GUN_TURN_LEFT, Command.GUN_TURN_RIGHT, Command.TANK_MOVE_BACKWARD, Command.TANK_MOVE_FORWARD, Command.TANK_TURN_LEFT, Command.TANK_TURN_RIGHT];
		private var _mat:Matrix = new Matrix(1, 0, 0, 1, 5, 15);
		
		public function Tank() 
		{
			_bulletRenderer = "http://swf.wonderfl.net/swf/usercode/8/8f/8faa/8faa6f4c1148ad9a535d25bdd49b7e4d98d02030.swf";
			
			_spTank = new Sprite;
			_spBattery = new Sprite;
			
			SequentialLoader.loadImages(["http://assets.wonderfl.net/images/tank/tankA_1.png", "http://assets.wonderfl.net/images/tank/tankA_2.png", "http://assets.wonderfl.net/images/tank/tankB_cannon.png"], _arr, onImageLoaded);
			
			_ctfm = new ColorTransform(1, 1, 1, 0);
		}
		
		private function onImageLoaded():void
		{
			_images = Vector.<Bitmap>(_arr.map(function ($ldr:Loader, $index:int, $arr:Array):Bitmap {
				var mat:Matrix = new Matrix;
				var bd:BitmapData = new BitmapData($ldr.width, $ldr.height, true, 0x00ffffff);
				bd.draw($ldr, mat);
				var bm:Bitmap = new Bitmap(bd);
				
				return bm;
			}));
			
			_gun = _images.pop();
			_gun.x = -5;
			
			_gun.y = -5;
			_spBattery.addChild(_gun);
			_spBattery.x = 20;
			_spBattery.y = 15;
			_i = 0;
			_images.forEach(function ($bm:Bitmap, $index:int, $vec:Vector.<Bitmap>):void {
				_spTank.addChild($bm);
			});
			_spTank.addChild(_spBattery);
		}
		
		override public function action():int
		{
			var action:int = Command.FIRE;
			action |= Command.TANK_MOVE_FORWARD;
			
			var enemyPos:b2Vec2 = _scene.enemyTankPosition;
			var myPos:b2Vec2 = _scene.myTankPosition;
			
			
			enemyPos.Subtract(myPos);
			var angle:Number = Math.atan2(enemyPos.y, enemyPos.x);
			angle -= (_scene.myGunAngle + _scene.myTankAngle);
			
			angle %= Math.PI * 2;
						
			if (angle > 0) action |= Command.GUN_TURN_RIGHT;
			else if (angle < 0) action |= Command.GUN_TURN_LEFT;
			
			angle += 3 * Math.PI / 2;
			angle %= Math.PI * 2;
			
			if (angle > 0) action |= Command.TANK_TURN_LEFT;
			else if (angle < 0) action |= Command.TANK_TURN_RIGHT;
			
			return action;
		}
		
		override public function draw(bitmapData:BitmapData):void
		{
			_spBattery.rotation = _scene.myGunAngle * 180 / Math.PI;
					
			if (_i > -1) {
				_i = (_j & 1) ? 1 : 0;
				var bm:Bitmap = _images[_i];
				bm.visible = true;
				_i = 1 - _i;
				bm = _images[_i];
				bm.visible = false;
				_j++;
				_j &= 3;
			}
			bitmapData.colorTransform(bitmapData.rect, _ctfm);
			bitmapData.draw(_spTank, _mat, null, null, null, true);
		}
		
		// called when a bullet hits this tank
		override public function hit():void {
			
		}

	}
}