/**
 * Copyright nitoyon ( http://wonderfl.net/user/nitoyon )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/gUC0
 */

// Glowing Hellow World.
//-------------------------------------------------------
// An experiment on creating a dynamic glow text effect.
// You can edit the text!!!

package{
import flash.display.*;
import flash.events.Event;
import flash.filters.GlowFilter;
import flash.geom.*;
import flash.text.*;

[SWF(backgroundColor="#000000", width="450", height="80")]
public class GlowingHelloWorld extends Sprite{
    public function GlowingHelloWorld(){
        stage.scaleMode = "noScale";
        var ptZero:Point = new Point();

        // initialize canvas.
        var bmp:Bitmap = addChild(new Bitmap()) as Bitmap;

        // Show original text (input)
        var text:TextField = new TextField();
        text.autoSize = "left";
        text.type = "input";
        text.htmlText = <font size="50" color="#ffffff">HELLO WORLD</font>.toXMLString();
        addChild(text);
        text.addEventListener("change", function(event:Event):void{ updateGlow() });

        // Create a glow BitmapData.
        var bmdGlow:BitmapData, bmdCanvas:BitmapData;
        var updateGlow:Function = function():void{
            // dispose existing BitmapData.
            if (bmdGlow) bmdGlow.dispose();

            // Glow it.
            bmdGlow = new BitmapData(text.textWidth + 10, text.textHeight + 10, true, 0);;
            bmdGlow.draw(text);
            var glow:GlowFilter = new GlowFilter(0xffffff, .9, 8, 8, 4);
            bmdGlow.applyFilter(bmdGlow, bmdGlow.rect, ptZero, glow);

            // Update canvas BitmapData.
            bmdCanvas = new BitmapData(bmdGlow.width, bmdGlow.height, true, 0xff000000);
            bmp.bitmapData = bmdCanvas;
        }
        updateGlow();

        // Create a mask sprite.
        var msk:Sprite = new Sprite();
        msk.graphics.beginGradientFill("radial", [0xffffff, 0xffffff], [1, 0], [64, 255]);
        msk.graphics.drawCircle(0, 0, 100);
        msk.graphics.endFill();

        // Create a mask BitmapData using mask sprite.
        var bmdMask:BitmapData = new BitmapData(200, 200, true, 0x0);
        var mtx:Matrix = new Matrix();
        mtx.translate(100, 100);
        bmdMask.draw(msk, mtx);

        // Start animation loop.
        var counter:int = 0;
        var mskY:Number = 100 - text.textHeight / 2;
        addEventListener("enterFrame", function(event:Event):void{
            // Clear the canvas.
            bmdCanvas.fillRect(bmdCanvas.rect, 0xff000000);

            // Copy glow BitmapData using bmdMask as a alpha source.
            // Don't forget to set 'mergeAlpha' property true.
            bmdCanvas.copyPixels(bmdGlow, bmdGlow.rect, ptZero, 
                bmdMask,                            // alphaBitmap
                new Point(100 - counter, mskY),     // alphaPoint
                true                                // mergeAlpha
            );

            // update counter...
            counter += 14;
            if (counter > 800){
                counter = -10;
            }
        });
    }
}
}