/**
 * Copyright umhr ( http://wonderfl.net/user/umhr )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/gTqt
 */

/*
 * Picasaから簡単に画像を取ってこれるようにしたかったので。
 * 
 * Picasa Web Albums query parameters reference
 * http://code.google.com/intl/ja/apis/picasaweb/docs/2.0/reference.html#Parameters
 * 
 * */
package {
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.filters.BlurFilter;
    import flash.utils.Dictionary;
    import org.libspark.betweenas3.BetweenAS3;
    import org.libspark.betweenas3.easing.*;
    import org.libspark.betweenas3.tweens.ITween;
    import flash.filters.DropShadowFilter;
    import flash.geom.Vector3D;
    //import net.hires.debug.Stats;
    /**
     * ...
     * @author umhr
     */
    [SWF(width = 465, height = 465, backgroundColor = 0x000000, frameRate = 30)]
    public class MainDNA3 extends Sprite {
        private var _axis:Sprite;
        private var _canvas:Sprite;
        private var _paint:Sprite;
        private var _source:Source;
        private var _dic:Dictionary;
        private var _t:ITween;
        private var _isDown:Boolean;
        private var _axisProxy:Object;
        private var _countDown:int;
        private var _stageWidth:Number;
        private var _stageHeight:Number;
        private var _gradientShape:GradientShape;
        
        public function MainDNA3():void {
            //trace(this.loaderInfo.url);
            stage.scaleMode = "noScale";
            stage.align = "TL";
            
            _isDown = false;
            
            _stageWidth = stage.stageWidth;
            _stageHeight = stage.stageHeight;
            
            _gradientShape = new GradientShape(_stageWidth, _stageHeight);
            
            //this.addChild(new Stats());
            _gradientShape.draw();
            this.addChild(_gradientShape);
            
            _source = new Source();
            _source.addEventListener(Event.COMPLETE, onComp);
            _source.load("tokyo", 80);
        }
        
        private function onComp(event:Event):void {
            //this.addChild(_source.sprites[0]);
            _axis = new Sprite();
            _axisProxy = new Object();
            _canvas = new Sprite();
            _paint = new Sprite();
            _dic = new Dictionary();
            _countDown = 200;
            _axisProxy["z"] = 20000;
            var n:int = _source.proxy.length;
            for (var i:int = 0; i < n; i++) {
                _source.proxy[i].x = (i - n / 2) * 300;
                _source.proxy[i].y = Math.sin(((i - n / 2) / n) * 8 * Math.PI) * 600 * (i % 2 - 0.5) * -2;
                _source.proxy[i].z = Math.cos(((i - n / 2) / n) * 8 * Math.PI) * 600 * (i % 2 - 0.5) * -2;
                _axis.addChild(_source.proxy[i]);
                _dic[_source.sprites[i]] = i;
                _canvas.addChild(_source.sprites[i]);
            }
            _axis.x = stage.stageWidth / 2;
            _axis.y = stage.stageHeight / 2;
            _axis.z = _axisProxy.z;
            //_axis.rotationX = 45;
            this.addChild(_axis);
            this.addChild(_paint);
            this.addChild(_canvas);
            //onUpdate();
            animation();
        }
        
        private function animation():void {
            this.addEventListener(Event.ENTER_FRAME, atEnter);
            this.addEventListener(MouseEvent.MOUSE_DOWN, atDown);
        }
        private function atEnter(event:Event):void {
            _countDown ++;
            if (_countDown > 350) {
                atDown(null, int(_source.proxy.length * Math.random()));
            }
            
            if(_isDown){
                _axis.rotationX += (this.mouseY - stage.stageHeight) / 1000;
                _axis.rotationY += (this.mouseX - stage.stageWidth) / 3000;
                _axis.rotationZ += 0.1;
                _axis.x = stage.stageWidth / 2 + Math.sin(_axis.rotationY / 50) * 800;
                _axis.y = stage.stageHeight / 2 + Math.sin(_axis.rotationY / 25) * 200;
                _axis.z = _axisProxy.z + Math.sin(_axis.rotationY / 50) * 800;
            }else {
                //_axis.rotationZ += 0.3;
                _axis.rotationX += 0.3;
            }
            _gradientShape.draw(_axis.rotationZ + _axis.rotationY);
            onUpdate();
        }
        private function atDown(event:Event = null, num:int = 0):void {
            if (!_isDown) {
                var t:ITween;
                t = BetweenAS3.tween(_axisProxy, { z:4000 }, null, 2, Back.easeInOut);
                t.play();
            }
            _countDown = event? -500:0;
            _isDown = true;
            var selectNum:int = event?_dic[event.target]:num;
            
            var tweens:Array = [];
            
            var n:int = _source.proxy.length;
            for (var i:int = 0; i < n; i++) {
                _source.sprites[i].getChildAt(1).visible = false;
                var ny:Number = Math.sin(((i - n / 2) / n) * 8 * Math.PI) * 600 * (i % 2 - 0.5) * -2;
                var nz:Number = Math.cos(((i - n / 2) / n) * 8 * Math.PI) * 600 * (i % 2 - 0.5) * -2;
                if(i == selectNum){
                    tweens.push(
                        BetweenAS3.serial(
                            BetweenAS3.tween(_source.proxy[i], { y:0, z:0 }, null, 0.5, Sine.easeOut),
                            BetweenAS3.func(
                                function():void {
                                    _source.sprites[selectNum].getChildAt(0).visible = false;
                                    _source.sprites[selectNum].getChildAt(1).visible = true;
                                }
                            )
                        )
                    );
                    
                }else {
                    var time:Number = 1;
                    if (Math.abs(i - selectNum) < 3 + selectNum % 3) {
                        ny *= 0.15;
                        nz *= 0.15;
                        time = 5;
                    }
                    tweens.push(
                        BetweenAS3.serial(
                            BetweenAS3.delay(BetweenAS3.tween(_source.proxy[i], { y:0, z:0 }, null, time*0.3+Math.abs(selectNum-i)*0.01, Back.easeIn),Math.abs(selectNum-i)*0.01),
                            BetweenAS3.tween(_source.proxy[i], { y:ny * 5, z:nz * 5 }, null, time * 2 + Math.abs(selectNum - i) * 0.1, Back.easeOut)
                        )
                    );
                }
                tweens.push(BetweenAS3.tween(_source.proxy[i], { x:(i - n / 2 - (selectNum - n / 2)) * 200 }, null, 3, Back.easeInOut));
            }
            if (_t != null) {
                _t.stop();
            }
            _t = BetweenAS3.parallelTweens(tweens);
            //_t.onComplete = function():void { trace("hoge",selectNum)};
            _t.play();
        }
        private function onUpdate():void {
            var n:int = _source.proxy.length;
            var zArray:Array = [];
            var positions:Array = [];
            for (var i:int = 0; i < n; i++) {
                var poz:Vector3D = _source.proxy[i].transform.getRelativeMatrix3D(_canvas).position;
                zArray[i] = poz.z;
                positions[i] = poz;
//                _source.sprites[i].z = poz.z;
            }
            
            var sortter:Array = zArray.sort(Array.NUMERIC | Array.RETURNINDEXEDARRAY);
            
            for (i = 0; i < n; i++) {
                var j:int = sortter[i];
                var per:Number = 1000 / (1000 + zArray[j]);
                if (per < 0.01 || 1 < per) {
                    _source.sprites[j].visible = false;
                    continue;
                }else {
                    _source.sprites[j].visible = true;
                }
                if (0.15 < per && per <0.3) {
                    _source.sprites[j].filters = [];
                }else {
                    _source.sprites[j].filters = [new BlurFilter()];
                }
                _source.sprites[j].scaleX = _source.sprites[j].scaleY = per;
                _source.sprites[j].x = positions[j].x * per + _stageWidth / 2;
                _source.sprites[j].y = positions[j].y * per + _stageHeight / 2;
                _canvas.addChildAt(_source.sprites[j], 0);
            }
            
//            Utils2.zSort2(_canvas);
        }
    }
}

import flash.display.GradientType;
import flash.display.Shape;
import flash.geom.Matrix;
class GradientShape extends Shape {
    private var _matrix:Matrix = new Matrix();
    private var _width:int;
    private var _height:int;
    private var _r:Number;
    private var _tx:Number;
    private var _ty:Number;
    public function GradientShape(width:int = 465, height:int = 465) {
        _width = width;
        _height = height;
        var w:Number = _width * 0.5;
        var h:Number = _height * 0.5;
        var r:Number = Math.sqrt(w * w + h * h);
        _r = r * 2;
        _tx = (_width - _r) * 0.5;
        _ty = (_height - _r) * 0.5;
        //init();
    }
    public function draw(rotation:Number = 0):void {
        var radian:Number = (rotation + 90) * Math.PI / 180;
        _matrix.createGradientBox(_r, _r, radian, _tx, _ty);
        //_matrix.createGradientBox(_width, _height, radian);
        
        this.graphics.clear();
        this.graphics.beginGradientFill(GradientType.LINEAR, [0x000000, 0x330000, 0x000000], [1, 1, 1], [0,128, 255], _matrix);
        this.graphics.drawRect(0, 0, _width, _height);
        this.graphics.endFill();
    }
    
}


import flash.display.Bitmap;
import flash.display.BitmapData;
import flash.display.Sprite;
import flash.events.Event;
import flash.events.IOErrorEvent;
import flash.filters.DropShadowFilter;
import flash.geom.Rectangle;
import flash.text.TextField;
import flash.text.TextFormat;
import flash.geom.Matrix;
class Source {
    private var _photos:PicasaPhotos;
    public var sprites:Array;
    public var proxy:Array;
    
    private var _complete:Function = function(event:Event):void { };
    private var _ioError:Function = function(event:Event):void { };
    
    public function Source() { };
    
    public function addEventListener(type:String, listener:Function):void {
        this["_" + type] = listener;
    }
    public function load(keyword:String = "", num:int = 3, width:int = 320, height:int = 240, quality:String = "middle"):void {
        _photos = new PicasaPhotos();
        _photos.addEventListener(Event.COMPLETE, onComplete);
        _photos.addEventListener(IOErrorEvent.IO_ERROR, function(event:Event):void { trace("無いよ") } );
        _photos.load( { q:keyword, "max-results":num, imgmax:"128", imgor:"landscape" } );
    }
    private function onComplete(event:Event):void {
        sprites = [];
        proxy = [];
        var n:int = _photos.loader.items.length;
        for (var i:int = 0; i < n; i++) {
            
            var bitmapData:BitmapData = new BitmapData(220, 220, true, 0x000000);
            var temp:Bitmap = _photos.loader.getBitmap(String(i));
            var b:Number = Math.max(220 / temp.width, 220 / temp.height);
            
            var bg:Sprite = new Sprite();
            bg.graphics.beginBitmapFill(_photos.loader.getBitmapData(String(i)), new Matrix(b, 0, 0, b),false,false);
            bg.graphics.drawCircle(110, 110, 110);
            bg.graphics.endFill();
            bitmapData.draw(bg);
            
            var bitmap:Bitmap = new Bitmap(bitmapData, "auto", true);
            bitmap.x = -bitmap.width / 2;
            bitmap.y = -bitmap.height / 2;
            var sp:Sprite = new Sprite();
            sp.addChild(bitmap);
            
            b *= 2;
            var data:Sprite = new Sprite();
            var dataBitmap:Bitmap = _photos.loader.getBitmap(String(i));
            data.graphics.beginBitmapFill(_photos.loader.getBitmapData(String(i)), new Matrix(b, 0, 0, b, -dataBitmap.width*b/2, -dataBitmap.height*b/2),false,true);
            data.graphics.drawRect( -dataBitmap.width*b / 2, -dataBitmap.height*b / 2, dataBitmap.width*b, dataBitmap.height*b);
            data.graphics.endFill();
            data.mouseEnabled = false;
            data.visible = false;
            var tf:TextField = new TextField();
            tf.defaultTextFormat = new TextFormat("_sans", 42);
            tf.text = "Photo by " + _photos.credits[i];
            tf.textColor = 0xFFFFFF;
            tf.autoSize = "left";
            tf.mouseEnabled = false;
            tf.selectable = false;
            tf.x = -data.width/2;
            tf.y = data.height / 2;
            //tf.filters = [new DropShadowFilter(0)];
            
            data.addChild(tf);
            
            sp.addChild(data);
            sprites.push(sp);
            proxy.push(new Sprite());
        }
        _complete(event);
    }
}


    /**
     * ...
     * @author umhr
     */
    import flash.events.Event;
    import flash.system.LoaderContext;
    import flash.system.Security;
    class PicasaPhotos {
        public var xmlLoader:MultiLoader;
        public var loader:MultiLoader;
        public var credits:Array = [];
        private var _complete:Function = function(event:Event):void{};
        private var _ioError:Function = function(event:Event):void{};
        public function PicasaPhotos() {
            Security.loadPolicyFile("http://photos.googleapis.com/data/crossdomain.xml");
            xmlLoader = new MultiLoader("xml");
            loader = new MultiLoader("photos");
        }
        public function addEventListener(type:String, listener:Function):void {
            this["_" + type] = listener;
        }
        public function load(props:Object = null):void {
            var defaultProps:Object = { "max-results":3, imgmax:"320", imglic:"creative_commons", kind:"photo", "start-index":"1"};
            
            var xmlURL:String = "http://photos.googleapis.com/data/feed/base/all?alt=rss";
            
            var p:String;
            for (p in props) {
                defaultProps[p] = props[p];
            }
            
            for (p in defaultProps) {
                xmlURL += "&" + p + "=" + encodeURIComponent(decodeURIComponent(defaultProps[p]));
            }
            xmlLoader.add(xmlURL, { id:"xml", type:"text" } );
            xmlLoader.addEventListener(Event.COMPLETE, loadIMG);
            xmlLoader.start();
        }
        private function loadIMG(event:Event):void {
            var myXML:XML = xmlLoader.getXML("xml");
            default xml namespace = new Namespace("http://search.yahoo.com/mrss/"); 
            var n:int = myXML.channel.item.length();
            if (n == 0) {
                atIoError(null);
                return;
            }
            for (var i:int = 0; i < n; i++) {
                var url:String = myXML.channel.item[i].group.content.@url;
                loader.add(url, { context:new LoaderContext(true), id:String(credits.length), type:"image" } );
                credits.push(myXML.channel.item[i].group.credit);
                trace(url, myXML.channel.item[i].group.credit);
            }
            loader.addEventListener(Event.COMPLETE, atComp);
            loader.start();
        }
        private function atIoError(event:Event):void {
            _ioError(event);
        }
        private function atComp(event:Event):void {
            _complete(event);
        }
    }


    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Loader;
    import flash.events.Event;
    import flash.events.IOErrorEvent;
    import flash.net.URLLoader;
    import flash.net.URLLoaderDataFormat;
    import flash.net.URLRequest;
    import flash.system.LoaderContext;
    import flash.system.Security;
    import flash.utils.Dictionary;
    import flash.utils.ByteArray;
    import flash.utils.getQualifiedClassName;
    import flash.display.MovieClip;
    class MultiLoader{
        public static var IMAGE_EXTENSIONS:Array = ["swf", "jpg", "jpeg", "gif", "png"];
        public static var TEXT_EXTENSIONS:Array = ["txt", "js", "xml", "php", "asp"];
        public static const COMPLETE:String = "complete";
        private var _listener:Function = function(event:Event):void{};
        private var _loads:Dictionary;
        private var _keyFromId:Dictionary;
        private var _loadCount:int;
        private var _itemsLoaded:int;
        public var items:Array;
        private var _binaryLoads:Dictionary = new Dictionary();
        public function MultiLoader(name:String = ""){
            _loads = new Dictionary();
            _keyFromId = new Dictionary();
            _itemsLoaded = 0;
            items = [];
        }
        public function add(url:String, props:Object = null):void {    
            var loadingItem:LoadingItem = new LoadingItem();
            loadingItem.url = url;
            loadingItem.type = getType(url, props);
            if(props){
                if(props.context){
                    loadingItem.context = props.context;
                }
                if (props.id) {
                    _keyFromId[props.id] = url;
                }
                if (props.preventCache) {
                    loadingItem.preventCache = props.preventCache;
                }
            }
            items.push(loadingItem); 
        }
        private function getType(url:String, props:Object = null):String{
            var result:String = "";
            if (props && props.type) {
                return props.type;
            }
            var i:int;
            var extension:String;
            var n:int = IMAGE_EXTENSIONS.length;
            for (i = 0; i < n; i++) {
                extension = IMAGE_EXTENSIONS[i];
                if(extension == url.substr(-extension.length).toLowerCase()){
                    result = "image";
                    break;
                }
            }
            if(result == ""){
                n = TEXT_EXTENSIONS.length;
                for (i = 0; i < n; i++) {
                    extension = TEXT_EXTENSIONS[i];
                    if(extension == url.substr(-extension.length).toLowerCase()){
                        result = "text";
                        break;
                    }
                }
            }
            return result;
        }
        
        public function start():void{
            var n:int = items.length;
            for (var i:int = 0; i < n; i++) {
                var type:String = items[i].type;
                var url:String = items[i].url;
                url += (items[i].preventCache)?"?rand=" + Math.random():"";
                var uRLRequest:URLRequest = new URLRequest(url);
                if(type == "image"){
                    _loads[items[i].url] = loadImage(uRLRequest, items[i].context);
                }else if(type == "text"){
                    _loads[items[i].url] = loadText(uRLRequest);
                }else if (type == "byteImage") {
                    byteImage(uRLRequest, items[i].context);
                }else if(type == "binary"){
                    _loads[items[i].url] = loadBinary(uRLRequest);
                }
            }
        }
        public function addEventListener(type:String,listener:Function):void{
            _listener = listener;
        }
        public function getBitmap(key:String):Bitmap{
            key = keyMatching(key);
            var bitmap:Bitmap;
            try{
                if (getQualifiedClassName(_loads[key].content) == "flash.display::MovieClip") {
                    var mc:MovieClip = _loads[key].content;
                    var bitmapData:BitmapData = new BitmapData(mc.width, mc.height);
                    bitmapData.draw(mc);
                    bitmap = new Bitmap(bitmapData);
                }else {
                    bitmap = _loads[key].content;
                }
            }catch (e:*) {
                //type == "binary"の場合
                if(_binaryLoads[key]){
                    bitmap = _binaryLoads[key].content;
                }
                //bitmap = new Bitmap();
            }
            return bitmap;
        }
        public function getBitmapData(key:String):BitmapData{
            key = keyMatching(key);
            var bitmap:Bitmap = getBitmap(key);
            var bitmapData:BitmapData = new BitmapData(bitmap.width, bitmap.height);
            bitmapData.draw(bitmap);
            return bitmapData;
        }
        private function loadImage(url:URLRequest, context:LoaderContext = null):Loader {
            var loader:Loader = new Loader();
            loader.contentLoaderInfo.addEventListener(Event.COMPLETE, onComp);
            loader.load(url, context);
            return loader;
        }
        private function byteImage(url:URLRequest, context:LoaderContext = null):void {
            var loader:Loader = new Loader();
            loader.contentLoaderInfo.addEventListener(Event.COMPLETE, loadBytes);
            loader.load(url, context);
            function loadBytes(event:Event):void {
                _loads[url.url] = new Loader();
                _loads[url.url].contentLoaderInfo.addEventListener(Event.COMPLETE, onComp);
                _loads[url.url].loadBytes(event.target.bytes);
            }
        }
        public function getBinary(key:String):ByteArray {
            var byteArray:ByteArray;
            try {
                byteArray = _loads[keyMatching(key)].contentLoaderInfo.bytes;
            }catch (e:*) {
                //type == "binary"の場合
                byteArray = _loads[keyMatching(key)].data;
            }
            
            return byteArray;
        }
        
        public function getText(key:String):String {
            key = keyMatching(key);
            return key?_loads[key].data:key;
        }
        public function getXML(key:String):XML {
            return new XML(getText(key));
        }
        private function keyMatching(key:String):String {
            return _loads[key]?key:_keyFromId[key];
        }
        private function loadText(url:URLRequest):URLLoader{
            var loader:URLLoader = new URLLoader();
            loader.addEventListener(Event.COMPLETE, onComp);
            loader.load(url);
            return loader;
        }
        private function loadBinary(url:URLRequest):URLLoader{
            var loader:URLLoader = new URLLoader();
            loader.addEventListener(Event.COMPLETE, loadBytes);
            loader.dataFormat = "binary";
            loader.load(url);
            return loader;
            function loadBytes(event:Event):void {
                _binaryLoads[url.url] = new Loader();
                _binaryLoads[url.url].contentLoaderInfo.addEventListener(Event.COMPLETE, onComp);
                _binaryLoads[url.url].loadBytes(event.target.data);
            }
        }
        private function onComp(event:Event):void {
            _itemsLoaded ++;
            if (_itemsLoaded == items.length) {
                _itemsLoaded = 0;
                _listener(event);
            }
        }
        public function get itemsTotal():int{
            return items.length;
        }
        public function get itemsLoaded():int{
            return _itemsLoaded;
        }
        public function get loadedRatio():Number {
            return _itemsLoaded / items.length;
        }
    }


import flash.net.URLRequest;
import flash.system.LoaderContext;
class LoadingItem{
    public var url:String;
    public var preventCache:Boolean;
    public var type:String;
    public var status:String;
    public var context:LoaderContext;
    public function LoadingItem(){};
}
