/**
 * Copyright raa ( http://wonderfl.net/user/raa )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/gTFI
 */

// forked from 0xABCDEF's game

package {
    import flash.display.Sprite;
    public class Game extends Sprite {
        public function Game() {
            var player: Player = new Player();
            addChild(player);
            var monster: Monster = new Monster();
            monster.x = 400;
            monster.player = player;
            player.monster = monster;
            addChild(monster);
            var healthBar: HealthBar = new HealthBar();
            healthBar.color = 0;
            healthBar.x = 125;
            healthBar.y = 350;
            healthBar.render(player.health);
            player.healthBar = healthBar;
            addChild(healthBar);
            var monsterHealthBar: HealthBar = new HealthBar();
            monsterHealthBar.color = 0xff0000;
            monsterHealthBar.x = 125;
            monsterHealthBar.y = 375;
            monsterHealthBar.render(monster.health);
            monster.healthBar = monsterHealthBar;
            addChild(monsterHealthBar);
        }
    }
}

import flash.display.Sprite;
import flash.events.Event;
import flash.events.MouseEvent;
class Player extends Sprite {
    public var b: int;
    public var health: Number;
    public var monster: Monster;
    public var healthBar: HealthBar;
    public function Player(){
        health = 100;
        b = 0;
        graphics.beginFill(0);
        graphics.drawRect(0, 0, 30, 30);
        this.addEventListener(MouseEvent.MOUSE_DOWN, MOUSE_DOWN);
        this.addEventListener(Event.ENTER_FRAME, ENTER_FRAME);
    }
    public function MOUSE_DOWN(e:MouseEvent):void {
        var self: Player = this;
        self.startDrag();
        stage.addEventListener(MouseEvent.MOUSE_UP, function (e: MouseEvent):void {
            self.stopDrag();
            stage.removeEventListener(MouseEvent.MOUSE_UP, arguments.callee);
        });
    }
    public function ENTER_FRAME(e: Event): void {
        b++;
        if (b > 1) {
            shot();
            b = 0;
        }

    }
    public function shot(): void {
        var bullet: Bullet = new Bullet;
        bullet.monster = this.monster;
        bullet.x = this.x;
        bullet.y = this.y;
        this.parent.addChild(bullet);
    }
    public function hit(): void {
        this.health -= 2;
        this.healthBar.render(this.health);
        if (this.health < 0) {
            destory();
        }

    }
    public function destory(): void {
        this.removeEventListener(Event.ENTER_FRAME, ENTER_FRAME);
        this.removeEventListener(MouseEvent.MOUSE_DOWN, MOUSE_DOWN);
        this.healthBar.parent.removeChild(this.healthBar);
        this.parent.removeChild(this);
    }

}

class Bullet extends Sprite {
    public var spd: int;
    public var monster: Monster;
    public function Bullet() {
        spd = 0;
        graphics.beginFill(0);
        graphics.drawRect(0, 0, 15, 5);
        this.addEventListener(Event.ENTER_FRAME, ENTER_FRAME);
    }
    public function ENTER_FRAME(e: Event): void {
        spd++;
        this.x += spd;
        if (this.x > stage.stageWidth) {
            this.destory();
        }
        if (this.hitTestObject(monster)) {
            monster.hit();
            this.destory();
        }
    }
    public function destory(): void {
        this.parent.removeChild(this);
        this.removeEventListener(Event.ENTER_FRAME, arguments.callee);
    }
}

class Monster extends Sprite {
    public var b: int;
    public var player: Player;
    public var basey:Number;
    public var s:Number;
    public var t:Number;
    public var health: Number;
    public var healthBar: HealthBar;
    public function Monster() {
        b = 0;
        basey = 200;
        s = 50;
        t = 0;
        health = 100;
        graphics.beginFill(0xff0000);
        graphics.drawRect(0, 0, 50, 50);
        addEventListener(Event.ENTER_FRAME, ENTER_FRAME);
    }
    public function hit(): void {
        this.health -= 1;
        this.healthBar.render(this.health);
        if (this.health < 0) {
            this.parent.removeChild(this);
            this.healthBar.parent.removeChild(this.healthBar);
            this.removeEventListener(Event.ENTER_FRAME, ENTER_FRAME);
        }

    }
    public function ENTER_FRAME(e: Event): void {
        t += 0.2;
        this.y = Math.sin(t) * s + basey;
        b++;
        if (b > 5) {
            shot();
            b = 0;
        }
    }
    public function shot(): void {
        var bullet: MonsterBullet = new MonsterBullet;
        bullet.player = this.player;
        bullet.x = this.x;
        bullet.y = this.y;
        this.parent.addChild(bullet);
    }
}

class MonsterBullet extends Sprite {
    public var spd: int;
    public var player: Player;
    public function MonsterBullet() {
        spd = 0;
        graphics.beginFill(0xff0000);
        graphics.drawRect(0, 0, 15, 5);
        this.addEventListener(Event.ENTER_FRAME, ENTER_FRAME);
    }
    public function ENTER_FRAME(e: Event): void {
        spd++;
        this.x -= spd;
        if (this.x > stage.stageWidth) {
            this.destory();
        }
        if (this.hitTestObject(player)) {
            player.hit();
            this.destory();
        }
    }
    public function destory(): void {
        this.parent.removeChild(this);
        this.removeEventListener(Event.ENTER_FRAME, arguments.callee);
    }
}


class HealthBar extends Sprite {
    public var color: uint;
    public function HealthBar() {
    }
    public function render(size:Number):void {
        graphics.clear();
        graphics.beginFill(color);
        graphics.drawRect(0, 0, size * 2, 3);
    }

}




