/**
 * Copyright n.otsu1029 ( http://wonderfl.net/user/n.otsu1029 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/gT43
 */

// forked from nappingjellyfish's Plane Wave
package  
{
    /******************************
     * 波っぽい物
     * ****************************/
    
    
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.BitmapDataChannel;
    import flash.display.Graphics;
    import flash.display.Loader;
    import flash.display.MovieClip;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.filters.BitmapFilter;
    import flash.filters.DisplacementMapFilter;
    import flash.filters.DisplacementMapFilterMode;
    import flash.geom.Matrix;
    import flash.geom.Point;
    import flash.net.URLRequest;
    
    /**
     * ...
     * @author Njf
     */
    public class DocRoot extends MovieClip
    {
        public static const IMG_URL:String = "http://assets.wonderfl.net/images/related_images/d/d5/d580/d5802adc22b8a82d34624e52e3b4bda58e4abb1c";
        public var myLoader:Loader = new Loader();
        private static const STAGE_X:int = 465;
        private static const STAGE_Y:int = 465;
        private static const MESH_INTERVAL:int = 30;
        private static const AMPLITUDE:int = 10;
        private var baseSp:Sprite = new Sprite();
        private var gradSp:Sprite = new Sprite();
        private var bdfb:LinearGrad;
        /****************
         * コンストラクタ
         * **************/
        public function DocRoot() 
        {
            super();
            init();
        }
        
        
        /****************
         * 初期化
         * **************/
        private function init():void 
        {
            addChild(baseSp);
            //addChild(gradSp);
            
            bdfb = new LinearGrad();
            bdfb.initData(STAGE_X, STAGE_Y);
            bdfb.makeGradData();
            loadImg();
            mesh();
            addEventListener(Event.ENTER_FRAME, onEnterFrameHaneler);
        }
        /****************
          * On enter Frame
          * **************/
         private function onEnterFrameHaneler(e:Event):void 
         {

             var filter:BitmapFilter = getBitmapFilter(createBitMapData(), 0,0,AMPLITUDE);
            filters = [ filter ];
         }
        
        
        
        
        /****************
         * ビットマップ作成
         * **************/
        private function createBitMapData():BitmapData
        {
            var bitMapData:BitmapData = new BitmapData(STAGE_X, STAGE_Y, true, 0x007777);
            bdfb.frmCnt++;
            bdfb.makeGradient(gradSp);
            bitMapData.draw(gradSp);
            
            
            return(bitMapData);
        }
        /****************
         * フィルター作成
         * **************/
        private function getBitmapFilter(bmpData:BitmapData,mapPointX:int,mapPointY:int,scale:int):BitmapFilter {
            
            var mapBitmap:BitmapData = bmpData;
            var mapPoint:Point       = new Point(mapPointX, mapPointY);
            var componentX:uint      = BitmapDataChannel.BLUE;
            var componentY:uint      = BitmapDataChannel.BLUE;
            var scaleX:Number        = scale;
            var scaleY:Number        = scale;
            var mode:String          = DisplacementMapFilterMode.CLAMP;
            var color:uint           = 0;
            var alpha:Number         = 0;
            return new DisplacementMapFilter(mapBitmap,
                                             mapPoint,
                                             componentX,
                                             componentY,
                                             scaleX,
                                             scaleY,
                                             mode,
                                             color,
                                             alpha);
        }
         
         
         /****************
          * image load
          * **************/
        private function loadImg():void {
            var myRequest:URLRequest = new URLRequest(IMG_URL);
            myLoader.load(myRequest);
            myLoader.contentLoaderInfo.addEventListener(Event.COMPLETE, onImgLoaded);
            addChild(myLoader);
        }
         /****************
          * load complete
          * **************/
         private function onImgLoaded(e:Event):void 
         {
            myLoader.x = STAGE_X / 2 - myLoader.width / 2;
            myLoader.y = STAGE_Y / 2 - myLoader.height / 2;
         }
        /****************
         * 方眼
         * **************/
        private function mesh():void 
        {
            var i:int = 0;
            var pitchX:int = STAGE_X / MESH_INTERVAL + 1;
            var pitchY:int = STAGE_Y / MESH_INTERVAL + 1;
            
            with(baseSp.graphics){
                lineStyle(1,0xA0A0A0);
                for ( i = 0; i < pitchX; i++) 
                {
                    moveTo(i * MESH_INTERVAL, 0);
                    lineTo(i * MESH_INTERVAL, STAGE_Y);
                }
                for ( i = 0; i < pitchY; i++) 
                {
                    moveTo(0,i * MESH_INTERVAL);
                    lineTo(STAGE_X,i * MESH_INTERVAL);
                }
            }
            
        }

         
         
    }


}//package end
import flash.display.GradientType;
import flash.display.SpreadMethod;
import flash.display.Sprite;
import flash.geom.Matrix;
/**
 * ...
 */
class LinearGrad
{
    private var gradData:GradData = new GradData();
    public var frmCnt:int = 0;
    private var mapSizeX:int = 0;
    private var mapSizeY:int = 0;
    
    /****************
     * コンストラクタ
     * **************/
    public function LinearGrad() 
    {

    }
    /****************
     * 変数初期化
     * **************/
    public function initData(mapSizeX:int,mapSizeY:int):void 
    {
        this.mapSizeX = mapSizeX;
        this.mapSizeY = mapSizeY;
    }
    
    
    /****************
     * gradient
     * **************/
    public function makeGradient(gradSp:Sprite):void 
    {
        var fillType:String = GradientType.LINEAR;
        var matr:Matrix = new Matrix();
        var rot:Number = Math.PI / 4;
        var gradboxSize:int = 50;
        var vel:Number = 3;

        var period:Number = gradboxSize * 2  / Math.cos(rot);
        
        var tx:Number = frmCnt * vel ;
        
        tx = tx - Math.floor(tx / period ) * period;
        //trace(tx);
        matr.createGradientBox(gradboxSize, gradboxSize, rot, tx,0);
        var spreadMethod:String = SpreadMethod.REFLECT;
        gradSp.graphics.clear();
        gradSp.graphics.beginGradientFill(fillType, gradData.colors, gradData.alphas, gradData.ratios, matr, spreadMethod);  
        gradSp.graphics.drawRect(0,0,mapSizeX,mapSizeY);
    }
    /****************
     * グラディエントデータ作成
     * **************/
    public function makeGradData():void 
    {
        var colors:Array = new Array();
        var alphas:Array = new Array();
        var ratios:Array = new Array();
        
        var maxLoop:int =0xF;
        
        for (var i:int = 0; i < maxLoop; i++) 
        {
            var sin:Number = Math.sin(Math.PI / maxLoop * i - Math.PI/2 ) / 2 + 0.5;
            var color:uint = sin * 0xFF;
            
            
            colors.push(color);
            alphas.push(1);
            ratios.push(uint(0xFF / maxLoop * (i+1)));
        }
        gradData.alphas = alphas;
        gradData.colors = colors;
        gradData.ratios = ratios;
    }
}
/**
 * ...
 */
class GradData
{
    
    public var colors:Array = new Array();
    public var alphas:Array = new Array();
    public var ratios:Array = new Array();    
}

