/**
 * Copyright lizhi ( http://wonderfl.net/user/lizhi )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/gSyH
 */

package  
{
	import flash.display.Sprite;
	import flash.events.Event;
	/**
	 * ...
	 * @author lizhi http://game-develop.net/
	 */
	public class TangentLineCircle extends Sprite
	{
		private var cx:Number = 200;
		private var cy:Number = 200;
		private var r:Number = 50;
		public function TangentLineCircle() 
		{
			addEventListener(Event.ENTER_FRAME, enterFrame);
		}
		
		private function enterFrame(e:Event):void 
		{
			graphics.clear();
			graphics.lineStyle(0);
			graphics.drawCircle(cx, cy, r);
			
			var x0:Number = mouseX;
			var y0:Number = mouseY;
			graphics.moveTo(x0, y0);
			graphics.lineTo(cx, cy);
			
			var dcxx0:Number = cx - x0;
			var dcyy0:Number = cy - y0;
			var lenAb2:Number = dcxx0 * dcxx0 + dcyy0 * dcyy0;
			var lenAc2:Number = lenAb2-r*r;
			var lenAc:Number = Math.sqrt(lenAc2);
			
			var cos:Number = (dcxx0 * lenAc + dcyy0 * r) / lenAb2;
			var sin:Number = (dcxx0 * r - dcyy0 * lenAc) / lenAb2;
			
			var x1:Number = lenAc * cos + x0;
			var y1:Number = -lenAc * sin + y0;
			graphics.drawCircle(x1, y1, 2);
			graphics.moveTo(x0, y0);
			graphics.lineTo(x1, y1);
			
			cos = (dcxx0 * lenAc - dcyy0 * r) / lenAb2;
			sin = (-dcxx0 * r - dcyy0 * lenAc) / lenAb2;
			var x2:Number = lenAc * cos + x0;
			var y2:Number = -lenAc * sin + y0;
			graphics.drawCircle(x2, y2, 2);
			graphics.moveTo(x0, y0);
			graphics.lineTo(x2, y2);

		}
		
	}

}