/**
 * Copyright hig_an ( http://wonderfl.net/user/hig_an )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/gRrt
 */

// forked from hig_an's flash on 2010-7-7
package {
    import flash.display.Sprite;
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.filters.BlurFilter;
	import flash.geom.Point;
    
    public class FlashTest extends Sprite {
        private var bmpdata:BitmapData;
		private var particles:Array;
		private var size:Number = 465;
		private var particle_number:uint = 0;
		private var filter:BlurFilter;
		
		public function FlashTest() {
			bmpdata = new BitmapData(size, size, false, 0);
			addChild(new Bitmap(bmpdata));
			particles = new Array();
			filter = new BlurFilter(2, 1, 100);
			
			reset();
            addEventListener(Event.ENTER_FRAME, enterframe);
			stage.addEventListener(MouseEvent.CLICK, reset);
        }
		public function reset(e:MouseEvent = null):void {
			
			particle_number += 1000;
			for (var i:int = 0; i < particle_number; i++) {
				particles[i] = new Particle(size * Math.random(), 0);
			}
		}
		public function enterframe(e:Event):void {
			bmpdata.applyFilter(bmpdata, bmpdata.rect, bmpdata.rect.topLeft, filter);
			bmpdata.lock();
			for (var i:int = 0; i < particle_number; i++) {
				var p:Particle = particles[i];
				p.ax *= Math.random();
				p.ay *= Math.random();
				
				p.x += p.vx += p.ax;
				p.y += p.vy += p.ay;
				
				if (p.y > size) {
					p.y -= size;
				}
				if (p.x > size) {
					p.x -= size;
				}
				else if (p.x < 0) {
					p.x += size;
				}
				
				bmpdata.setPixel(p.x, p.y, 0x00ff00);
			}
			bmpdata.unlock();
		}
    }
}

class Particle {
	public var x:Number;
	public var y:Number;
	
	public var vx:Number = 0;
	public var vy:Number = 5;
	
	public var ax:Number = 0;
	public var ay:Number = 1;
	
	function Particle(px:Number,py:Number) {
		x = px;
		y = py;
		vx = 1 - Math.random() * 2
		ax = 1 - Math.random() * 2
	}
}