/**
 * Copyright greentec ( http://wonderfl.net/user/greentec )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/gQeV
 */

package 
{
    import com.bit101.components.Label;
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.geom.ColorTransform;
    import flash.geom.Rectangle;
    
    /**
     * ...
     * @author ypc
     */
    [SWF(width = 465, height = 465, backgroundColor = "#292929")]
    public class Main extends Sprite 
    {
        public var bitmap:Bitmap;
        public var bitmapData:BitmapData;
        public var noiseBitmapData:BitmapData;
        public var screenBitmapData:BitmapData;
        
        public var _width:int = 465;
        public var _height:int = 465;
        
        public function Main():void 
        {
            if (stage) init();
            else addEventListener(Event.ADDED_TO_STAGE, init);
        }
        
        private function init(e:Event = null):void 
        {
            removeEventListener(Event.ADDED_TO_STAGE, init);
            // entry point
            
            bitmapData = new BitmapData(_width, _height, false, 0x0);
            bitmap = new Bitmap(bitmapData);
            
            noiseBitmapData = new BitmapData(_width, _height, false, 0);
            noiseBitmapData.perlinNoise(_width / 5, _height / 5, 7, Math.random() * int.MAX_VALUE, false, true, 7, true);
            
            var i:int;
            var j:int;
            var x:Number;
            var y:Number;
            var num:Number;
            var color:int;
            for (i = 0; i < _width; i += 1)
            {
                for (j = 0; j < _height; j += 1)
                {
                    x = i / _width * 1.0;
                    y = (noiseBitmapData.getPixel(i, j) & 0xff) / 255;

                    num = (1 + Math.sin((x + y / 2) * 50)) / 2;
                    num = num < 0 ? 0 : num;
                    color = num * 255;
                    bitmapData.setPixel(i, j, color << 16 | color << 8 | color);
                    
                }
            }

            addChild(bitmap);

            stage.addEventListener(MouseEvent.CLICK, onClick);

        }

        private function onClick(e:MouseEvent):void
        {
            noiseBitmapData.fillRect(noiseBitmapData.rect, 0x0);
            var scale:int = Math.random() * 10 + 2;
            noiseBitmapData.perlinNoise(_width / scale, _height / scale, 7, Math.random() * int.MAX_VALUE, false, true, 7, true);
            
            bitmapData.fillRect(bitmapData.rect, 0);
            bitmapData.lock();
            
            var i:int;
            var j:int;
            var x:Number;
            var y:Number;
            var num:Number;
            var color:int;
            for (i = 0; i < _width; i += 1)
            {
                for (j = 0; j < _height; j += 1)
                {
                    x = i / _width * 1.0;
                    y = (noiseBitmapData.getPixel(i, j) & 0xff) / 255;
                    num = (1 + Math.sin((x + y / 2) * 50)) / 2;
                    
                    num = num < 0 ? 0 : num;
                    color = num * 255;
                    bitmapData.setPixel(i, j, color << 16 | color << 8 | color);
                    
                }
                
            }
            
            bitmapData.unlock();
            bitmapData.colorTransform(bitmapData.rect, new ColorTransform(Math.random(), Math.random(), Math.random(), 1, Math.random() * 255, Math.random() * 255, Math.random() * 255));
        }
        
    }

}