/**
 * Copyright shaktool ( http://wonderfl.net/user/shaktool )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/gQbI
 */

package
{
	import flash.display.*;
	import flash.events.*;
	import flash.geom.*;
	import flash.filters.*;
	import flash.text.*;
	[ SWF( width=465, height=465, backgroundColor=0, framerate=30 ) ]
	public class Distributor extends Sprite
	{
		private var size: Number = 465;
		private var turbulence: BitmapData = new BitmapData( NOISE_LENGTH, NOISE_LENGTH, false, 0 );
		private var canvas: Graphics;
		private var label: TextField;
		
		public function Distributor()
		{
			turbulence.perlinNoise( 32, 32, 4, Math.random()*int.MAX_VALUE, true, true, 3, false );
			
			
			var sprite: Sprite = new Sprite();
			addChild( sprite );
			canvas = sprite.graphics;
			
			//addChild(new Bitmap(turbulence));
			
			var format: TextFormat = new TextFormat();
			format.align = TextFormatAlign.LEFT;
			format.bold = true;
			format.font = "Arial";
			format.size = 20;
			
			label = new TextField();
			label.width = 400;
			label.x = 20;
			label.height = 100;
			label.y = 20;
			label.wordWrap = false;
			label.type = TextFieldType.DYNAMIC;
			label.textColor = 0x000000;
			label.selectable = false;
			label.mouseEnabled = false;
			label.defaultTextFormat = format;
			label.text = "";
			addChild( label );
			
			stage.addEventListener( MouseEvent.MOUSE_MOVE, reset );
			//stage.addEventListener( MouseEvent.CLICK, reset );
			//addEventListener( Event.ENTER_FRAME, reset );
			reset();
		}
		
		private function reset( event: Event = null ): void
		{
			canvas.clear();
			canvas.beginFill( 0xbbbbbb );
			canvas.drawRect( 0, 0, size, size );
			canvas.endFill();
			
			var radius: Number = size / 2.0;
			var center: Number = size / 2.0;
			//var twist: Number = 0.55523 + 0.00001 * mouseY / size;
			var twist: Number = 0.55523501234;
			var concentration: Number = 0.5;
			//var concentration: Number = mouseY / size;
			var count: int = 200.0 * ( mouseX / size ) * ( mouseX / size );
			//var count: int = 500;
			//var offset: Number = 1.0 * mouseY / size;
			var offset: Number = 0.0;
			//var offset2: Number = 1.0 * mouseX / size;
			var offset2: Number = 0.0;
			var weirdness: Number = 1.0;
			//var chaos: Number = 2.0 * mouseY / size;
			var chaos: Number = 1.0;
			var clusterMaxCount: int = 6;
			var clusterSpacing: Number = 0.01 * mouseY / size;
			//var clusterSpacing: Number = 0.0015;
			
			var distortion: Number = Math.min( 0.3, Math.max( 0.02, 1.75 / Math.sqrt( count ) ) ) * chaos;
			for ( var i: int = 0; i < count; i++ )
			{
				var a: Number = ( ( i * 0.61803398875 * weirdness + offset2 ) % 1.0 );
				var r: Number = ( ( i * twist * weirdness + offset ) % 1.0 );
				var cx: Number = a * 2.0 - 1.0;
				var cy: Number = r * 2.0 - 1.0;
				
				//cx = Math.cos( r * Math.PI * 2.0 ) * 0.001 * i;
				//cy = Math.sin( r * Math.PI * 2.0 ) * 0.001 * i;
				
				
				var color: uint = turbulence.getPixel( cx * 128.0 + 128.0, cy * 128.0 + 128.0 );
				var tx: Number = ( ( color >> 16 ) & 0xff ) / 127.5 - 1.0;
				var ty: Number = ( ( color >>  8 ) & 0xff ) / 127.5 - 1.0;
				cx += tx * distortion;
				cy += ty * distortion;
				
				
				//cx = Math.random() * 2.0 - 1.0;
				//cy = Math.random() * 2.0 - 1.0;
				
				
				var d: Number = Math.sqrt( cx * cx + cy * cy );
				if ( d > 1.0 ) continue;
				var ratio: Number = 1.0 - Math.sqrt( 1.0 - d ) * concentration;
				cx *= ratio;
				cy *= ratio;
				
				var permutation: uint = permute( i );
				var clusterCount: int = Math.pow( permutation / 0xffffffff, 2.0 ) * ( clusterMaxCount ) + 1;
				for ( var j: int = 0; j < clusterCount; j++ )
				{
					var fx: Number = cx;
					var fy: Number = cy;
					var k: int = j * 2;
					if ( (permutation & ( 1 << j )) != 0 ) k++;
					if ( k > 0 )
					{
						var angle: Number = Math.PI * 2.0 * 0.61803398875 * k;
						var pushRadius: Number = ( k + 15.0 ) * clusterSpacing * ( 1.0 + k * 0.03 );
						fx += Math.cos( angle ) * pushRadius;
						fy += Math.sin( angle ) * pushRadius;
					}
					canvas.beginFill( ( ( permute( permutation + j ) % 2 ) == 0 ) ? 0x000000 : 0x777777 );
					canvas.drawCircle( center + fx * radius, center + fy * radius, 2 );
					canvas.endFill();
				}
			}
			
			label.text = twist + ", " + count;
		}
	}
}

const WIDTH: int = 465;
const HEIGHT: int = 465;
const NOISE_LENGTH: int = 256;

function permute( x: uint ): uint
{
	x = ( x * x ) ^ 0x5bf03635;
	x = ( x * x ) % 4294967291;
	return x;
}
