/**
 * Copyright cpu_t ( http://wonderfl.net/user/cpu_t )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/gQ3i
 */

package
{
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.geom.ColorTransform;
    
    [SWF(width=465,height=465)]
    public class FlashTest extends Sprite
    {
        public function FlashTest()
        {
            with(graphics){beginFill(0);drawRect(0,0,465,465);}
            canvas=new BitmapData(fieldSize,fieldSize,true,0);
            forcemap=canvas.clone();
            //with(addChild(new Bitmap(forcemap))){width=stage.stageWidth;height=stage.stageHeight;}
            with(addChild(new Bitmap(canvas))){width=stage.stageWidth;height=stage.stageHeight;}
            
            reset();
            
            updateColortrans=new ColorTransform(0.99,1,1,0.998,0,0,3);
            addEventListener(Event.ENTER_FRAME,enterFrameHandler);
            
            stage.addEventListener(MouseEvent.MOUSE_DOWN,function(e:MouseEvent):void
            {
                reset();
            });
        }
        
        private var fieldSize:int=50;
        private var canvas:BitmapData;
        private var forcemap:BitmapData;
        
        private var particles:Vector.<Object>;
        
        private var updateColortrans:ColorTransform;
        
        private function reset():void
        {
            canvas.fillRect(canvas.rect,0);
            
            particles=new Vector.<Object>();
            for(var i:int=0;i<20;i++)
            {
                particles.push(
                    {
                        x:int(Math.random()*fieldSize/2)*2,
                        y:int(Math.random()*fieldSize/2)*2,
                        vx:0,vy:0,
                        moving:false
                    });
            }
            
            forcemap.perlinNoise(fieldSize/4,fieldSize/4,3,Math.random()*0xFFFFFF,true,false,7,true);
            var ct:ColorTransform=new ColorTransform(-3,-3,-3,1,255,255,255);
            forcemap.colorTransform(forcemap.rect,ct);
        }
        
        
        private function enterFrameHandler(e:Event):void
        {
            canvas.lock();
            canvas.colorTransform(canvas.rect,updateColortrans);
            for(var index:* in particles)
            {
                var part:Object=particles[index];
                if(!part.moving)
                {
                    part.moving=true;
                    if(Math.random()<0.8)
                    {
                        // 方向転換
                        var pixels:Array=
                            [
                                forcemap.getPixel(part.x,part.y-1),
                                forcemap.getPixel(part.x+1,part.y),
                                forcemap.getPixel(part.x,part.y+1),
                                forcemap.getPixel(part.x-1,part.y)
                            ];
                        if(part.vy==-1)pixels[2]=-1;
                        else if(part.vx==1)pixels[3]=-1;
                        else if(part.vy==1)pixels[0]=-1;
                        else if(part.vx==-1)pixels[1]=-1;
                        part.vx=0;
                        part.vy=0;
                        var maxi:int=int(Math.random()*pixels.length);
                        for(var i:int=0;i<pixels.length;i++)
                        {
                            if(pixels[i]>pixels[maxi])
                            {
                                maxi=i;
                            }
                        }
                        switch(maxi)
                        {
                            case 0:
                                part.vy=-1;
                                break;
                            case 1:
                                part.vx=1;
                                break;
                            case 2:
                                part.vy=1;
                                break;
                            case 3:
                                part.vx=-1;
                                break;
                        }
                    }
                }
                else
                {
                    part.moving=false;
                }
                part.x+=part.vx;
                part.y+=part.vy;
                if(part.x<0)part.x=fieldSize-1;
                else if(part.x>=fieldSize)part.x=0;
                if(part.y<0)part.y=fieldSize-1;
                else if(part.y>=fieldSize)part.y=0;
                canvas.setPixel32(part.x,part.y,0xFFFF0000);
            }
            canvas.unlock();
        }
    }
}