package
{
	// KitchenSync example showing off the KSSound object
	
	// Code is MIT License
	// Music is © Neal Wright 2010 all rights reserved
	
	import flash.display.*;
	import flash.events.*;
	import flash.media.*;
	import flash.net.*;
	import flash.text.*;
	import flash.ui.*;
	
	import org.as3lib.kitchensync.*;
	import org.as3lib.kitchensync.action.*;
	import org.as3lib.kitchensync.action.group.*;
	import org.as3lib.kitchensync.core.*;
	
	public class ClosedCaptioningDemo extends flash.display.Sprite
	{
		private var sound:Sound;
		private var captionField:TextField;
		private var soundController:KSParallelGroup;
		private var songControl:AbstractAction;
		
		public function ClosedCaptioningDemo () {
			KitchenSync.initialize(this, "2.0");
			
			// create a new sound object
			var sound:Sound = new Sound();
			// add a listener so that when this finishes loading, the sound and captions will begin playing.
			sound.addEventListener(Event.COMPLETE, onSoundLoaded);
			// load the sound. 
			sound.load(new URLRequest("http://skryptkidz.com/blog/wp-content/uploads/SkryptKidz3000-Intro.mp3"));
			
			// add the instrutions in a text field.
			var instructions:TextField = new TextField();
			instructions.y = 200;
			instructions.autoSize = TextFieldAutoSize.LEFT;
			instructions.text = "Press space bar to pause and resume playback.";
			instructions.setTextFormat(new TextFormat(null, 10, null, null, true));
			addChild(instructions);
			
			// create a text field for the captions.
			captionField = new TextField();
			captionField.setTextFormat(new TextFormat(null, 30, null, null, true));
			captionField.autoSize = TextFieldAutoSize.LEFT;
			captionField.text="Loading...";
			addChild(captionField);
			
			// Create a new parallel object to hold the sound and all of the
			// captions. The captions change actions are being generated by
			// the getCaptionAction() method which simply creates a new 
			// SynchronizedFunction object. (see below for more) 
			soundController = new KSParallelGroup(
				new KSSound(sound),
				
				getCaptionAction("", 0),
				// each caption has text to display and a time at which to display it (in msecs)
				getCaptionAction("Hey, what's up man, how you doin'?", 500),
				// the \t's are tabs to show that it is a different voice.
				getCaptionAction("\t\t\t\t\t\tHey, what up, man?", 2000),
				getCaptionAction("Yo, listen to what I got to spit man.", 3000),
				getCaptionAction("\t\t\t\t\t\tA'aight, a'aight.", 4600),
				getCaptionAction("", 5500),
				getCaptionAction("Stop your bitchin', it's time for Brooklyn Skrypt Kidz™", 6100),
				getCaptionAction("Get your ass on iTunes and update your subscriptions", 9100),
				getCaptionAction("Got more knowledge than Sarah Lawrence College", 12200),
				getCaptionAction("Like walkin' Wikipedia when it comes to macromedia", 14600),
				getCaptionAction("We use debuggers so we know our shit don't crash", 18100),
				getCaptionAction("So when something breaks", 20750),
				getCaptionAction("YOU KNOW YOU SHOULDA USED FLASH!", 21800),
				getCaptionAction("", 23700),
				getCaptionAction("We're AS'n, beta testin' and coalescin'", 24200),
				getCaptionAction("We're 'bout to school your ass in a podcast session.", 27000),
				getCaptionAction("", 30100),
				getCaptionAction("Yeah.", 31000),
				getCaptionAction("", 31500),
				getCaptionAction("\t\t\t\t\t\tAlright.", 32000),
				getCaptionAction("", 32400),
				getCaptionAction("Skrypt Kidz", 35800),
				getCaptionAction("3000", 38500),
				getCaptionAction("", 41100),
				getCaptionAction("Skrypt Kidz", 41900),
				getCaptionAction("3000", 44600),
				getCaptionAction("*Skrikka ka wicketa skrickitey wick*", 46350),				
				getCaptionAction("*Scrum scrik ta fwee era fresh*", 49000),				
				getCaptionAction("*Wah wickety skrizzle shh frick fra fricky wick*", 52000),
				getCaptionAction("", 57000),
				getCaptionAction("Check out the SkryptKidz 3000 podcast at SkryptKidz.com", 58500)
			); 
			
			// add a keyboard listener for the pause function.
			stage.addEventListener(KeyboardEvent.KEY_DOWN, onKeyDown);
		}
		
		/** When the sound is loaded, play the song and the captions. **/
		private function onSoundLoaded (event:Event):void {
			soundController.start();	
		}
		
		/**
		 * Generates a new SynchronizedFunction to set the text of the captionField.
		 * This is just to make the code easier to read.
		 */
		private function getCaptionAction(captionText:String = "", delay:int = 0):KSFunction {
			var func:KSFunction = new KSFunction(setCaptionText, delay, captionText);
			// set sync to true to synchronize with the audio regardless of drops in framerate.
			//			func.sync = false;
			return func;
		} 
		
		/**
		 * Sets the caption field to display a new line of text. 
		 * Also traces the caption text and the time it was set.
		 */
		private function setCaptionText (captionText:String):void {
			trace(Synchronizer.getInstance().currentTime, captionText);
			captionField.text = captionText;
		}
		
		/**
		 * Key handler which will pause the song and captions when the spacebar is pressed.
		 */
		private function onKeyDown(event:KeyboardEvent):void {
			if (event.keyCode == Keyboard.SPACE) {
				if (soundController.isPaused) {
					soundController.unpause();
					trace("unpaused");
				} else {
					soundController.pause();
					trace("paused");
				}
			}
		}
	}
}