/**
 * Copyright andyshang ( http://wonderfl.net/user/andyshang )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/gPnaG
 */

package
{
    import flash.display.BlendMode;
    import flash.display.Graphics;
    import flash.display.Shape;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.filters.BlurFilter;
    import flash.geom.ColorTransform;

    import org.papervision3d.cameras.Camera3D;
    import org.papervision3d.core.effects.BitmapLayerEffect;
    import org.papervision3d.materials.WireframeMaterial;
    import org.papervision3d.materials.special.ParticleMaterial;
    import org.papervision3d.objects.DisplayObject3D;
    import org.papervision3d.objects.primitives.Sphere;
    import org.papervision3d.objects.special.ParticleField;
    import org.papervision3d.render.BasicRenderEngine;
    import org.papervision3d.scenes.Scene3D;
    import org.papervision3d.view.Viewport3D;
    import org.papervision3d.view.layer.BitmapEffectLayer;

    [SWF(width = "465", height = "465", backgroundColor = "0", fps = "30")]
    public class Floys3D extends Sprite
    {
        public static var KICK:Number = 0.05;
        public static var NUMNB:Number = 3;
        public static var NF:int = 45;

        private var floys:Array;


        private var scene:Scene3D;
        private var camera:Camera3D;
        private var viewport:Viewport3D;
        private var render:BasicRenderEngine;
        private var rootNode:DisplayObject3D;
        private var bfm:BitmapEffectLayer;
        private var coltrans:ColorTransform;
        private var cameraBool:Boolean;
        private var cametaPos:Object;
        private var angle:Number;


        private var vmax:int = 100;

        private function createWorld():void
        {
            scene = new Scene3D();
            viewport = new Viewport3D(0, 0, true, false);
            addChild(viewport);
            rootNode = new DisplayObject3D();
            scene.addChild(rootNode);
            camera = new Camera3D();
            camera.z = -camera.focus * camera.zoom;
            render = new BasicRenderEngine();

            var sphere:Sphere = new Sphere(new WireframeMaterial(0xFFFFFF, 100, 1), 100, 36, 24);
            vmax = sphere.geometry.vertices.length - 1;
            var mat:ParticleMaterial =  new ParticleMaterial(0xFFFFFF, 10, 1);
            var particles:ParticleField = new ParticleField(mat, 400, 3, 2000, 2000, 2000);

            bfm = new BitmapEffectLayer(viewport, stage.stageWidth, stage.stageHeight, true, 0, "clear_pre",false,false );
            bfm.addEffect(new BitmapLayerEffect(new BlurFilter(10, 10, 3), false));
            bfm.drawCommand.blendMode = BlendMode.ADD
            viewport.containerSprite.addLayer(bfm);
            bfm.addDisplayObject3D(particles);

            coltrans = new ColorTransform(0,0,0,1,0,0,0,0);
            rootNode.addChild(particles)

            angle = 0;
            cameraBool = true;
            cametaPos = { b: -camera.focus * camera.zoom, f:-camera.focus * camera.zoom + 150 };

            floys = [];
            for (var i:int=0;i<NF;i++)
            {
                floys[i] = new Floy(NUMNB, stage.stageWidth-5, stage.stageHeight-5, stage.stageHeight-5);
                floys[i].init();
            }
            randemize();

            addEventListener(Event.ENTER_FRAME, function(event:Event):void
            {
                if (Math.random()< KICK)
                {
                    randemize();
                }
                floys.forEach(function(floy:Floy, i:int, arr:*):void
                {
                    floy.process();
                    particles.geometry.vertices[i].x = floy.x;
                    particles.geometry.vertices[i].y = floy.y;
                    particles.geometry.vertices[i].z = floy.z;
                });

                render.renderScene(scene, camera, viewport);

                rootNode.rotationY+=.5;
                rootNode.rotationX+=.3;
                rootNode.rotationZ+=.1;
                angle+=.01;
            });
        }

        public function Floys3D()
        {
            stage.frameRate = 30;
            createWorld();
        }

        public function randemize():void{
            for (var k:int=0;k<NF;k++)
            {
                var ng:Floy = floys[k];
                for (var j:int=0;j<NUMNB;j++)
                {
                    var n:int = Math.random()* NF;
                    ng.neighbors[j] = floys[n];
                }
            }
        }
    }
}
class Floy
{
    public var x:Number;
    public var y:Number;
    public var z:Number;

    public var neighbors:Array = [];

    private var numnb:int;

    private var revdist:int = 2000;
    private var margin:int = 30;
    private var acc:Number = 0.3;
    private var acctomid:Number = 0.1;
    private var maxspeed:Number = 8;
    private var bouncespeed:Number = 0.8;
    private var v0:Number = 4;

    private var vx:Number;
    private var vy:Number;
    private var vz:Number;

    private var width:int;
    private var height:int;
    private var zdirection:int;

    private var color:uint = 0x0;

    public function Floy(numnb:int, w:int, h:int, z:int)
    {
        this.numnb = numnb;
        width = w;
        height = h;
        zdirection = z;
    }

    public function init():void
    {
        x =  Math.random()*(width-margin*2) + margin;
        y =  Math.random()*(height-margin*2) + margin;
        z =  Math.random()*(zdirection-margin*2) + margin;

        vx =  Math.random()*v0-v0/2;
        vy =  Math.random()*v0-v0/2;
        vz =  Math.random()*v0-v0/2;
    }


    public function dist(ng:Floy):int
    {
        var d1:int = x-ng.x;
        var d2:int = y-ng.y;
        var d3:int = z-ng.z;
        return d1*d1+d2*d2+d3*d3;
    }


    private function updateNeighbors():void
    {
        var i:int=0;
        for (i=0;i<numnb;i++) {
            var ng:Floy = neighbors[i];;
            for (var j:int=0;j<numnb;j++) {
                if (dist(ng.neighbors[j]) < dist(ng))
                    neighbors[i]=ng.neighbors[j];
            }
        }

        for (i=0;i<numnb;i++) {
            if (neighbors[i] == this)
            {
                neighbors[i]=neighbors[i].neighbors[0];
            }
        }
    }

    private function adjustSpeed():void
    {
        var rev:int = -1;

        for (var i:int=0;i<numnb;i++)
        {
            var d:int = dist(neighbors[i]);
            rev = d == 0? 0 : (d < revdist ? -1:1);

            var sign:int;
            sign = x < neighbors[i].x ? 1: -1;
            vx += sign * acc * rev;
            sign = y < neighbors[i].y ? 1: -1;
            vy += sign * acc * rev;
            sign = y < neighbors[i].y ? 1: -1;
            vz += sign * acc * rev;
        }

        if (vx > maxspeed) vx = maxspeed;
        if (vx < -maxspeed) vx = -maxspeed;
        if (vy > maxspeed) vy = maxspeed;
        if (vy < -maxspeed) vy = -maxspeed;
        if (vz > maxspeed) vz = maxspeed;
        if (vz < -maxspeed) vz = -maxspeed;

        if (x < -width) vx = bouncespeed;
        if (x > width) vx = -bouncespeed;
        if (y < -height) vy = bouncespeed;
        if (y > height) vy = -bouncespeed;
        if (z < -zdirection) vz = bouncespeed;
        if (z > zdirection) vz = -bouncespeed;

        if (x < 0) vx += acctomid;
        if (x > 0) vx -= acctomid;
        if (y < 0) vy += acctomid;
        if (y > 0) vy -= acctomid;
        if (z < 0) vz += acctomid;
        if (z > 0) vz -= acctomid;
    }

    public function process():void
    {
        updateNeighbors();
        adjustSpeed();

        x += vx;
        y += vy;
        z += vz;
    }
}