/**
 * Copyright jmbyh521 ( http://wonderfl.net/user/jmbyh521 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/gOpA
 */

// forked from WLAD's Bit Boxes
package {
    import flash.display.Sprite;
    
    public class FakeStage extends Sprite 
    {
        public function FakeStage() 
        {
            Vars.W = stage.stageWidth;
            Vars.H = stage.stageHeight;
            // write as3 code here..
            addChild(new Main(stage));
        }
    }
}
import flash.utils.ByteArray;

import flash.events.Event;
import com.bit101.components.*;
import flash.display.*;

class Main extends Sprite
{
    private var lbl:Label;
    private var input:InputText;
    //private var btn:PushButton;
    
    private var box:BitBox;
    
    private var lblOct:Label;
    private var lblHex:Label;
    
    
    public function Main(stage:Stage)
    {
        input = new InputText(this,3,3,"1580981237409863",onClick);
        input.scaleX = input.scaleY = 1.3;
        input.width = (Vars.W - 6) / 1.3;
        input.maxChars = 16;
        
        //btn = new PushButton(this,Vars.W - 55,5,"Generate",onClick);
        //btn.height -= 3;
        //btn.width = 50;
        
        bits = new Vector.<Bit>();
        
        lblOct = new Label(this,260,42);
        lblOct.scaleX = lblOct.scaleY = 1.3;
        lblHex = new Label(this,260,62);
        lblHex.scaleX = lblHex.scaleY = 1.3;
        
        lbl = new Label(this,6,24);
        lbl.scaleX = lbl.scaleY = 1.3;
        
        
        onClick();
        
        box = new BitBox(int(Vars.W / 20),int((Vars.H / 6 * 4) / 20));
        box.fillRandom();
        box.sort();
        addChild(box);
        box.y = 2 * Vars.H / 6;
        box.addEventListener(Event.ENTER_FRAME,loop);
    }
    
    private function loop(e:Event):void
    {
        box.push(Math.random() > .5);
        box.sort();
    }

    
    private function createByteArray():String
    {
        //Initialize our _testObject variable, so that we can populate many dynamic properties and store String data in it (we will load them later whenever user clicked the _loadButton)    
        var _testObject:Object = new Object();    
        _testObject.name = "Taufik";    
        _testObject.website = "<a href='http://ikt.co.id'>http://ikt.co.id</a>";    
        _testObject.occupation = "CTO";    
        //Initialize our _byteArray variable, so that we can start converting object into a ByteArray    
        var _testByteArray:ByteArray = new ByteArray();    
        
        _testByteArray.writeInt(0);
        
        trace("234");
        
        //Convert the Object into Byte Array, This is how you do it, to convert an Object into a ByteArray, IT IS SIMPLE isnt it? :))    
        //_testByteArray.writeObject(_testObject);
        //Lets see if everything works properly
        return _testByteArray.toString();
    }
    
    
    private function onClick(e:Event = null):void
    {
        input.text = Number(input.text).toString();
        
        lbl.text = Number(input.text).toString(2);
        lblHex.text = "Hex: " + Number(input.text).toString(16).toUpperCase();
        lblOct.text = "Oct: " + Number(input.text).toString(8);
        
        
        displayBitData(
        Number(input.text).toString(2));
    }

    
    
    private var bits:Vector.<Bit>;
    
    private function displayBitData(value:String):void
    {
        while(bits.length > 0)
            removeChild(bits.pop());
        
        var posX:int = 0;
        var posY:int = 1;
        
        for(var i:int = 0; i < value.length ; i++)
        {
            bits.push(addChild(new Bit(value.charAt(i) == "1")))
            
            bits[i].x = 5 + posX++ * 20;
            bits[i].y = 26 + posY * 20;
            
            if(bits[i].x + 25 > Vars.W / 2)
            {
                posY++;
                posX = 0;
            }
        }
    }


}



class BitBox extends Sprite
{
    private var bits:Vector.<Bit>;
    
    private var w:Number;
    private var h:Number;
    
    public function BitBox(w:uint,h:uint)
    {
        this.w = w;
        this.h = h;
        
        bits = new Vector.<Bit>();
    }
    
    public function fillRandom():void
    {
        while(bits.length < w * h)
            push(Math.random() < .5);

    }
    
    public function push(bit:Boolean):void
    {
        if(bits.length == w * h)
        {
            bits.unshift(bits.pop());
        } else {
            bits.unshift(addChild(new Bit(bit)) as Bit);
        }

        //while(bits.length > w * h)
        //    bits.pop(); 
    }

    
    public function sort():void
    {
        var posX:int = 0;
        var posY:int = 0;
        
        for(var i:int = 0; i < bits.length ; i++)
        {
            bits[i].x = posX++ * bits[i].w;
            bits[i].y = posY * bits[i].h;
            
            if(posX >= w)
            {
                posX = 0;
                posY++;
            }
        }
    }
}




class Bit extends Sprite
{
    private var txt:Label;
    public function Bit(bit:Boolean)
    {
        txt = new Label(this,6 + (bit ? 1 : 0),2,bit ? "1" : "0");
        
        graphics.beginFill(bit ? 0xFF0000 : 0xFFFFFF);
        if(Vars.BitBorder)
            graphics.lineStyle(.1);
        graphics.drawRect(0,0,20,20);
    }
    
    public function scale(value:Number):void
    {
        
    }
    
    public function get w():Number
    {
        return width * scaleX;
    }
    
    public function get h():Number
    {
        return height * scaleY;
    }



}



Style.LABEL_TEXT = 0;

class Vars
{
    public static var BitBorder:Boolean = false;
    
    public static var W:Number = 0;
    public static var H:Number = 0;
}

