/**
 * Copyright hycro ( http://wonderfl.net/user/hycro )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/gONQ
 */

package {
    import flash.display.Sprite;
    import flash.text.TextField;
    
    public class ProjectEuler extends Sprite {
		private var _textField:TextField;
       
        public function ProjectEuler() {
        		initialize();
        		writeAnswer(new Problem007);
        }
        
        private function writeAnswer(problem:AbstructProblem):void {
        		var answer:String = problem.getAnswer();
        		 _textField.appendText(answer);
        }
        
        private function initialize():void {
        	    _textField = new TextField();
            _textField.width = stage.stageWidth;
            _textField.height = stage.stageHeight;
            addChild(_textField);
        }
    }
}

class AbstructProblem {
	final public function getAnswer():String {
		var answer:String;
		try {
			answer = solve().toString();
		} catch (err:Error) {
			answer = err.name + " : " + err.message;
		}
		return answer;
	}
	
	protected function solve():Number {
		throw new Error("unsolved");
	}
}

class Problem007 extends AbstructProblem {
	override protected function solve():Number {
		var answer:Number = 0;
		
		answer = getPrime(10001);
		
		return answer;
	}
	
	private function getPrime(index:uint):uint {
		var number:uint = 1;
		var isPrime:Boolean;
		var sequence:Vector.<uint> = new Vector.<uint>();
		
		for (var i:uint = 0; i < index; i++) {
			do {
				number++;
				isPrime = true;
				for each (var prime:uint in sequence) {
					if (number % prime == 0) {
						isPrime = false;
						break;
					}
				}
			} while (!isPrime);
			sequence.push(number);
		}
		
		return sequence.pop();
	}
}

class Utils {
	// 整数値の桁数の取得
	static public function disits(n:Number, radix:uint=10):Number {
		var d:Number = 0;
		
		n = Math.abs(n);
		while (n / radix != 0) {
			n = Math.floor(n / radix);
			d++;
		}
		
		return d;
	}
	
	// 指定した桁の値を取得
	static public function numberAt(n:Number, digit:Number, radix:Number=10):Number {
		var number:Number;
		
		while (--digit) {
			n = Math.floor(n / radix);
		}
		
		return n % radix
	}
	
	// 素数のリストを取得
	static public function getPrimeList(limit:uint):Vector.<uint> {
		var sequence:Vector.<uint> = new Vector.<uint>();
		var isPrime:Boolean;
		
		for (var i:uint = 2; i <= limit; i++) {
			isPrime = true;
			for each (var j:uint in sequence) {
				if (i % j == 0) {
					isPrime = false;
					break;
				}
			}
			if (isPrime) {
				sequence.push(i);
			}
		}
		
		return sequence;
	}
	
}