/**
 * Copyright osamX ( http://wonderfl.net/user/osamX )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/gNZ3
 */

/**
 * Theme:
 * Play with BitmapPatterBuilder.
 * Purpose of this trial is to find the possibility of the dot pattern.
 *
 * by Takayuki Fukatsu aka fladdict
 **/
package {
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Graphics;
    import flash.display.Sprite;
    import flash.display.StageScaleMode;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.events.TimerEvent;
	import flash.geom.Rectangle;
	import flash.utils.Timer;
    
    public class Professional extends Sprite {
		private const WIDTH:uint = 11;
		private const HEIGHT:uint = 6;
		private const SCALE:uint = 3;
		private const SPEED:uint = 4;
		private var mapSprite:Sprite;
		private var mapArray:Array;
		private var dotArray:Array;
		private var yuushaSprite1:Sprite;
		private var yuushaSprite2:Sprite;
		private var play:Boolean = true;
		private var walk:Boolean = true;
		
        public function Professional() {
            stage.scaleMode = StageScaleMode.NO_SCALE;
            
			mapSprite = new Sprite();
			mapSprite.scaleX = SCALE;
			mapSprite.scaleY = SCALE;
			mapSprite.x = -SCALE * 16;
			mapSprite.y = -32;
			
			yuushaSprite1 = new Sprite();
			yuushaSprite1.scaleX = SCALE;
			yuushaSprite1.scaleY = SCALE;
			yuushaSprite1.x = 208;
			yuushaSprite1.y = 208;
			yuushaSprite1.visible = true;
			drawYuusha(yuushaSprite1, Yuusha1());
			yuushaSprite2 = new Sprite();
			yuushaSprite2.scaleX = SCALE;
			yuushaSprite2.scaleY = SCALE;
			yuushaSprite2.x = 208;
			yuushaSprite2.y = 208;
			yuushaSprite2.visible = false;
			drawYuusha(yuushaSprite2, Yuusha2());
			
			initDot();
			initMap();
			drawMap();
			
			this.addChild( mapSprite );
			this.addChild( yuushaSprite1 );
			this.addChild( yuushaSprite2 );
			
			var timer:Timer = new Timer(500);
			timer.addEventListener(TimerEvent.TIMER, walkYuusha);
			timer.start();
			
			addEventListener(Event.ENTER_FRAME, moveMap);
			stage.addEventListener(MouseEvent.CLICK, onClick);
        }
		
		private function onClick(event:MouseEvent):void {
			play = !play;
			if (play) addEventListener(Event.ENTER_FRAME, moveMap);
			else removeEventListener(Event.ENTER_FRAME, moveMap);
		}
		
		private function drawMap():void {
			for (var j:uint = 0; j < HEIGHT; j++ ) {
				for ( var i:uint = 0; i < WIDTH; i++ ) {
					for (var yy:uint = 0; yy < 16; yy++) {
						for (var xx:uint = 0; xx < 16; xx++) {
							dotArray[16 * j + yy][16 * i + xx] = patterns[mapArray[j][i]][yy][xx];
						}
					}
				}
			}
			var g:Graphics = mapSprite.graphics;
			g.beginBitmapFill(BitmapPatternBuilder.build(dotArray,[0xFF92DC00, 0xFF319600, 0xFFFFB848, 0xFFB97A00, 0xFF000000,0xFFFFAA00, 0xFFFE0000, 0xFFFFAA25, 0xFF6BC6FF, 0xFFB1E2FF, 0xFF0092DC] ) );
			g.drawRect(0,10,WIDTH*16,int(465/SCALE)+1);
            g.endFill();
		}
		
		private function walkYuusha(event:TimerEvent):void {
			walk = !walk;
			yuushaSprite1.visible = walk;
			yuushaSprite2.visible = !walk;
		}
		
		private function drawYuusha(sprite:Sprite, bmd1:BitmapData ):void {
			var g:Graphics = sprite.graphics;
			g.beginBitmapFill(bmd1, null, false );
			g.drawRect(0, 0, 32, 16);
			g.endFill();
		}
		
		private function initMap():void {
			mapArray = new Array();
			for (var j:uint = 0; j < HEIGHT; j++) {
				mapArray[j] = new Array();
				for (var i:uint = 0; i < WIDTH; i++) {
					if (j == HEIGHT - 1) mapArray[j][i] = 0;
					else mapArray[j][i] = maprand();
				}
			}
		}
		
		private function initDot():void {
			dotArray = new Array();
			for (var j:uint = 0; j < HEIGHT*16; j++) {
				dotArray[j] = new Array();
				for (var i:uint = 0; i < WIDTH*16; i++) {
					dotArray[j][i] = 0;
				}
			}
		}
		
		private function maprand():uint {
			var rand:uint = int(Math.random() * 100);
			if (rand == 0) return 4;
			else if (rand < 5) return 5;
			else if (rand < 20) return 2;
			else if (rand < 30) return 3;
			else if (rand < 50) return 1;
			return 0;
		}
		
		private function moveMap(event:Event):void {
			//move mapSprite
			mapSprite.x += SPEED;
			if (mapSprite.x == 0) mapSprite.x = -SCALE*16;
			
			//move mapArray
			if (mapSprite.x == -SCALE*16) {
				for (var j:uint = 0; j < HEIGHT; j++) {
					for (var i:uint = WIDTH-1; i > 0; i--) {
						mapArray[j][i] = mapArray[j][i-1];
					}
				}
				for (j = 0; j < HEIGHT; j++) {
					if (j == HEIGHT - 1) mapArray[j][0] = 0;
					else mapArray[j][0] = maprand();
				}
				drawMap();
			}
			
		}
		
        private const patterns:Array =
				[
				//Lawn
                [[0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0],
				 [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
				 [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0],
				 [0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
				 [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
				 [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
				 [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
				 [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
				 [0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0],
				 [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
				 [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
				 [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
				 [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
				 [0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
				 [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0],
				 [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0]]
				,
				//Sand
                [[2, 2, 2, 2, 2, 2, 2, 3, 2, 2, 2, 2, 2, 2, 2, 2],
				 [2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2],
				 [2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 2],
				 [2, 3, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2],
				 [2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2],
				 [2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2],
				 [2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2],
				 [2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2],
				 [2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 2, 2, 2, 2, 2, 2],
				 [2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2],
				 [2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2],
				 [2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2],
				 [2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2],
				 [2, 2, 2, 3, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2],
				 [2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 2, 2, 2],
				 [2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2]]
				,
				//Tree1
                [[0, 0, 0, 4, 1, 0, 0, 0, 0, 0, 0, 4, 1, 0, 0, 0],
				 [0, 0, 4, 1, 1, 4, 0, 0, 0, 0, 4, 1, 1, 4, 0, 0],
				 [0, 4, 1, 1, 1, 1, 4, 0, 0, 4, 1, 1, 1, 1, 4, 0],
				 [4, 1, 1, 1, 4, 4, 1, 1, 4, 1, 1, 1, 4, 4, 1, 1],
				 [4, 4, 1, 1, 1, 1, 1, 1, 4, 4, 1, 1, 1, 1, 1, 1],
				 [4, 1, 4, 4, 1, 1, 1, 4, 4, 1, 4, 4, 1, 1, 1, 4],
				 [4, 1, 1, 1, 1, 1, 1, 1, 4, 1, 1, 1, 1, 1, 1, 1],
				 [4, 4, 1, 1, 1, 1, 4, 1, 4, 4, 1, 1, 1, 1, 4, 1],
				 [4, 1, 1, 1, 4, 4, 1, 4, 4, 1, 1, 1, 4, 4, 1, 4],
				 [4, 4, 1, 1, 1, 1, 1, 1, 4, 4, 1, 1, 1, 1, 1, 1],
				 [4, 4, 4, 1, 1, 1, 1, 1, 4, 4, 4, 1, 1, 1, 1, 1],
				 [0, 4, 4, 4, 4, 4, 4, 0, 0, 4, 4, 4, 4, 4, 4, 0],
				 [0, 0, 4, 4, 5, 4, 0, 0, 0, 0, 4, 4, 5, 4, 0, 0],
				 [0, 4, 4, 5, 5, 4, 4, 0, 0, 4, 4, 5, 5, 4, 4, 0],
				 [4, 4, 5, 5, 4, 5, 4, 4, 4, 4, 5, 5, 4, 5, 4, 4],
				 [0, 4, 4, 4, 4, 4, 4, 0, 0, 4, 4, 4, 4, 4, 4, 0]]
				,
				//Tree2
                [[0, 0, 0, 0, 0, 4, 4, 4, 4, 4, 4, 0, 0, 0, 0, 0],
				 [0, 0, 0, 0, 4, 1, 1, 1, 1, 1, 1, 4, 4, 0, 0, 0],
				 [0, 0, 4, 4, 1, 1, 1, 1, 1, 1, 1, 1, 1, 4, 0, 0],
				 [0, 0, 4, 1, 1, 1, 1, 4, 1, 1, 1, 4, 1, 4, 0, 0],
				 [0, 4, 1, 1, 1, 4, 4, 1, 4, 4, 1, 1, 1, 1, 4, 0],
				 [0, 4, 4, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 4, 1, 4],
				 [4, 1, 1, 4, 1, 1, 1, 1, 1, 1, 1, 4, 4, 1, 1, 4],
				 [4, 1, 1, 1, 4, 4, 1, 1, 1, 1, 1, 1, 1, 1, 1, 4],
				 [4, 4, 4, 1, 1, 1, 1, 1, 4, 1, 4, 1, 1, 1, 4, 4],
				 [0, 4, 4, 4, 1, 1, 1, 4, 4, 4, 4, 4, 4, 4, 4, 0],
				 [0, 0, 0, 4, 4, 4, 4, 4, 4, 5, 4, 4, 4, 4, 0, 0],
				 [0, 0, 0, 0, 4, 4, 4, 4, 5, 5, 4, 0, 4, 0, 0, 0],
				 [0, 0, 0, 0, 0, 4, 5, 5, 5, 5, 4, 0, 0, 0, 0, 0],
				 [0, 0, 0, 0, 4, 4, 5, 5, 4, 5, 5, 4, 0, 0, 0, 0],
				 [0, 0, 0, 4, 4, 5, 4, 5, 5, 4, 4, 5, 4, 0, 0, 0],
				 [0, 0, 0, 0, 4, 4, 4, 4, 4, 4, 4, 4, 0, 0, 0, 0]]
				,
				//Treasure
                [[4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4],
				 [4, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 4],
				 [4, 7, 6, 6, 7, 6, 6, 7, 7, 6, 6, 7, 6, 6, 7, 4],
				 [4, 7, 6, 6, 7, 6, 6, 7, 7, 6, 6, 7, 6, 6, 7, 4],
				 [4, 7, 6, 6, 7, 6, 6, 7, 7, 6, 6, 7, 6, 6, 7, 4],
				 [4, 7, 6, 6, 7, 6, 6, 7, 7, 6, 6, 7, 6, 6, 7, 4],
				 [4, 4, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 4, 4],
				 [4, 7, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 7, 4],
				 [4, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 4],
				 [4, 7, 6, 6, 7, 6, 7, 4, 4, 7, 6, 7, 6, 6, 7, 4],
				 [4, 7, 6, 6, 7, 6, 7, 7, 7, 7, 6, 7, 6, 6, 7, 4],
				 [4, 7, 6, 6, 7, 6, 6, 6, 6, 6, 6, 7, 6, 6, 7, 4],
				 [4, 7, 6, 6, 7, 6, 6, 6, 6, 6, 6, 7, 6, 6, 7, 4],
				 [4, 7, 6, 6, 7, 6, 6, 6, 6, 6, 6, 7, 6, 6, 7, 4],
				 [4, 4, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 4, 4],
				 [4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4]]
				,
				//Water
                [[ 8,10,10, 9, 9,10, 8, 8, 8,10,10, 9, 9,10, 8, 8],
				 [10,10, 9, 8, 8, 9,10,10,10,10, 9, 8, 8, 9, 8, 8],
				 [ 9, 9,10, 8,10,10,10, 8, 9, 9,10, 8,10,10,10, 8],
				 [ 8, 8, 9,10,10,10, 8, 9, 8, 8, 9,10,10,10, 8, 9],
				 [ 8, 8,10,10, 9, 9,10, 8, 8, 8,10,10, 9, 9,10, 8],
				 [10,10,10, 9, 8, 8, 9,10,10,10,10, 9, 8, 8, 9,10],
				 [ 8, 9, 9,10, 8,10,10,10, 8, 9, 9,10, 8,10,10,10],
				 [ 9, 8, 8, 9,10,10,10, 8, 9, 8, 8, 9,10,10,10, 8],
				 [ 9,10, 8, 8, 8,10,10, 9, 9,10, 8, 8, 8,10,10, 9],
				 [ 8, 9,10,10,10,10, 9, 8, 8, 9,10,10,10,10, 9, 8],
				 [10,10,10, 8, 9, 9,10, 8,10,10,10, 8, 9, 9,10, 8],
				 [10,10, 8, 9, 8, 8, 9,10,10,10, 8, 9, 8, 8, 9,10],
				 [ 9, 9,10, 8, 8, 8,10,10, 9, 9,10, 8, 8, 8,10,10],
				 [ 8, 8, 9,10,10,10,10, 9, 8, 8, 9,10,10,10,10, 8],
				 [ 8,10,10,10, 8, 9, 9,10, 8,10,10,10, 8, 9, 9,10],
				 [10,10,10, 8, 9, 8, 8, 9,10,10,10, 8, 9, 8, 8, 9]]
				 ];
				 
		public function Yuusha1():BitmapData{
            return BitmapPatternBuilder.build(
                [[0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0,  0, 0, 0, 0, 0, 0, 0, 4, 4, 4, 4, 4, 4, 4, 0, 0],
				 [0, 0, 0, 0, 2, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0,  0, 0, 0, 0, 0, 4, 4, 4, 4, 4, 4, 4, 4, 0, 4, 0],
				 [0, 2, 0, 3, 3, 2, 2, 1, 1, 1, 1, 0, 0, 0, 0, 0,  0, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 0, 0, 0, 0],
				 [0, 2, 1, 1, 1, 1, 1, 2, 2, 1, 1, 1, 0, 0, 0, 0,  0, 0, 0, 5, 5, 5, 4, 4, 4, 4, 4, 4, 0, 0, 0, 0],
				 [0, 2, 0, 1, 3, 3, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0,  0, 0, 0, 5, 5, 3, 5, 4, 4, 4, 4, 4, 4, 4, 4, 0],
				 [0, 2, 0, 0, 3, 1, 3, 1, 1, 3, 1, 1, 1, 0, 0, 0,  0, 0, 0, 0, 3, 5, 3, 5, 5, 5, 4, 4, 4, 0, 0, 0],
				 [0, 2, 0, 0, 3, 1, 3, 1, 1, 3, 1, 1, 0, 0, 0, 0,  0, 0, 0, 0, 3, 5, 3, 5, 5, 5, 5, 0, 0, 0, 0, 0],
				 [0, 2, 0, 0, 0, 3, 3, 1, 1, 1, 1, 0, 2, 2, 2, 0,  0, 0, 5, 5, 0, 3, 3, 5, 5, 5, 5, 0, 0, 0, 0, 0],
				 [0, 2, 2, 1, 1, 2, 2, 1, 2, 2, 2, 2, 1, 1, 1, 2,  0, 0, 5, 5, 0, 4, 5, 5, 4, 4, 4, 4, 0, 0, 0, 0],
				 [0, 2, 2, 1, 1, 1, 1, 1, 1, 1, 1, 2, 3, 3, 3, 2,  0, 0, 0, 3, 3, 4, 5, 4, 3, 4, 4, 0, 0, 0, 0, 0],
				 [1, 1, 3, 2, 1, 2, 2, 1, 1, 1, 2, 2, 1, 1, 1, 2,  0, 0, 0, 0, 5, 5, 3, 3, 4, 4, 5, 0, 0, 0, 0, 0],
				 [0, 3, 3, 1, 2, 3, 3, 2, 2, 2, 1, 2, 1, 1, 1, 2,  0, 0, 0, 0, 5, 5, 4, 4, 4, 4, 4, 5, 0, 0, 0, 0],
				 [0, 3, 1, 1, 1, 2, 2, 1, 1, 1, 1, 1, 2, 1, 2, 0,  0, 0, 0, 0, 0, 4, 4, 4, 4, 4, 4, 0, 0, 0, 0, 0],
				 [0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 2, 0, 0,  0, 0, 0, 0, 4, 4, 4, 4, 4, 4, 4, 0, 0, 0, 0, 0],
				 [0, 1, 1, 1, 1, 0, 0, 2, 2, 2, 2, 0, 0, 0, 0, 0,  0, 0, 0, 0, 4, 4, 4, 4, 4, 4, 4, 4, 0, 0, 0, 0],
				 [0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0,  0, 0, 0, 5, 5, 5, 4, 4, 4, 4, 4, 4, 4, 0, 0, 0]],
                [0x0, 0xFF0049DC, 0xFFFFFFFF, 0xFFFFC7B1, 0xFF47009F, 0xFF0073EF]
            );
        }
		
		public function Yuusha2():BitmapData{
            return BitmapPatternBuilder.build(
                [[0, 2, 0, 0, 0, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0,  0, 0, 0, 0, 0, 0, 0, 4, 4, 4, 4, 4, 4, 4, 0, 0],
				 [0, 2, 0, 0, 2, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0,  0, 0, 0, 0, 0, 4, 4, 4, 4, 4, 4, 4, 4, 0, 4, 0],
				 [0, 2, 0, 3, 3, 2, 2, 1, 1, 1, 1, 0, 0, 0, 0, 0,  0, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 0, 0, 0, 0],
				 [0, 2, 1, 1, 1, 1, 1, 2, 2, 1, 1, 1, 0, 0, 0, 0,  0, 0, 0, 5, 5, 5, 4, 4, 4, 4, 4, 4, 0, 0, 0, 0],
				 [0, 2, 0, 1, 3, 3, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0,  0, 0, 0, 5, 5, 3, 5, 4, 4, 4, 4, 4, 4, 4, 4, 0],
				 [0, 2, 0, 0, 3, 1, 3, 1, 1, 3, 1, 1, 1, 0, 0, 0,  0, 0, 0, 0, 3, 5, 3, 5, 5, 5, 4, 4, 4, 0, 0, 0],
				 [0, 2, 0, 0, 3, 1, 3, 1, 1, 3, 1, 1, 0, 0, 0, 0,  0, 0, 0, 0, 3, 5, 3, 5, 5, 5, 5, 0, 0, 0, 0, 0],
				 [0, 2, 0, 0, 0, 3, 3, 1, 1, 1, 1, 2, 2, 2, 0, 0,  0, 0, 0, 0, 0, 3, 3, 5, 5, 5, 5, 0, 0, 0, 0, 0],
				 [1, 1, 2, 1, 1, 2, 2, 1, 2, 2, 2, 1, 1, 1, 2, 0,  0, 0, 0, 5, 5, 4, 5, 5, 4, 4, 4, 4, 0, 0, 0, 0],
				 [0, 3, 2, 1, 1, 1, 1, 1, 1, 1, 2, 3, 3, 3, 2, 0,  0, 0, 0, 5, 5, 4, 5, 4, 3, 4, 4, 0, 0, 0, 0, 0],
				 [0, 3, 3, 2, 1, 2, 2, 1, 1, 1, 2, 1, 1, 1, 2, 0,  0, 0, 0, 0, 3, 3, 4, 4, 3, 4, 5, 0, 0, 0, 0, 0],
				 [0, 1, 0, 0, 2, 3, 3, 2, 2, 2, 2, 1, 1, 1, 2, 0,  0, 0, 0, 0, 0, 5, 5, 3, 4, 4, 4, 5, 0, 0, 0, 0],
				 [0, 0, 0, 1, 1, 2, 2, 1, 1, 1, 1, 2, 1, 2, 0, 0,  0, 0, 0, 0, 0, 5, 5, 4, 4, 4, 4, 0, 0, 0, 0, 0],
				 [0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 0, 0, 0,  0, 0, 0, 0, 4, 4, 4, 4, 4, 4, 4, 0, 0, 0, 0, 0],
				 [0, 0, 0, 2, 2, 2, 0, 1, 1, 1, 1, 1, 0, 0, 0, 0,  0, 0, 0, 0, 4, 4, 4, 4, 4, 4, 4, 4, 0, 0, 0, 0],
				 [0, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  0, 0, 0, 0, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 0, 0]],
                [0x0, 0xFF0049DC, 0xFFFFFFFF, 0xFFFFC7B1, 0xFF47009F, 0xFF0073EF]
            );
        }
    }
}

/**-----------------------------------------------------
 * Use following BitmapPatternBuilder class 
 * 
 * DO NOT CHANGE any codes below this comment.
 *
 * -----------------------------------------------------
*/
import flash.display.Bitmap;
import flash.display.BitmapData;
import flash.display.Graphics;
    
class BitmapPatternBuilder{
    /**
     * creates BitmapData filled with dot pattern.
     * First parameter is 2d array that contains color index for each pixels;
     * Second parameter contains color reference table.
     *
     * @parameter pattern:Array 2d array that contains color index for each pixel.
     * @parameter colors:Array 1d array that contains color table.
     * @returns BitmapData
     */
    public static function build(pattern:Array, colors:Array):BitmapData{
        var bitmapW:int = pattern[0].length;
        var bitmapH:int = pattern.length;
        var bmd:BitmapData = new BitmapData(bitmapW,bitmapH,true,0x000000);
        for(var yy:int=0; yy<bitmapH; yy++){
            for(var xx:int=0; xx<bitmapW; xx++){
                var color:int = colors[pattern[yy][xx]];
                bmd.setPixel32(xx, yy, color);
            }
        }
        return bmd;
    }
    
    /**
     * short cut function for Graphics.beginBitmapFill with pattern.
     */
    public static function beginBitmapFill(pattern:Array, colors:Array, graphics:Graphics):void{
        var bmd:BitmapData = build(pattern, colors);
        graphics.beginBitmapFill(bmd);
        bmd.dispose();        
    }
}