/**
 * Copyright kaikoga ( http://wonderfl.net/user/kaikoga )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/gN6N
 */

package {
	
	import flash.display.Sprite;
	import flash.display.MovieClip;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.text.TextField;
	import flash.text.TextFormat;
	import flash.utils.ByteArray;
	
	public class FlashTest extends Sprite {
		
		public function FlashTest() {
			check();
			var button:SpriteButton = new SpriteButton(100, 20, "再計算");
			this.addChild(button);
			button.y = this.stage.stageHeight - button.height;
			button.addEventListener(MouseEvent.CLICK, this.button_clickHandler);
		}
		
		private function button_clickHandler(event:MouseEvent):void {
			clearTrace();
			this.check();
		}
		
		public function check():void {
			const ITER:int = 50000;
			measure("空ループ", function():void {
				for (var i:int = 0; i < ITER; i++) {
					;
				}
			});
			measure("Object", function():void {
				for (var i:int = 0; i < ITER; i++) {
					var o:Object = {};
				}
			});
			measure("Array", function():void {
				for (var i:int = 0; i < ITER; i++) {
					var o:Array = [];
				}
			});
			measure("ByteArray", function():void {
				for (var i:int = 0; i < ITER; i++) {
					var o:ByteArray = new ByteArray();
				}
			});
			measure("Date", function():void {
				for (var i:int = 0; i < ITER; i++) {
					var o:Date = new Date();
				}
			});
			measure("XML", function():void {
				for (var i:int = 0; i < ITER; i++) {
					var o:XML = new XML();
				}
			});
			measure("Error", function():void {
				for (var i:int = 0; i < ITER; i++) {
					var o:Error = new Error();
				}
			});
			measure("Event", function():void {
				for (var i:int = 0; i < ITER; i++) {
					var o:Event = new Event("");
				}
			});
			measure("Sprite", function():void {
				for (var i:int = 0; i < ITER; i++) {
					var o:Sprite = new Sprite();
				}
			});
			measure("MovieClip", function():void {
				for (var i:int = 0; i < ITER; i++) {
					var o:MovieClip = new MovieClip();
				}
			});
			measure("TextField", function():void {
				for (var i:int = 0; i < ITER; i++) {
					var o:TextField = new TextField();
				}
			});
		}
		
		private var _measureDate:Date;
		private var _measureTitle:String;
		public function startMeasure(title:String):void {
			this._measureDate = new Date();
			this._measureTitle = title;
		}
		public function endMeasure():void {
			var ms:Number = new Date().time - this._measureDate.time;
			this.trace(this._measureTitle, ":", ms + "ms");
		}
		public function measure(title:String, func:Function):void {
			this.startMeasure(title);
			func();
			this.endMeasure();
		}
		
		private var _traceField:TextField;
		public function trace(...message):void {
			if (!this._traceField) {
				this._traceField = new TextField();
				this._traceField.width = this.stage.stageWidth;
				this._traceField.height = this.stage.stageHeight;
				this._traceField.defaultTextFormat = new TextFormat("_typewriter", 10);
				this.addChild(this._traceField);
			}
			this._traceField.appendText(message.join(" ") + "\n");
		}
		
		public function clearTrace():void {
			if (this._traceField) {
				this._traceField.text = "";
			}
		}
		
	}

}

import flash.display.Sprite;
import flash.text.TextField;
import flash.text.TextFormat;

class SpriteButton extends Sprite {

	public function SpriteButton(width:Number, height:Number, text:String):void {
		super();
		
		this.graphics.lineStyle(1, 0x664422);
		this.graphics.beginFill(0xffcc99);
		this.graphics.drawRoundRect(0, 0, width, height, 8);
		
		var textField:TextField = new TextField();
		textField.width = width;
		textField.height = height;
		textField.defaultTextFormat = new TextFormat("_typewriter", 10, null, null, null, null, null, null, "center");
		textField.text = text;
		this.addChild(textField);
		
		this.mouseChildren = false;
		this.buttonMode = true;
	}
	
}
