/**
 * Copyright designerheera ( http://wonderfl.net/user/designerheera )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/gMxg
 */

// forked from clockmaker's [Alternativa3D] Negi Miku
package
{
    /**
     * Alternativa3D で3Dモデルを読み込むテスト
     * マウスドラッグでミクを回せます
     * 
     * ライブラリでサポートしているファイルは「3DS」と「OBJ」(Colladaは対応していない)
     * このサンプルでは3dsファイルを読み込んでいます
     * 
     * 3Dデータはnote.xさんのところのズサさんご提供のものを使用しています。
     *　http://blog.r3c7.net/?p=121
     *　※ColladaファイルをBlenderで3DSファイルに変換したものを使用
     * ↑
     * この記事のデモと速度や表示を比較してみるといいかも
     */
    import alternativ5.engine3d.controllers.*;
    import alternativ5.engine3d.core.*;
    import alternativ5.engine3d.display.*;
    import alternativ5.engine3d.loaders.*;
    import alternativ5.engine3d.materials.*;
    import alternativ5.engine3d.primitives.*;
    import alternativ5.types.*;
    import alternativ5.utils.*;
    import flash.system.LoaderContext;
    import flash.net.*;
    import flash.display.*;
    import flash.events.*;
    import flash.geom.*;
    import flash.utils.*;

    public class Main extends Sprite
    {
        private var scene:Scene3D;
        private var view:View;
        private var camera:Camera3D;
        private var loader:Loader3DS;
        
        // The camera controller
        private var controller:CameraController;
        
        public function Main()
        {
            stage.scaleMode = StageScaleMode.NO_SCALE;
            stage.align = StageAlign.TOP_LEFT;
            stage.quality = StageQuality.LOW;
            
            // Creating scene
            scene = new Scene3D();
            scene.root = new Object3D();
            
            var context:LoaderContext = new LoaderContext();
            
            loader = new Loader3DS();
            loader.addEventListener(Event.COMPLETE, loadCompleteHandler);
            loader.load("http://clockmaker.jp/labs/090807_alternativa3d/test.3ds", context);
            
            // Adding camera
            camera = new Camera3D();
            scene.root.addChild(camera);
            
            // set camera controller
            controller = new CameraController(stage);
            controller.camera = camera;
            
            controller.checkCollisions = false;
            controller.controlsEnabled = false;

            // set view
            view = new View();
            addChild(view);
            view.camera = camera;
            
            // FPS display launch
            FPS.init(stage);
            
            stage.addEventListener(Event.RESIZE, onResize);
            onResize(null);
            singleRender(null);
            
            // mouse interactive
            stage.addEventListener(MouseEvent.MOUSE_DOWN, onMouseDown);
            stage.addEventListener(MouseEvent.MOUSE_MOVE, onMouseMove);
            stage.addEventListener(MouseEvent.MOUSE_UP, onMouseUp);
        }
        
        private function loadCompleteHandler(e:Event):void 
        {
            scene.root.addChild(loader.content);
            loader.content.scaleX = loader.content.scaleY = loader.content.scaleZ = 20;
            singleRender(null)
        }
        
        private function singleRender(e:Event):void
        {
            // Mouse Interactive
            camera.x = 500 * Math.sin(cameraYaw * Math.PI / 180);
            camera.y = 500 * Math.cos(cameraYaw * Math.PI / 180);
            camera.z = cameraPitch;
            
            controller.lookAt(new Point3D(0, 0, 0));
            
            // Scene calculating
            scene.calculate();
        }
        
        /**
         * Resize Handler
         */
        private function onResize(e:Event):void
        {
            view.width = stage.stageWidth;
            view.height = stage.stageHeight;
            
            // BackGround Color
            var bgMatrix:Matrix = new Matrix();
            bgMatrix.rotate(90 * Math.PI / 180);
            graphics.clear()
            graphics.beginGradientFill("linear", [0xFFFFFF, 0x220011], [100, 100], [0, 255], bgMatrix);
            graphics.drawRect(0, 0, stage.stageWidth, stage.stageHeight);
        }
        
        // ----------------------------------------------
        // Mouse Interactive
        // ----------------------------------------------
        
        private var isOribiting:Boolean;
        private var cameraPitch:Number = 200;
        private var cameraYaw:Number = 180;
        private var previousMouseX:Number;
        private var previousMouseY:Number;
        
        private function onMouseDown(event:MouseEvent):void
        {
            isOribiting = true;
            previousMouseX = event.stageX;
            previousMouseY = event.stageY;
            stage.quality = StageQuality.MEDIUM;
        }
 
        private function onMouseUp(event:MouseEvent):void
        {
            isOribiting = false;
            stage.quality = StageQuality.HIGH;
            singleRender(null);
        }
 
        private function onMouseMove(event:MouseEvent):void
        {
            var differenceX:Number = event.stageX - previousMouseX;
            var differenceY:Number = event.stageY - previousMouseY;
 
            if(isOribiting)
            {
                cameraPitch += differenceY;
                cameraYaw += differenceX * 0.25;
 
                previousMouseX = event.stageX;
                previousMouseY = event.stageY;
                
                singleRender(null);
            }
        }
    }
}