/**
 * Copyright yd_niku ( http://wonderfl.net/user/yd_niku )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/gM5V
 */

package {
    import flash.text.TextField;
    import flash.display.*;
    import flash.geom.*;
    import flash.events.*;
    
    public class FlashTest extends Sprite {
        private var _points:Vector.<Vector3D>;
        private var _mat:Matrix3D;
        
        [SWF(background=0xFFFFFF, frameRate=60)]
        public function FlashTest() {
            //stage.quality = StageQuality.LOW;
            
            _points = new Vector.<Vector3D>();
            
            var sx:Number,sy:Number, sz:Number; 
            for( var i:int = 0; i<100; ++i ) {
                sx = (Math.random()-0.5) * 300;
                sy = (Math.random()-0.5) * 300;
                sz = (Math.random()-0.5) * 300;
                _points.push(new Vector3D(sx,sy,sz));
            }
            
            _mat = new Matrix3D();
            
            updateDisplay();
            
            addEventListener( Event.ENTER_FRAME, loop );
        }
        
        private function loop(e:Event):void{
            _mat.appendRotation(1,Vector3D.X_AXIS);
            _mat.appendRotation(1,Vector3D.Y_AXIS);
            _mat.appendScale(1.001,1.001,1.001);
            updateDisplay();
        }
        private function updateDisplay():void{ 
            graphics.clear();
            for each( var p:Vector3D in _points ) {
                var tp:Vector3D = Utils3D.projectVector( _mat, p );
                graphics.beginFill(0);
                graphics.drawCircle(tp.x+232,tp.y+232,3);
                graphics.endFill();
            }
        }
    }
}