/**
 * Copyright arithma ( http://wonderfl.net/user/arithma )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/gLav
 */

package {
    // http://mskafi.blogspot.com
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.KeyboardEvent;
    import flash.ui.Keyboard;
    import flash.utils.getTimer;
    
    public class Main extends Sprite {
        private var ship:Sprite;
        
        private var velx:Number;
        private var vely:Number;
        private var velr:Number;
        
        private var thrust:Boolean;
        private var left:Boolean;
        private var right:Boolean;
        
        private var timer:int;
        
        public function Main() {
            ship = createShip();
            addChild(ship);
            
            ship.x = stage.stageWidth * .5;
            ship.y = stage.stageHeight * .5;
            
            velx = 0;
            vely = 0;
            velr = 0;
            
            thrust = false;
            left = false;
            right = false;
            
            stage.addEventListener(KeyboardEvent.KEY_DOWN, _key);
            stage.addEventListener(KeyboardEvent.KEY_UP, _key);
            addEventListener(Event.ENTER_FRAME, _frame);
            
            timer = getTimer();
            stage.frameRate = 120;
        }
        
        private function _frame(e:Event):void {
            var temp:Number = getTimer();
            var dt:Number = (temp - timer) / 1000;
            timer = temp;
            
            var rot:Number = ship.rotation / 180 * Math.PI;
            const THRUST:Number = 80;
            const ROT:Number = 5;
            if (thrust) {
                velx += Math.cos(rot) * THRUST * dt;
                vely += Math.sin(rot) * THRUST * dt;
            }
            if (left) {
                velr -= ROT * dt;
            }
            if (right) {
                velr += ROT * dt;
            }
            
            ship.x += velx * dt;
            ship.y += vely * dt;
            ship.rotation += velr * dt * 180 / Math.PI;
            
            if (ship.x < 0) ship.x += stage.stageWidth;
            if (ship.y < 0) ship.y += stage.stageHeight;
            if (ship.x > stage.stageWidth) ship.x -= stage.stageWidth;
            if (ship.y > stage.stageHeight) ship.y -= stage.stageHeight;
        }
        
        private function _key(e:KeyboardEvent):void {
            var state:Boolean = e.type == KeyboardEvent.KEY_DOWN;
            if (e.keyCode == Keyboard.UP)
                thrust = state;
            else if (e.keyCode == Keyboard.LEFT)
                left = state;
            else if (e.keyCode == Keyboard.RIGHT)
                right = state;
        }
        
        private function createShip():Sprite {
            var ship:Sprite = new Sprite();
            ship.graphics.beginFill(0);
            ship.graphics.moveTo(-5, +5);
            ship.graphics.lineTo(-5, -5);
            ship.graphics.lineTo( +10, +0);
            
            return ship;
        }
    }
}