/**
 * Copyright tkinjo ( http://wonderfl.net/user/tkinjo )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/gKgV
 */

// forked from tkinjo's Yahoo Pipes Flickr Module
package {
    import flash.display.*;
    import flash.events.*;
    import flash.filters.*;
    import flash.net.*;
    import flash.utils.*;
    import org.libspark.betweenas3.*;
    import flash.geom.*;

    [SWF(width="465", height="465", backgroundColor="0x000000", frameRate="60")] 
    /**
     * ...
     * @author tkinjo
     */
    public class Main extends Sprite
    {
        //private const BASE_URL:String = "http://pipes.yahoo.com/pipes/pipe.run?_id=08f23301b0f331eea4b1f44693fba4f8&_render=rss";
        private const BASE_URL:String = "http://pipes.yahooapis.com/pipes/pipe.run?_id=08f23301b0f331eea4b1f44693fba4f8&_render=rss";
        private const URL_PARAM:Array = new Array();
        private const FIND:uint = 10;
        private const IMAGES_OF:String = "graphics";
        private const IMAGE_WIDTH:Number = 75;
        
        private const THUMBNAIL_LIST_OFFSET:Number = 75;
        private const THUMBNAIL_LIST_PADDING:Number = 2;
        private const REFLECTION_OFFSET:Number = 2;
        
        private var numHorizontalImage:uint;
        
        private var URL:String = BASE_URL + "&find=" + FIND + "&images_of=" + escapeMultiByte( IMAGES_OF );
        
        private var FLASH_SPEED:Number = 0.2;
        private var FLASH_VALUE:Number = 0.5;
        
        private var thumbnailList:Sprite = new Sprite();
        
        private var i:uint = 0;
        
        public function Main()
        {
            numHorizontalImage = stage.stageWidth / 75;
            addChild( thumbnailList );
            
            var urlRequest:URLRequest = new URLRequest( URL );
            var urlLoader:URLLoader = new URLLoader();
            
            try {
                urlLoader.load( urlRequest );
            }
            catch (error:SecurityError)
            {
                trace("A SecurityError has occurred.");
                return;
            }
            
            urlLoader.addEventListener( Event.COMPLETE, completeHandler );
            
            stage.addEventListener(Event.ENTER_FRAME, enterFrameHandler);
        }
        
        private function enterFrameHandler( event:Event ):void {
            
            if ( thumbnailList.width > stage.stageWidth )
                thumbnailList.x += ( - stage.mouseX / stage.stageWidth * ( thumbnailList.width + THUMBNAIL_LIST_OFFSET * 2 - stage.stageWidth ) + THUMBNAIL_LIST_OFFSET - thumbnailList.x ) * 0.1;
                
            else 
                thumbnailList.x = 0;
        }
        
        private function completeHandler( event:Event ):void {
            
            var urlLoader:URLLoader = event.currentTarget as URLLoader;
            
            try {
                var rss:XML = new XML(urlLoader.data);
                trace( rss );
            }
            catch (error:SecurityError)
            {
                trace("error.");
                return;
            }
            
            var i:uint = 0;
            var media:Namespace = rss.namespace( "media" );
            
            for each( var item:XML in rss.channel.item ){
                
                var thumbnailUrl:String = item.media::group.media::thumbnail.@url;
                var contentUrl:String = item.media::group.media::content.@url;
                
                var thumbnailButton:ThumbnailButton = new ThumbnailButton( thumbnailUrl, contentUrl );
                thumbnailButton.x = i * ( IMAGE_WIDTH + THUMBNAIL_LIST_PADDING );
                thumbnailList.addChild( thumbnailButton );
                
                i++;
            }
        }
    }
}

import flash.display.*;
import flash.geom.*;
import org.libspark.betweenas3.tweens.ITween;
import org.libspark.betweenas3.BetweenAS3;
import flash.events.*;
import flash.net.*;
import flash.system.*;

class ThumbnailButton extends Sprite {
    
    private var thumbnailUrl:String;
    private var contentUrl:String;
    
    private var thumbnailLoader:Loader;
    private var reflectedThumbnailLoader:Loader;
    
    private var _brightness:Number = 0;
    
    public function get brightness():Number {
        
        return _brightness;
    }
    
    public function set brightness( value:Number ):void {
        
        _brightness = value;
        transform.colorTransform = new ColorTransform( 1, 1, 1, 1, 255 * brightness, 255 * brightness, 255 * brightness );
    }
    
    
    
    private var tween:ITween;
    public var turnOnSpeed:Number = 0.2;
    public var turnOffSpeed:Number = 0.5;
    public var maxFlashValue:Number = 0.5;
    public var reflectionOffset:Number = 2;
    
    
    public function ThumbnailButton( thumbnailUrl:String, contentUrl:String ):void {
        
        this.thumbnailUrl = thumbnailUrl;
        this.contentUrl = contentUrl;
        
        var urlRequest:URLRequest = new URLRequest( thumbnailUrl );
        
        thumbnailLoader = new Loader();
        thumbnailLoader.contentLoaderInfo.addEventListener( Event.COMPLETE, thumbnailLoadCompleteHandler );
        thumbnailLoader.load( urlRequest, new LoaderContext( true ) );
        
        reflectedThumbnailLoader = new Loader();
        reflectedThumbnailLoader.contentLoaderInfo.addEventListener( Event.COMPLETE, thumbnailLoadCompleteHandler );
        reflectedThumbnailLoader.load( urlRequest, new LoaderContext( true ) );
    }
    
    private function thumbnailLoadCompleteHandler( event:Event ):void {
        
        if ( !( thumbnailLoader.width && reflectedThumbnailLoader.width ) )
            return;
        
        // image
        var thumbnail:Sprite = new Sprite();
        thumbnail.addChild( thumbnailLoader );
        thumbnail.buttonMode = true;
        addChild( thumbnail );
        
        // reflection
        var reftectionMask:Sprite = createReflectionMask( thumbnail.width, thumbnail.height / 2 );
        reflectedThumbnailLoader.scaleY = -1;
        reflectedThumbnailLoader.y = thumbnail.height * 2 + reflectionOffset;
        reflectedThumbnailLoader.cacheAsBitmap = true;
        reflectedThumbnailLoader.mask = reftectionMask;
        reftectionMask.y = reflectedThumbnailLoader.y - thumbnail.height;
        reftectionMask.alpha = 0.5;
        addChild( reflectedThumbnailLoader );
        addChild( reftectionMask );
        
        BetweenAS3.tween( this, { alpha:1 }, { alpha:0 } ).play();
        
        thumbnail.addEventListener(MouseEvent.MOUSE_OVER, thumbnailMouseOverHandler);
        thumbnail.addEventListener(MouseEvent.MOUSE_OUT, thumbnailMouseOutHandler);
    }
    
    private function thumbnailMouseOverHandler( event:MouseEvent ):void {
        
        if ( tween )
            tween.stop();
        tween = BetweenAS3.tween( this, { brightness:maxFlashValue }, null, turnOnSpeed );
        tween.play();
    }
    
    private function thumbnailMouseOutHandler( event:MouseEvent ):void {
        
        if ( tween )
            tween.stop();
        tween = BetweenAS3.tween( this, { brightness:0 }, null, turnOffSpeed );
        tween.play();
    }
}

class ImageListLoader {
    
}

function createReflectionMask( width:Number, height:Number ):Sprite {
    
    var reflectionMask:Sprite = new Sprite();
    
    var reflectionMatrix:Matrix = new Matrix();
    reflectionMatrix.createGradientBox( width, height, Math.PI / 2, 0, 0 );
    
    reflectionMask.graphics.beginGradientFill( GradientType.LINEAR, [ 0, 0 ], [ 1, 0 ], [ 0, 255 ], reflectionMatrix );
    reflectionMask.graphics.drawRect( 0, 0, width, height );
    reflectionMask.graphics.endFill();
    
    reflectionMask.cacheAsBitmap = true;
    
    return reflectionMask;
}
/*
function createReflectionImage( image:DisplayObject ):Sprite {
    
    var reflectionImageContainer:Sprite = new Sprite();
    
    var imageBitmapData:BitmapData = new BitmapData( image.width, image.height, true, 0 );
    
    var reflectionMatrix:Matrix = new Matrix();
    reflectionMatrix.scale( 1, -1 );
    reflectionMatrix.translate( 0, image.height );
    imageBitmapData.draw( image, reflectionMatrix );
    
    var reflectionImage:Bitmap = new Bitmap( imageBitmapData );
    reflectionImage.cacheAsBitmap = true;
    
    var reflectionMask:Sprite = createReflectionMask( image.width, image.height / 2 );
    reflectionImageContainer.addChild( reflectionMask );
    
    reflectionImage.mask = reflectionMask;
    reflectionImageContainer.addChild( reflectionImage );
    
    return reflectionImageContainer;
}//*/