/**
 * Copyright lizhi ( http://wonderfl.net/user/lizhi )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/gKXJ
 */

package  
{
    import flash.display.GradientType;
    import flash.display.Sprite;
    import flash.events.MouseEvent;
    import flash.filters.DropShadowFilter;
    import flash.geom.Matrix;
    /**
     * ...
     * @author lizhi http://game-develop.net/
     */
    public class TestDraw extends Sprite
    {
        private var lxl:Number;
        private var lyl:Number;
        private var lxr:Number;
        private var lyr:Number;
        private var lx:Number;
        private var ly:Number;
        public function TestDraw() 
        {
            stage.addEventListener(MouseEvent.MOUSE_DOWN, stage_mouseDown);
            filters = [new DropShadowFilter(10,90,0,0.1,4,4,1,3)];
        }
        
        private function stage_mouseDown(e:MouseEvent):void 
        {
            stage.addEventListener(MouseEvent.MOUSE_UP, stage_mouseUp);
            stage.addEventListener(MouseEvent.MOUSE_MOVE, stage_mouseMove);
            lx=lxl=lxr = mouseX;
            ly=lyl=lyr = mouseY;
        }
        
        private function stage_mouseMove(e:MouseEvent):void 
        {
            drawLine(mouseX, mouseY);
        }
        
        private function stage_mouseUp(e:MouseEvent):void 
        {
            stage.removeEventListener(MouseEvent.MOUSE_UP, stage_mouseUp);
            stage.removeEventListener(MouseEvent.MOUSE_MOVE, stage_mouseMove);
        }
        public function drawLine(x:Number, y:Number):void {
            var hw:Number = 6;
            var matr:Matrix = new Matrix;
            var a:Number = Math.atan2(y - ly, x - lx) + Math.PI / 2;
            matr.createGradientBox(hw*2, hw*2,a,lx-hw,ly-hw);
            var dx:Number = hw * Math.cos(a);
            var dy:Number = hw * Math.sin(a);
            var xr:Number=x+dx;
            var yr:Number=y+dy;
            var xl:Number=x-dx;
            var yl:Number=y-dy;
            graphics.beginGradientFill(GradientType.LINEAR, [0, 0xff00], [1, 1], [0, 0xff], matr);
            graphics.moveTo(lxr, lyr);
            graphics.lineTo(xr, yr);
            graphics.lineTo(xl, yl);
            graphics.lineTo(lxl, lyl);
            graphics.lineTo(lxr, lyr);
            graphics.endFill();
            
            lx = x;
            ly = y;
            lxr = xr;
            lyr = yr;
            lxl = xl;
            lyl = yl;
        }
    }

}