/**
 * Copyright bradsedito ( http://wonderfl.net/user/bradsedito )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/gKOE
 */

// forked from termat's Smoke
/*
 Smoke  http://termat.sakura.ne.jp/
*/
package 
{
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.filters.BlurFilter;
    import flash.geom.Point;
    import net.hires.debug.Stats;

    [SWF(width = "480", height = "480", backgroundColor = "0x000000", fps = "30")] 
    public class Practice63 extends Sprite {
        private var bitmap:BitmapData;
        private var blur:BlurFilter;
        private var particles:Array;
        private var spring:Array;
        private var counter:Array;
        private var deff:Number = 40.0;
        private var isDown:Boolean = false;
        private var colors:Array = [0xffffffff, 0xffffcdff, 0xffbebebe, 0xffc7c7c7, 0xffaaaaaa];
        private var rad:Number = 0.0;
    
        public function Practice63():void {
            bitmap = new BitmapData(stage.stageWidth, stage.stageHeight, false, 0x000000);
            addChild(new Bitmap(bitmap));
            blur = new BlurFilter(4, 4, 3);
            particles = new Array();
            spring = new Array();
            counter = new Array();
            addEventListener(Event.ENTER_FRAME, update);
            addChild(new Stats());
            Wonderfl.capture_delay(20);
        }
        
        private function update(e:Event):void {
            spring.push(new Point(Math.cos(rad)*200+240,mouseY));
            counter.push(0);
            rad += 0.05;
            for (var j:int = 0; j < spring.length; j++ ) {
                var sp:Point = spring.shift();
                var ct:int = counter.shift();
                var xx:Number = sp.x + deff * Math.random() - deff/2.0;
                var yy:Number = sp.y + deff * Math.random() - deff/2.0;
                var px:Particle = new Particle(xx, yy, colors[particles.length % colors.length]);
                particles.push(px);
                if (ct < 20) {
                    spring.push(sp);
                    counter.push(ct + 1);
                }
            }
            for (var i:int = 0; i < particles.length; i++) {
                var p:Particle = particles.shift();
                if (p.alive) {
                    p.update(bitmap);
                    particles.push(p);
                }
            }
            bitmap.applyFilter(bitmap, bitmap.rect, new Point(0, 0), blur);
        }
    }
}

import flash.display.BitmapData;

class Particle {
    public static const G:Number = -0.098/2.0;
    public const K:Number = 0.01;
    public var x:Number;
    public var y:Number;
    public var vx:Number;
    public var vy:Number;
    public var color:uint;
    public var alive:Boolean = false;
    
    public function Particle(_x:int,_y:int,_c:uint):void {
        x = _x;
        y = _y;
        color = _c;
        vx = 0;
        vy = 0;
        alive = true;
    }
    
    public function update(bitmap:BitmapData):void {
        x += vx;
        y += vy;
        bitmap.setPixel(x, y, color);
        var a:Number = G - vy * K;
        vy += a;
        if (y > 480 || y < 0) alive = false;
    }
}