/**
 * Copyright bradsedito ( http://wonderfl.net/user/bradsedito )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/gKHR
 */

// forked from yshu's patterns
package 
{
    import flash.display.BitmapData;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.geom.Rectangle;

    public class Main extends Sprite 
    {
        private var bmd:BitmapData;
        private var index:int = 0;
        private var colors:Array = [0x222222,0x333333]
        private var patterns:Array =
        [
            {w:4, h:6, r:[
                [new Rectangle(0, 0, 1, 2),1],
                [new Rectangle(0, 3, 1, 3),1],
                [new Rectangle(2, 0, 1, 5),1],
            ]},
            {w:8, h:8, r:[
                [new Rectangle(0, 0, 2, 6), 1],
                [new Rectangle(4, 0, 2, 2), 1],
                [new Rectangle(4, 4, 2, 4), 1],
            ]},
            {w:5, h:5, r:[
                [new Rectangle(0, 0, 2, 2), 1]
            ]},
            {w:10, h:8, r:[
                [new Rectangle(0, 0, 1, 8), 0],
                [new Rectangle(1, 0, 5, 1), 0],
                [new Rectangle(5, 0, 1, 8), 0],
                [new Rectangle(6, 4, 4, 1), 0],
                
                [new Rectangle(2, 2, 2, 5), 1],
                [new Rectangle(7, 0, 2, 3), 1],
                [new Rectangle(7, 6, 2, 2), 1]
            ]},
            {w:6, h:6, r:[
                [new Rectangle(0, 0, 5, 5), 0]
            ]},
            {w:10, h:10, r:[
                [new Rectangle(0, 0, 2, 6), 0],
                [new Rectangle(0, 7, 4, 2), 0],
                [new Rectangle(5, 0, 2, 1), 0],
                [new Rectangle(3, 2, 6, 2), 0],
                [new Rectangle(5, 5, 2, 6), 0],
                [new Rectangle(8, 7, 2, 2), 0],

                [new Rectangle(0, 2, 2, 2), 1],
                [new Rectangle(0, 7, 2, 2), 1],
                [new Rectangle(5, 2, 2, 2), 1],
                [new Rectangle(5, 7, 2, 2), 1]
            ]}
        ]

        public function Main():void 
        {
            stage.align = 'TL'
            stage.scaleMode = 'noScale'
            stage.addEventListener(MouseEvent.CLICK, onClick)
            stage.addEventListener(Event.RESIZE, onStageResize)
            render()
        }
        
        private function onClick(e:MouseEvent):void 
        {
            if(e.shiftKey) colors = [0xffffff*Math.random(),0xffffff*Math.random()]
            else if (++index == patterns.length) index = 0
            render()
        }
        
        private function render():void
        {
            var p:Object = patterns[index]
            bmd = new BitmapData(p.w, p.h, false, 0)
            for (var i:int = 0; i < p.r.length; i++) bmd.fillRect.call(this,p.r[i][0],colors[p.r[i][1]])
            onStageResize()
        }

        private function onStageResize(e:Event=null):void 
        {
            graphics.clear()
            graphics.beginBitmapFill(bmd, null, true, true)
            graphics.drawRect(0, 0, stage.stageWidth, stage.stageHeight)
        }
    }
}