/**
 * Copyright pykgg476 ( http://wonderfl.net/user/pykgg476 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/gK42
 */

//左クリックでスプレー噴射。一度ボタンを離すと色がランダムに変わる。
//ホイールを回転させるとスプレーの範囲が変わる。
//ダブルクリックでリセット。

//（問題点）マウスホイールを動かすと、スクロールしてしまう…。どうにかできないものか。



package {
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.MouseEvent;

	public class SprayPaint extends Sprite
	{
		private var canvas:BitmapData;
		private var color:uint;
		private var size:Number = 50;
		private var density:Number = 150;
		var bmp:Bitmap
		
		
		public function SprayPaint()
		{
			init();
		}
		
		private function init():void{
			stage.doubleClickEnabled = true;
			canvas = new BitmapData(stage.stageWidth,stage.stageHeight,true,0x00000000);
			bmp = new Bitmap(canvas);
			addChild(bmp);
			stage.addEventListener(MouseEvent.MOUSE_DOWN,onMouseDown);
			stage.addEventListener(MouseEvent.MOUSE_UP,onMouseUp);
			stage.addEventListener(MouseEvent.MOUSE_WHEEL,Wheel);
			stage.addEventListener(MouseEvent.DOUBLE_CLICK,onMouseDouble);
		}
		
		private function onMouseDouble(event:MouseEvent):void{
			
			removeChild(bmp);
			canvas = new BitmapData(stage.stageWidth,stage.stageHeight,true,0x00000000);
			bmp = new Bitmap(canvas);
			addChild(bmp);			
			
		}
		
		private function Wheel(event:MouseEvent):void{

			
			
			if(event.delta<0){
				
				if(size-1!=0){
					size--;
					
				}
				
			}else{
				
				if(size<200){
					
					size++;
					
				}
			}
			
			
		}
		
		private function onMouseDown(event:MouseEvent):void{
			color = Math.random() * 0xffffff + 0xff000000;
			addEventListener(Event.ENTER_FRAME,onEnterFrame);
		}
		
		private function onMouseUp(event:MouseEvent):void{
			removeEventListener(Event.ENTER_FRAME,onEnterFrame);
		}
		
		private function onEnterFrame(event:Event):void{
			for(var i:int = 0;i<density; i++){
				var angle:Number = Math.random() * Math.PI * 2;
				var radius:Number = Math.random() * size;
				var xpos:Number = mouseX +Math.cos(angle) * radius;
				var ypos:Number = mouseY + Math.sin(angle)* radius;
				canvas.setPixel32(xpos,ypos,color);
			}
		}
	}
}
