/**
 * Copyright zendenmushi ( http://wonderfl.net/user/zendenmushi )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/gJtX
 */

// forked from munegon's 重力マウス（引力斥力クリック切り替え）
// forked from clockmaker's 重力マウス（プチ軽量化：10万パーティクル）
// forked from coppieee's 重力マウス（さらに軽量化してみた）
// forked from paq's forked from: 重力マウス（ちょっぴり軽量化してみた）
// forked from fumix's 重力マウス（リンクリストにしてみた）
// forked from undo's 重力マウス
//　リンクリストにしてみたけどそんなに速くない？？
//_bmd.fillRect()を_bmd.setPixel()に変更。
//sin(),cos(),atan2(),sqrt()を排除。
// Add final class / mouseEnalbled = false by clockmaker
// クリックごとに引力と斥力を切り替えるようにしてみた
package
{
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Sprite;
    import flash.display.StageAlign;
    import flash.display.StageScaleMode;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.geom.ColorTransform;
    import flash.geom.Point;
    import flash.geom.Rectangle;
    import net.hires.debug.Stats;

    [SWF(frameRate='60', width='465', height='465', backgroundColor='0x0')]

    import flash.utils.Dictionary;
    import flash.accessibility.Accessibility;
    public class ParticleTest1 extends Sprite
    {
        private const ATTRACTIVE_CTF:ColorTransform = new ColorTransform(0.7, 0.8, 0.96, 1.0);
        private const REPULSIVE_CTF:ColorTransform = new ColorTransform(0.96, 0.8, 0.7, 1.0);
        
        private var _bmp:Bitmap;
        private var _bmd:BitmapData;
        private var _bmdRect:Rectangle;
        private var _colorTransform:ColorTransform = ATTRACTIVE_CTF;
        
        private var _force:Number = 200;
        private var _first:Node;
        private var _maxNum:int = 200000; // 20万パーティクルでも45fpsぐらいでる
        private var _cnt:int = 0;
        
        private var _mousePos : Point = new Point();

        public function ParticleTest1()
        {
            if(stage) init(null);
            else addEventListener(Event.ADDED_TO_STAGE, init);
            return;
        }

        private function init(evt:Event):void
        {
            removeEventListener(Event.ADDED_TO_STAGE, init);
            
            this.stage.align = StageAlign.TOP_LEFT;
            this.stage.scaleMode = StageScaleMode.NO_SCALE;
            this.stage.quality = "low";
            this.stage.frameRate = 120;
            this.mouseEnabled = false;
            this.mouseChildren = false;
        
            var old:Node;

            _bmd = new BitmapData(465, 465, false, 0x000000);
            _bmp = new Bitmap(_bmd);
            addChild(_bmp);
            this._bmdRect = _bmd.rect;

            for (var i:int = 0; i < this._maxNum; i++)
            {
                var n:Node = new Node();
                n.pos_x = Math.random() * 465 >> 0;
                n.pos_y = Math.random() * 465 >> 0;
                var r : Number = Math.random();
                if (Math.random() < 0.8) {
                  n.weight = r < 1/16 ? 1/16+Math.random()/32 : r < 1/8 ? 1/8+Math.random()/16 : r < 1/4 ? 1/4+Math.random()/8 : 1/2;
                } else {
                  n.weight  = r < 1/2 ? r : r/2;
                }
                var cr : uint = Math.min(255, Math.random()*100+128);
                var cg : uint = Math.min(255, Math.random()*100+128);
                var cb : uint = Math.min(255, Math.random()*127+128);
                n.color = (cb << 16) | (cg << 8) | (cr << 0);
                
                 //リンクリスト
                if (_first == null) {
                    old = _first = n;
                } else {
                    old.next = n;
                    old = n;
                }
            }
            
            _mousePos.x = stage.stageWidth/2;
            _mousePos.y = stage.stageHeight/2;
            
            addChild(new Stats());
            addEventListener(Event.ENTER_FRAME, onEnter);
            stage.addEventListener(MouseEvent.CLICK, switchForce );
            stage.addEventListener(MouseEvent.MOUSE_MOVE, mouseMove );
        }
        
        private function mouseMove(e : MouseEvent) : void
        {
            _mousePos.x = e.stageX;
            _mousePos.y = e.stageY;
        }

        private function onEnter(evt:Event):void
        {
            var gravPoint_x:Number = _mousePos.x + Math.random()*16;
            var gravPoint_y:Number = _mousePos.y + Math.random()*16;
            var n:Node = _first;
            var calc:Boolean =  true;//_cnt % 4 == 0;
            
            this._bmd.lock();
            do
            {
                // 4回に1回ぐらいの処理に
                if(calc){
                    var diff_x:Number = gravPoint_x - n.pos_x;
                    var diff_y:Number = gravPoint_y - n.pos_y;
                    var acc:Number = _force / (diff_x * diff_x + diff_y * diff_y);
                    var acc_x:Number = acc * diff_x;
                    var acc_y:Number = acc * diff_y;
                    n.v_x += acc_x - acc_y*n.weight;
                    n.v_y += acc_y + acc_x*n.weight;
                }
                
                n.pos_x += n.v_x;
                n.pos_y += n.v_y;
                
                n.v_x *= 0.96;
                n.v_y *= 0.96;
                
                if(calc)
                {
                    if (n.pos_x > 465)
                        n.pos_x -= 465;
                    else if (n.pos_x < 0)
                        n.pos_x += 465;
                    if (n.pos_y > 465)
                        n.pos_y -= 465;
                    else if (n.pos_y < 0)
                        n.pos_y += 465;
                }
                
                this._bmd.setPixel(n.pos_x >> 0, n.pos_y >> 0, n.color); 
            }
            while (n = n.next);
            this._bmd.colorTransform(this._bmdRect, this._colorTransform);
            this._bmd.unlock();
            
            _cnt ++;
        }
        
        
        private function switchForce( e:MouseEvent ):void {
            _force = ( _force > 0 ) ? -100 : 200;
            _colorTransform = ( _force > 0 ) ? ATTRACTIVE_CTF : REPULSIVE_CTF;
        }
    }
}

final class Node
{
    public var v_x:Number = 0;
    public var v_y:Number = 0;
    public var pos_x:Number = 0;
    public var pos_y:Number = 0;
    public var weight:Number = 1;
    public var color:uint = 0xffffff;
    public var next:Node;
}
