/**
 * Copyright set0 ( http://wonderfl.net/user/set0 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/gJV7
 */

package {
    import flash.display.*;
    import flash.events.*;
    import flash.filters.*;
    import flash.text.*;
    
    [SWF(width=465, height=465, frameRate=60, backgroundColor=0x000000)]
    
    public class FlashTest extends Sprite
    {
      
        private var color_array:Array = [0xff0000, 0x0000ff, 0xff0000, 0x0000ff];
        private var old_x_array:Array = [0, 0, 0, 0];
        private var old_y_array:Array = [0, 0, 0, 0];
        private var tmp_x_array:Array = [0, 0, 0, 0];
        private var tmp_y_array:Array = [0, 0, 0, 0];
        private var sp_array:Array = [];
        private var txt:TextField;
       
        public function FlashTest()
        {
      
           for(var i:int=0;i<4;i++) {
               sp_array[i] = new Sprite();
               sp_array[i] = makeSprite(i);
               drawRing(sp_array[i], i);
           }
           
           addEventListener(Event.ENTER_FRAME, onEnterFrame);
        }
          
        private function drawLines(now_x:Number, now_y:Number, i:int):void
        {
            var sp:Sprite = new Sprite();

            addChild(sp);            
            sp.graphics.lineStyle(1, 0xffffff, 0.8, false, "none");
            sp.graphics.moveTo (old_x_array[i], old_y_array[i]);
            sp.graphics.lineTo(now_x, now_y);
            sp.filters = [new GlowFilter(color_array[i])];
            
            old_x_array[i] = now_x;
            old_y_array[i] = now_y;
            
            sp.addEventListener(Event.ENTER_FRAME, onEnterFrameLine);
       
        }
        
        private function makeSprite(i:int):Sprite
        {
            var sp:Sprite = new Sprite();
            addChild(sp);
            sp.x = i * 10;
            sp.y = i * 10;
            
            return sp;
        }
        
        private function drawRing(sp:Sprite, i:int):void
        {
            sp.graphics.lineStyle(1, 0xffffff, 0.8, false, "none");
            sp.graphics.beginFill(0xffffff, 1.0);
            sp.graphics.drawCircle(0, 0, 1);
            sp.filters = [new GlowFilter(color_array[i])];
       
        }
        
        
        
        private function onEnterFrame(event:Event):void
        {
           var sp:Sprite = event.target as Sprite;
           
           for(var i:int=0;i<4;i++) {
               tmp_x_array[i] += (stage.mouseX - sp_array[i].x)/20;
               tmp_y_array[i] += (stage.mouseY - sp_array[i].y)/20;
           
               tmp_x_array[i] *= (0.92 - i * 0.03);
               tmp_y_array[i] *= (0.92 - i * 0.03);
           
               sp_array[i].x += tmp_x_array[i];
               sp_array[i].y += tmp_y_array[i];
            
               drawLines(sp_array[i].x, sp_array[i].y, i);
               setChildIndex(sp_array[i],this.numChildren-1);
           }
           
           
           
        }
        
        private function onEnterFrameLine(event:Event):void
        {
            var sp:Sprite = event.target as Sprite;
             
            if(sp.alpha >= 0) {
                sp.alpha  -= 0.02;
            } else {
                sp.graphics.clear();
                sp.removeEventListener(Event.ENTER_FRAME, onEnterFrame);
                removeChild(sp);
                sp = null;
            }
       }
       
}
    
}